/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.model.documento;

import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.firma.TFirmaUbicacion;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="t_documento")
public class TDocumento {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String codigoDoc;
    private String nombreDoc;
    private LocalDateTime fechaRegistro = LocalDateTime.now();
    private LocalDateTime fechaFirmado;
    @Column(columnDefinition="TEXT")
    private String pdfBase64;
    @Column(columnDefinition="TEXT")
    private String pdfBase64Signed;
    private boolean firmado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="solicitud_id")
    private TSolicitud solicitud;
    @OneToMany(mappedBy="documento", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<TFirmaUbicacion> firmaUbicaciones = new ArrayList();

    public TDocumento(String codigoDoc, String nombreDoc, String pdfBase64, TSolicitud solicitud) {
        this.codigoDoc = codigoDoc;
        this.nombreDoc = nombreDoc;
        this.pdfBase64 = pdfBase64;
        this.firmado = false;
        this.solicitud = solicitud;
    }

    public TDocumento(String codigoDoc, String nombreDoc, String pdfBase64Signed, boolean firmado) {
        this.codigoDoc = codigoDoc;
        this.nombreDoc = nombreDoc;
        this.pdfBase64Signed = pdfBase64Signed;
        this.firmado = firmado;
        this.fechaFirmado = LocalDateTime.now();
    }

    @Generated
    public TDocumento(Long id, String codigoDoc, String nombreDoc, LocalDateTime fechaRegistro, LocalDateTime fechaFirmado, String pdfBase64, String pdfBase64Signed, boolean firmado, TSolicitud solicitud, List<TFirmaUbicacion> firmaUbicaciones) {
        this.id = id;
        this.codigoDoc = codigoDoc;
        this.nombreDoc = nombreDoc;
        this.fechaRegistro = fechaRegistro;
        this.fechaFirmado = fechaFirmado;
        this.pdfBase64 = pdfBase64;
        this.pdfBase64Signed = pdfBase64Signed;
        this.firmado = firmado;
        this.solicitud = solicitud;
        this.firmaUbicaciones = firmaUbicaciones;
    }

    @Generated
    public TDocumento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCodigoDoc() {
        return this.codigoDoc;
    }

    @Generated
    public String getNombreDoc() {
        return this.nombreDoc;
    }

    @Generated
    public LocalDateTime getFechaRegistro() {
        return this.fechaRegistro;
    }

    @Generated
    public LocalDateTime getFechaFirmado() {
        return this.fechaFirmado;
    }

    @Generated
    public String getPdfBase64() {
        return this.pdfBase64;
    }

    @Generated
    public String getPdfBase64Signed() {
        return this.pdfBase64Signed;
    }

    @Generated
    public boolean isFirmado() {
        return this.firmado;
    }

    @Generated
    public TSolicitud getSolicitud() {
        return this.solicitud;
    }

    @Generated
    public List<TFirmaUbicacion> getFirmaUbicaciones() {
        return this.firmaUbicaciones;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigoDoc(String codigoDoc) {
        this.codigoDoc = codigoDoc;
    }

    @Generated
    public void setNombreDoc(String nombreDoc) {
        this.nombreDoc = nombreDoc;
    }

    @Generated
    public void setFechaRegistro(LocalDateTime fechaRegistro) {
        this.fechaRegistro = fechaRegistro;
    }

    @Generated
    public void setFechaFirmado(LocalDateTime fechaFirmado) {
        this.fechaFirmado = fechaFirmado;
    }

    @Generated
    public void setPdfBase64(String pdfBase64) {
        this.pdfBase64 = pdfBase64;
    }

    @Generated
    public void setPdfBase64Signed(String pdfBase64Signed) {
        this.pdfBase64Signed = pdfBase64Signed;
    }

    @Generated
    public void setFirmado(boolean firmado) {
        this.firmado = firmado;
    }

    @Generated
    public void setSolicitud(TSolicitud solicitud) {
        this.solicitud = solicitud;
    }

    @Generated
    public void setFirmaUbicaciones(List<TFirmaUbicacion> firmaUbicaciones) {
        this.firmaUbicaciones = firmaUbicaciones;
    }

    @Generated
    public String toString() {
        return "TDocumento(id=" + this.getId() + ", codigoDoc=" + this.getCodigoDoc() + ", nombreDoc=" + this.getNombreDoc() + ", fechaRegistro=" + this.getFechaRegistro() + ", fechaFirmado=" + this.getFechaFirmado() + ", pdfBase64=" + this.getPdfBase64() + ", pdfBase64Signed=" + this.getPdfBase64Signed() + ", firmado=" + this.isFirmado() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDocumento)) {
            return false;
        }
        TDocumento other = (TDocumento)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TDocumento;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

