/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.model;

import com.tws2.firma_s.logic.model.documento.TDocumento;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.URL;

@Entity
@Table(name="t_solicitud")
public class TSolicitud
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=100, unique=true, nullable=false)
    @Size(max=100)
    private @Size(max=100) String referenceTransaction;
    @Column(length=50, nullable=false)
    private String fingerCode;
    @Size(min=10, max=25)
    private @Size(min=10, max=25) String cellphoneNumber;
    @Column(length=50, nullable=false)
    private String city;
    @Column(length=100, nullable=false)
    @Size(min=15, max=100)
    private @Size(min=15, max=100) String address;
    @Column(length=500, nullable=false)
    @URL(message="Debe ser una URL v\u00e1lida")
    private @URL(message="Debe ser una URL v\u00e1lida") String callbackUrl;
    @Column(length=50, nullable=false)
    private String identificationNumber;
    @Column(nullable=false)
    private Integer validationLinkLifeTime;
    @Column(nullable=false)
    @Email(message="Debe ser un correo v\u00e1lido")
    private @Email(message="Debe ser un correo v\u00e1lido") String email;
    private LocalDateTime dateRegistry;
    @OneToMany(mappedBy="solicitud", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<TDocumento> documentos = new ArrayList();

    public TSolicitud(String referenceTransacction, String fingerCode, String cellphoneNumber, String city, String address, String email, int validationLinkLifeTime, String identificationNumber, String callbackUrl) {
        this.referenceTransaction = referenceTransacction;
        this.fingerCode = fingerCode;
        this.cellphoneNumber = cellphoneNumber;
        this.city = city;
        this.address = address;
        this.email = email;
        this.validationLinkLifeTime = validationLinkLifeTime;
        this.identificationNumber = identificationNumber;
        this.callbackUrl = callbackUrl;
        this.dateRegistry = LocalDateTime.now();
    }

    public TSolicitud(String referenceTransaction, String fingerCode, String cellphoneNumber, String city, String address, String callbackUrl, String identificationNumber, Integer validationLinkLifeTime, String email, List<TDocumento> documentos) {
        this.referenceTransaction = referenceTransaction;
        this.fingerCode = fingerCode;
        this.cellphoneNumber = cellphoneNumber;
        this.city = city;
        this.address = address;
        this.callbackUrl = callbackUrl;
        this.identificationNumber = identificationNumber;
        this.validationLinkLifeTime = validationLinkLifeTime;
        this.email = email;
        this.dateRegistry = LocalDateTime.now();
        this.documentos = documentos;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getReferenceTransaction() {
        return this.referenceTransaction;
    }

    @Generated
    public String getFingerCode() {
        return this.fingerCode;
    }

    @Generated
    public String getCellphoneNumber() {
        return this.cellphoneNumber;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    @Generated
    public Integer getValidationLinkLifeTime() {
        return this.validationLinkLifeTime;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public LocalDateTime getDateRegistry() {
        return this.dateRegistry;
    }

    @Generated
    public List<TDocumento> getDocumentos() {
        return this.documentos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setReferenceTransaction(String referenceTransaction) {
        this.referenceTransaction = referenceTransaction;
    }

    @Generated
    public void setFingerCode(String fingerCode) {
        this.fingerCode = fingerCode;
    }

    @Generated
    public void setCellphoneNumber(String cellphoneNumber) {
        this.cellphoneNumber = cellphoneNumber;
    }

    @Generated
    public void setCity(String city) {
        this.city = city;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    @Generated
    public void setValidationLinkLifeTime(Integer validationLinkLifeTime) {
        this.validationLinkLifeTime = validationLinkLifeTime;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setDateRegistry(LocalDateTime dateRegistry) {
        this.dateRegistry = dateRegistry;
    }

    @Generated
    public void setDocumentos(List<TDocumento> documentos) {
        this.documentos = documentos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSolicitud)) {
            return false;
        }
        TSolicitud other = (TSolicitud)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$validationLinkLifeTime = this.getValidationLinkLifeTime();
        Integer other$validationLinkLifeTime = other.getValidationLinkLifeTime();
        if (this$validationLinkLifeTime == null ? other$validationLinkLifeTime != null : !((Object)this$validationLinkLifeTime).equals(other$validationLinkLifeTime)) {
            return false;
        }
        String this$referenceTransaction = this.getReferenceTransaction();
        String other$referenceTransaction = other.getReferenceTransaction();
        if (this$referenceTransaction == null ? other$referenceTransaction != null : !this$referenceTransaction.equals(other$referenceTransaction)) {
            return false;
        }
        String this$fingerCode = this.getFingerCode();
        String other$fingerCode = other.getFingerCode();
        if (this$fingerCode == null ? other$fingerCode != null : !this$fingerCode.equals(other$fingerCode)) {
            return false;
        }
        String this$cellphoneNumber = this.getCellphoneNumber();
        String other$cellphoneNumber = other.getCellphoneNumber();
        if (this$cellphoneNumber == null ? other$cellphoneNumber != null : !this$cellphoneNumber.equals(other$cellphoneNumber)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        if (this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl)) {
            return false;
        }
        String this$identificationNumber = this.getIdentificationNumber();
        String other$identificationNumber = other.getIdentificationNumber();
        if (this$identificationNumber == null ? other$identificationNumber != null : !this$identificationNumber.equals(other$identificationNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        LocalDateTime this$dateRegistry = this.getDateRegistry();
        LocalDateTime other$dateRegistry = other.getDateRegistry();
        if (this$dateRegistry == null ? other$dateRegistry != null : !((Object)this$dateRegistry).equals(other$dateRegistry)) {
            return false;
        }
        List this$documentos = this.getDocumentos();
        List other$documentos = other.getDocumentos();
        return !(this$documentos == null ? other$documentos != null : !((Object)this$documentos).equals(other$documentos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TSolicitud;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $validationLinkLifeTime = this.getValidationLinkLifeTime();
        result = result * 59 + ($validationLinkLifeTime == null ? 43 : ((Object)$validationLinkLifeTime).hashCode());
        String $referenceTransaction = this.getReferenceTransaction();
        result = result * 59 + ($referenceTransaction == null ? 43 : $referenceTransaction.hashCode());
        String $fingerCode = this.getFingerCode();
        result = result * 59 + ($fingerCode == null ? 43 : $fingerCode.hashCode());
        String $cellphoneNumber = this.getCellphoneNumber();
        result = result * 59 + ($cellphoneNumber == null ? 43 : $cellphoneNumber.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        String $identificationNumber = this.getIdentificationNumber();
        result = result * 59 + ($identificationNumber == null ? 43 : $identificationNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        LocalDateTime $dateRegistry = this.getDateRegistry();
        result = result * 59 + ($dateRegistry == null ? 43 : ((Object)$dateRegistry).hashCode());
        List $documentos = this.getDocumentos();
        result = result * 59 + ($documentos == null ? 43 : ((Object)$documentos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TSolicitud(id=" + this.getId() + ", referenceTransaction=" + this.getReferenceTransaction() + ", fingerCode=" + this.getFingerCode() + ", cellphoneNumber=" + this.getCellphoneNumber() + ", city=" + this.getCity() + ", address=" + this.getAddress() + ", callbackUrl=" + this.getCallbackUrl() + ", identificationNumber=" + this.getIdentificationNumber() + ", validationLinkLifeTime=" + this.getValidationLinkLifeTime() + ", email=" + this.getEmail() + ", dateRegistry=" + this.getDateRegistry() + ", documentos=" + this.getDocumentos() + ")";
    }

    @Generated
    public TSolicitud(Long id, String referenceTransaction, String fingerCode, String cellphoneNumber, String city, String address, String callbackUrl, String identificationNumber, Integer validationLinkLifeTime, String email, LocalDateTime dateRegistry, List<TDocumento> documentos) {
        this.id = id;
        this.referenceTransaction = referenceTransaction;
        this.fingerCode = fingerCode;
        this.cellphoneNumber = cellphoneNumber;
        this.city = city;
        this.address = address;
        this.callbackUrl = callbackUrl;
        this.identificationNumber = identificationNumber;
        this.validationLinkLifeTime = validationLinkLifeTime;
        this.email = email;
        this.dateRegistry = dateRegistry;
        this.documentos = documentos;
    }

    @Generated
    public TSolicitud() {
    }
}

