/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.interceptors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.utils.ApiResponse;
import jakarta.persistence.EntityNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<ApiResponse<?>> handleCustomException(CustomException ex, HttpServletRequest request) {
        HttpStatus status = ex.getHttpStatus() != null ? ex.getHttpStatus() : HttpStatus.BAD_REQUEST;
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("message", ex.getMessage());
        body.put("missing", ex.getDetails());
        body.put("path", request.getRequestURI());
        body.put("timestamp", OffsetDateTime.now().toString());
        return ResponseEntity.status((HttpStatusCode)status).body((Object)ApiResponse.error((int)status.value(), body));
    }

    @ExceptionHandler(value={JsonProcessingException.class})
    public ResponseEntity<ApiResponse<?>> handleJsonError(JsonProcessingException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)400, (String)("JSON malformado: " + ex.getOriginalMessage())));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiResponse<?>> handleValidationErrors(MethodArgumentNotValidException ex) {
        HashMap errores = new HashMap();
        ex.getBindingResult().getFieldErrors().forEach(err -> errores.put(err.getField(), err.getDefaultMessage()));
        return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, errores));
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ApiResponse<?>> handleNotFound(EntityNotFoundException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((int)404, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public ResponseEntity<ApiResponse<Object>> handleAsyncRequestTimeoutException() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.REQUEST_TIMEOUT).body((Object)ApiResponse.error((int)408, (String)"La solicitud ha tardado demasiado tiempo en procesarse."));
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<ApiResponse<?>> handleDataIntegrityViolation(DataIntegrityViolationException ex) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            String mensaje = cause.getMessage();
            if (mensaje == null || !mensaje.toLowerCase().contains("llave duplicada")) continue;
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)ApiResponse.error((int)409, (String)"Ya existe una solicitud registrada con este n\u00famero de tr\u00e1mite."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)400, (String)("Violaci\u00f3n de restricci\u00f3n de datos: " + ex.getMessage())));
    }

    @ExceptionHandler(value={HttpClientErrorException.Unauthorized.class})
    public ResponseEntity<ApiResponse<?>> handleUnauthorized(HttpClientErrorException.Unauthorized ex, HttpServletRequest request) {
        String low;
        String auth;
        String string = auth = ex.getResponseHeaders() != null ? ex.getResponseHeaders().getFirst("WWW-Authenticate") : null;
        String msg = auth != null ? ((low = auth.toLowerCase()).contains("expired") || low.contains("invalid_token") ? "Token caducado o inv\u00e1lido." : "No autorizado.") : "No autorizado.";
        String body = ex.getResponseBodyAsString();
        if (body != null && !body.isBlank() && body.length() < 500) {
            msg = body;
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)ApiResponse.error((int)401, (String)msg));
    }

    @ExceptionHandler(value={RestClientResponseException.class})
    public ResponseEntity<ApiResponse<?>> handleRestClientResponse(RestClientResponseException ex, HttpServletRequest request) {
        Object msg;
        HttpStatus status = HttpStatus.resolve((int)ex.getRawStatusCode());
        if (status == null) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        if ((msg = ex.getResponseBodyAsString()) == null || ((String)msg).isBlank()) {
            msg = "Error al invocar servicio externo (" + status.value() + ").";
        }
        return ResponseEntity.status((HttpStatusCode)status).body((Object)ApiResponse.error((int)status.value(), (String)msg));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<?>> handleGeneric(Exception ex) {
        log.error("ERROR no manejado", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (String)("Error interno del servidor: " + ex.getMessage())));
    }
}

