/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.model.dto.DocumentDTO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ValidationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void ValidarSolicitud(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, String validationLinkLifeTime, String email) {
        StringBuilder errores = new StringBuilder();
        if (referenceTransaction == null || referenceTransaction.isEmpty()) {
            errores.append("referenceTransaction es un campo obligatorio");
        }
        if (fingerCode == null || fingerCode.isEmpty()) {
            errores.append("El codigo Dactilar (fingerCode) es un campo obligatorio");
        }
        if (telefono == null || telefono.isEmpty()) {
            errores.append("El numero de contacto es obligatorio");
        }
        if (city == null || city.isEmpty()) {
            errores.append("la ciudad es un campo obligatorio");
        }
        if (address == null || address.isEmpty()) {
            errores.append("La direcci\u00f3n es un campo obligatorio");
        }
        if (callbackUrl == null || callbackUrl.isEmpty()) {
            errores.append("El callbackUrl es un campo obligatorio");
        }
        if (identificationNumber == null || identificationNumber.isEmpty()) {
            errores.append("El n\u00famero de identificaci\u00f3n es obligatorio");
        }
        if (email == null || email.isEmpty()) {
            errores.append("El correo electr\u00f3nico es un campo obligatorio");
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "faltan los siguientes parametros" + errores.toString();
            throw new CustomException("Faltan los siguientes parametros" + errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void validarParamsFirmaFlujoUnico(String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String callback, String motivo, String origen) {
        StringBuilder missingParams = new StringBuilder();
        if (codigoCliente == null || codigoCliente.isEmpty()) {
            missingParams.append("codigoCliente, ");
        }
        if (identificacion == null || identificacion.isEmpty()) {
            missingParams.append("identificacion, ");
        }
        if (nombres == null || nombres.isEmpty()) {
            missingParams.append("nombres, ");
        }
        if (apellidoPaterno == null || apellidoPaterno.isEmpty()) {
            missingParams.append("apellido_paterno, ");
        }
        if (apellidoMaterno == null || apellidoMaterno.isEmpty()) {
            missingParams.append("apellido_materno, ");
        }
        if (email == null || email.isEmpty()) {
            missingParams.append("email, ");
        }
        if (celular == null || celular.isEmpty()) {
            missingParams.append("celular, ");
        }
        if (domicilio == null || domicilio.isEmpty()) {
            missingParams.append("domicilio, ");
        }
        if (ciudad == null || ciudad.isEmpty()) {
            missingParams.append("ciudad, ");
        }
        if (documentos == null || documentos.isEmpty()) {
            missingParams.append("documentos, ");
        }
        if (callback == null || callback.isEmpty()) {
            missingParams.append("callback, ");
        }
        if (motivo == null || motivo.isEmpty()) {
            missingParams.append("motivo, ");
        }
        if (missingParams.length() > 0) {
            missingParams.setLength(missingParams.length() - 2);
            String errorMessage = "Faltan los siguientes par\u00e1metros: " + missingParams.toString();
            throw new CustomException(errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void ValidarSolicitudDocumentos(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, String validationLinkLifeTime, String email, String documentos) {
        StringBuilder errores = new StringBuilder();
        if (referenceTransaction == null || referenceTransaction.isEmpty()) {
            errores.append("referenceTransaction es un campo obligatorio");
        }
        if (fingerCode == null || fingerCode.isEmpty()) {
            errores.append("El codigo Dactilar (fingerCode) es un campo obligatorio");
        }
        if (telefono == null || telefono.isEmpty()) {
            errores.append("El numero de contacto es obligatorio");
        }
        if (city == null || city.isEmpty()) {
            errores.append("la ciudad es un campo obligatorio");
        }
        if (address == null || address.isEmpty()) {
            errores.append("La direcci\u00f3n es un campo obligatorio");
        }
        if (callbackUrl == null || callbackUrl.isEmpty()) {
            errores.append("El callbackUrl es un campo obligatorio");
        }
        if (identificationNumber == null || identificationNumber.isEmpty()) {
            errores.append("El n\u00famero de identificaci\u00f3n es obligatorio");
        }
        if (email == null || email.isEmpty()) {
            errores.append("El correo electr\u00f3nico es un campo obligatorio");
        }
        if (documentos == null || documentos.isEmpty()) {
            errores.append("El campo 'documentos' es obligatorio y no puede estar vac\u00edo. ");
        } else {
            try {
                ObjectMapper mapper = new ObjectMapper();
                List listaDocs = (List)mapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (listaDocs.isEmpty()) {
                    errores.append("Debe enviar al menos un documento en 'documentos'. ");
                } else {
                    for (DocumentDTO doc : listaDocs) {
                        if (doc.getCodigoDocumento() == null || doc.getCodigoDocumento().isEmpty()) {
                            errores.append("codigoDoc es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getNombre() == null || doc.getNombre().isEmpty()) {
                            errores.append("nombreDoc es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getArchivoBase64() == null || doc.getArchivoBase64().isEmpty()) {
                            errores.append("pdfBase64 es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getCoordenada() == null || doc.getCoordenada().isEmpty()) {
                            errores.append("Debe proporcionar al menos una coordenada por documento. ");
                        }
                        if (doc.getPagina() == null || doc.getPagina().isEmpty()) {
                            errores.append("Debe proporcionar al menos una pagina por documento. ");
                        }
                        if (doc.getTipo() != null && !doc.getTipo().isEmpty()) continue;
                        errores.append("Debe proporcionar al menos una tipo por documento. ");
                    }
                }
            }
            catch (Exception e) {
                errores.append("El formato del campo 'documentos' no es v\u00e1lido JSON. ");
            }
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "faltan los siguientes parametros" + errores.toString();
            throw new CustomException("Faltan los siguientes parametros" + errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static JsonNode validateBiometricObject(String jsonRaw) {
        try {
            JsonNode root = MAPPER.readTree(jsonRaw);
            if (!root.has("status") || !root.has("referenceTransaction")) {
                throw new IllegalArgumentException("Faltan campos esenciales: status o referenceTransaction");
            }
            if (root.has("data") && root.get("data").has("imageData")) {
                for (JsonNode image : root.get("data").get("imageData")) {
                    if (image.get("image") != null && !image.get("image").asText().isBlank()) continue;
                    ((ObjectNode)image).put("image", "");
                }
            }
            if ("ERROR".equalsIgnoreCase(root.get("status").asText()) && !root.has("errorMessage")) {
                ((ObjectNode)root).set("errorMessage", (JsonNode)MAPPER.createObjectNode().put("error", "Error no especificado"));
            }
            if (!root.has("indicator")) {
                ((ObjectNode)root).set("indicator", (JsonNode)MAPPER.createObjectNode());
            }
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("JSON inv\u00e1lido o malformado", e);
        }
    }

    public static String validationLifeTimeLink(String lifeTimeLink) {
        if (lifeTimeLink.isEmpty()) {
            lifeTimeLink = "1440";
        }
        return lifeTimeLink;
    }
}

