/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.utils;

import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.biometria.TDataBiometria;
import com.tws2.firma_s.logic.model.biometria.TImageData;
import com.tws2.firma_s.logic.model.biometria.TIndicadorSeccion;
import com.tws2.firma_s.logic.model.biometria.TIndicadores;
import com.tws2.firma_s.logic.model.biometria.TMetadata;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UtilMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtilMapper.class);

    public static Map<String, Object> construirPreCallback(String referenceTransaction) {
        log.info("Construyendo callback para la transaccion PROCENSANDO");
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("status", 200);
        response.put("tipo", "PRUEBA_VIDA_PROCESANDO");
        response.put("codigo", referenceTransaction);
        return response;
    }

    public static Map<String, Object> construirCallback(TCallbackBiometria callback) {
        log.info("Construyendo callback para la transaccion PROCESADO");
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("status", 200);
        response.put("tipo", "PRUEBA_VIDA");
        response.put("codigo", callback.getReferenceTransaction());
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        TDataBiometria dataBio = callback.getData();
        if (dataBio != null) {
            data.put("ip_registrada", dataBio.getIp());
            data.put("bio_intento_frontal", dataBio.getFrontAttempt());
            data.put("bio_intento_reverso", dataBio.getBackAttempt());
            data.put("bio_intento_selfie", dataBio.getSelfieAttempt());
            data.put("bio_intento_dactilar", 1);
            if (dataBio.getImageData() != null) {
                for (TImageData img : dataBio.getImageData()) {
                    switch (img.getType()) {
                        case "IDENTIFICATION_FRONT": {
                            data.put("img_frontal", img.getImage());
                            data.put("rostroSimilitudFrontal", img.getSimilarity());
                            break;
                        }
                        case "IDENTIFICATION_BACK": {
                            data.put("img_reverso", img.getImage());
                            break;
                        }
                        case "IDENTIFICATION_SELFIE": {
                            data.put("img_selfie", img.getImage());
                            data.put("rostroSimilitudSelfie", img.getSimilarity());
                            data.put("rostroSimilitud", img.getSimilarity());
                        }
                    }
                }
            }
        }
        response.put("data", data);
        TIndicadores indicadores = callback.getIndicator();
        LinkedHashMap indicadoresMap = new LinkedHashMap();
        if (indicadores != null) {
            if (indicadores.getFront() != null) {
                TIndicadorSeccion front = indicadores.getFront();
                LinkedHashMap<String, String> anversoMap = new LinkedHashMap<String, String>();
                anversoMap.put("identificacion", front.getIdentificationNumber());
                anversoMap.put("metadata", front.getMetadata());
                anversoMap.put("esFotoEspejo", "no");
                indicadoresMap.put("anverso", anversoMap);
            }
            if (indicadores.getBack() != null) {
                TIndicadorSeccion back = indicadores.getBack();
                LinkedHashMap<String, String> reversoMap = new LinkedHashMap<String, String>();
                reversoMap.put("codigoDactilar", back.getFingerCode());
                reversoMap.put("metadata", back.getMetadata());
                String confidence = indicadores.getConfidence();
                reversoMap.put("confianza", confidence);
                reversoMap.put("confianza_indicadores", confidence);
                reversoMap.put("codigoDactilarEncontrado", back.getFingerCode());
                indicadoresMap.put("reverso", reversoMap);
            }
            if (indicadores.getMetadata() != null) {
                TMetadata meta = indicadores.getMetadata();
                LinkedHashMap metadata = new LinkedHashMap();
                LinkedHashMap<String, String> procesadaMap = new LinkedHashMap<String, String>();
                procesadaMap.put("identificacion", meta.getProcessed().getIdentificationNumber());
                procesadaMap.put("nombre_completo", meta.getProcessed().getFullName());
                procesadaMap.put("codigo_dactilar", meta.getProcessed().getFingerCode());
                procesadaMap.put("nacionalidad", callback.getSolicitud().getCity());
                procesadaMap.put("estado_civil", "");
                procesadaMap.put("sexo", "");
                procesadaMap.put("fecha_nacimiento", meta.getProcessed().getBirthDate());
                procesadaMap.put("lugar_nacimiento", meta.getProcessed().getBirthPlace());
                procesadaMap.put("fecha_emision", meta.getProcessed().getExpeditionDate());
                procesadaMap.put("fecha_caducidad", meta.getProcessed().getExpirationDate());
                metadata.put("procesada", procesadaMap);
                LinkedHashMap<String, String> referenciaMap = new LinkedHashMap<String, String>();
                referenciaMap.put("identificacion", callback.getSolicitud().getIdentificationNumber());
                referenciaMap.put("codigo_dactilar", callback.getSolicitud().getFingerCode());
                referenciaMap.put("fecha_nacimiento", meta.getProcessed().getBirthDate());
                referenciaMap.put("fecha_mayor_edad", meta.getProcessed().getOlderAgeDate());
                referenciaMap.put("edad_actual", meta.getProcessed().getCurrentAge());
                referenciaMap.put("fecha_actual", meta.getProcessed().getCurrentDate());
                metadata.put("referencia", referenciaMap);
                LinkedHashMap<String, Object> resultadoMap = new LinkedHashMap<String, Object>();
                resultadoMap.put("ok_selfie_fuente", meta.getResult().getSelfie());
                resultadoMap.put("es_selfie_valida", true);
                resultadoMap.put("ok_frontal_fuente", meta.getResult().getFront());
                resultadoMap.put("existe_fuente", true);
                resultadoMap.put("cliente_en_lista_blanca", true);
                resultadoMap.put("codigo_dactilar_detectado", true);
                resultadoMap.put("es_cedula_mayor_edad", meta.getResult().getAdult());
                resultadoMap.put("es_cedula_vigente", meta.getResult().getCurrentDocument());
                resultadoMap.put("es_horario_valido", true);
                resultadoMap.put("fecha_nacimiento_detectada", true);
                resultadoMap.put("identificacion_detectada", true);
                resultadoMap.put("selfie_intentos_moderado", true);
                resultadoMap.put("texto_resumen", "");
                metadata.put("resultado", resultadoMap);
                indicadoresMap.put("metadata", metadata);
            }
        }
        response.put("indicadores", indicadoresMap);
        response.put("fecha_respuesta", LocalDateTime.now().toString().replace('T', ' '));
        return response;
    }

    @Generated
    public UtilMapper() {
    }
}

