/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.data.DataFirmaS;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.TSolicitudResponse;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.dto.DocumentDTO;
import com.tws2.firma_s.logic.model.dto.SolicitudResponseDTO;
import com.tws2.firma_s.logic.model.firma.TFirmaUbicacion;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.repository.SolicitudDAO;
import com.tws2.firma_s.logic.repository.SolicitudResponseDAO;
import com.tws2.firma_s.logic.restTemplate.service.FirmaSeguraServiceAPI;
import com.tws2.firma_s.logic.service.SolicitudService;
import com.tws2.firma_s.utils.ApiResponse;
import com.tws2.firma_s.utils.DecriptUtils;
import com.tws2.firma_s.utils.GenerateRandomUtils;
import com.tws2.firma_s.utils.ValidationUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SolicitudServiceImpl
implements SolicitudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolicitudServiceImpl.class);
    private final SolicitudDAO solicitudDAO;
    private final SolicitudResponseDAO solicitudResponseDAO;
    private final FirmaSeguraServiceAPI firmaSeguraServiceAPI;
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaUbicacionDAO;
    private final DecriptUtils decriptUtils;
    private final Environment env;

    @Transactional
    public ResponseEntity<ApiResponse<?>> saveSolicitud(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, Integer validationLinkLifeTime, String email) {
        TSolicitud solicitud = new TSolicitud(referenceTransaction, this.decriptUtils.encrypt(fingerCode), telefono, city, address, email, validationLinkLifeTime.intValue(), this.decriptUtils.encrypt(identificationNumber), callbackUrl);
        solicitud = this.decriptUtils.encryptSolicitud(solicitud, this.decriptUtils);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transaccion", HttpStatus.BAD_REQUEST);
        }
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        ResponseEntity firma = this.firmaSeguraServiceAPI.sendToFirmaSegura(referenceTransaction, fingerCode, telefono, city, address, this.env.getProperty("tws.callback.bio-firm"), identificationNumber, validationLinkLifeTime.intValue(), email);
        solicitudResponse.setSolicitud(savedSolicitud);
        solicitudResponse.setUrl(((DataFirmaS)firma.getBody()).getValidationLink());
        solicitudResponse.setLinkExpirationDate(((DataFirmaS)firma.getBody()).getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(((DataFirmaS)firma.getBody()).getRegistrationDate());
        solicitudResponse.setCodigo(((DataFirmaS)firma.getBody()).getTransactionalSignatureRequestId());
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)((DataFirmaS)firma.getBody())), (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional
    public ResponseEntity<ApiResponse<?>> SolicitudGenericBiometriaFirma(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String motivo, String origen, String callback, String validationLifeTimeLink, String canal) throws JsonMappingException, JsonProcessingException {
        String fullName = nombres + " " + apellidoPaterno + " " + apellidoMaterno;
        String referenceTransaction = GenerateRandomUtils.generarIdentificadorAleatorio();
        String validationLinkLifeTime = ValidationUtils.validationLifeTimeLink((String)validationLifeTimeLink);
        ObjectMapper objectMapper = new ObjectMapper();
        TSolicitud solicitud = new TSolicitud(codigoCliente, fullName, referenceTransaction, codigoDactilar, celular, ciudad, domicilio, callback, identificacion, Integer.valueOf(Integer.parseInt(validationLinkLifeTime)), email, origen, canal, motivo);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transacci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        List documentosDto = (List)objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DocumentDTO docDto : documentosDto) {
            TDocumento documento = new TDocumento();
            documento.setCodigoDocumento(docDto.getCodigoDocumento());
            documento.setNombre(docDto.getNombre());
            documento.setTipo(docDto.getTipo());
            documento.setPagina(docDto.getPagina());
            documento.setCoordenada(docDto.getCoordenada());
            documento.setArchivoBase64(docDto.getArchivoBase64());
            documento.setFechaRegistro(LocalDateTime.now());
            documento.setSolicitud(savedSolicitud);
            TDocumento savedDoc = (TDocumento)this.documentoDAO.save((Object)documento);
            if (docDto.getCoordenada() == null || docDto.getCoordenada().isEmpty()) continue;
            String[] parts = docDto.getCoordenada().split(",");
            TFirmaUbicacion firma = new TFirmaUbicacion();
            firma.setDocumento(savedDoc);
            firma.setPagina(docDto.getPagina());
            firma.setPosX(parts.length > 0 ? parts[0] : null);
            firma.setPosY(parts.length > 1 ? parts[1] : null);
            firma.setFechaCreacion(LocalDateTime.now());
            this.firmaUbicacionDAO.save((Object)firma);
        }
        log.info("contacto : {}", (Object)celular);
        ResponseEntity responseFirma = this.firmaSeguraServiceAPI.sendToFirmaSegura(referenceTransaction, codigoDactilar, celular, ciudad, domicilio, this.env.getProperty("tws.callback.bio-firm"), identificacion, Integer.parseInt(validationLinkLifeTime), email);
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        SolicitudResponseDTO responseDTO = new SolicitudResponseDTO();
        solicitudResponse.setSolicitud(savedSolicitud);
        solicitudResponse.setUrl(((DataFirmaS)responseFirma.getBody()).getValidationLink());
        solicitudResponse.setLinkExpirationDate(((DataFirmaS)responseFirma.getBody()).getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(((DataFirmaS)responseFirma.getBody()).getRegistrationDate());
        solicitudResponse.setCodigo(((DataFirmaS)responseFirma.getBody()).getTransactionalSignatureRequestId());
        responseDTO.setCodigo(solicitudResponse.getCodigo());
        responseDTO.setIdentificacion(identificacion);
        responseDTO.setUrl(solicitudResponse.getUrl());
        responseDTO.setShort_url("");
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)responseDTO), (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public SolicitudServiceImpl(SolicitudDAO solicitudDAO, SolicitudResponseDAO solicitudResponseDAO, FirmaSeguraServiceAPI firmaSeguraServiceAPI, DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaUbicacionDAO, DecriptUtils decriptUtils, Environment env) {
        this.solicitudDAO = solicitudDAO;
        this.solicitudResponseDAO = solicitudResponseDAO;
        this.firmaSeguraServiceAPI = firmaSeguraServiceAPI;
        this.documentoDAO = documentoDAO;
        this.firmaUbicacionDAO = firmaUbicacionDAO;
        this.decriptUtils = decriptUtils;
        this.env = env;
    }
}

