/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.repository.CallbackBiometriaDAO;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.service.ReenvioService;
import com.tws2.firma_s.utils.UtilMapper;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ReenvioServiceImpl
implements ReenvioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReenvioServiceImpl.class);
    private final DocumentoDAO documentoDAO;
    private final CallbackBiometriaDAO biometriaDAO;
    private final RestTemplate restTemplate = new RestTemplate();

    @Async
    @Transactional
    public void reenvioBiometriaCallback(String referenceTransaction) {
        if (this.estanTodosFirmados(referenceTransaction)) {
            TCallbackBiometria callback = this.biometriaDAO.findByReferenceTransaccion(referenceTransaction);
            Map prePost = UtilMapper.construirPreCallback((String)referenceTransaction);
            this.PostToClient((Object)prePost, callback.getSolicitud().getCallbackUrl());
            Map dto = UtilMapper.construirCallback((TCallbackBiometria)callback);
            this.PostToClient((Object)dto, callback.getSolicitud().getCallbackUrl());
            this.reenvioDocumentos(referenceTransaction, callback.getSolicitud().getCallbackUrl());
        }
    }

    public void reenvioDocumentos(String referenceTransaction, String url) {
        if (this.estanTodosFirmados(referenceTransaction)) {
            int suma = 0;
            List documentos = this.documentoDAO.findAllDocumentsByReferenceTransacciontion(referenceTransaction);
            for (TDocumento doc : documentos) {
                LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
                response.put("status", 200);
                response.put("codigo", referenceTransaction);
                response.put("tipo", "ENTREGA_DOCUMENTO");
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                data.put("codigo_documento", doc.getCodigoDocumento());
                data.put("tipo", doc.getTipo());
                data.put("nombre", doc.getNombre());
                data.put("archivo", doc.getArchivoBase64Signed());
                response.put("data", data);
                String fechaRespuesta = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                response.put("fecha_respuesta", fechaRespuesta);
                this.PostToClient(response, url);
                log.info("Notificando: docs{}", (Object)suma++);
            }
        }
    }

    public <T> String PostToClient(T dto, String url) {
        log.info("Callback a notificar :{}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(dto, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public boolean estanTodosFirmados(String referenceTransaction) {
        long total = this.documentoDAO.contarTotal(referenceTransaction);
        long firmados = this.documentoDAO.contarFirmados(referenceTransaction);
        return total > 0L && total == firmados;
    }

    @Generated
    public ReenvioServiceImpl(DocumentoDAO documentoDAO, CallbackBiometriaDAO biometriaDAO) {
        this.documentoDAO = documentoDAO;
        this.biometriaDAO = biometriaDAO;
    }
}

