/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.tws2.firma_s.logic.model.CertificadoRequest;
import com.tws2.firma_s.logic.service.SolicitudService;
import com.tws2.firma_s.utils.ValidationUtils;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FirmaSeguraController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmaSeguraController.class);
    private final SolicitudService solicitudService;
    protected final Environment env;

    @PostMapping(value={"/solicitud-firma"})
    public ResponseEntity<?> guardarSolicitud(@RequestParam(value="numeroTransaccion", required=true) String noDeTramite, @RequestParam(value="codigoDactilar", required=true) String codigoDactilar, @RequestParam(value="telefono", required=true) String telefono, @RequestParam(value="ciudad", required=true) String ciudad, @RequestParam(value="direccion", required=true) String direccion, @RequestParam(value="email", required=true) String email, @RequestParam(value="tiempoValidoLink", required=true) String tiempoVidaLink, @RequestParam(value="callbackUrl", required=true) String callbackUrl, @RequestParam(value="identificacion", required=true) String identificacion) {
        log.info("Inicia proceso para guardar solicitud de firma segura");
        ValidationUtils.ValidarSolicitud((String)noDeTramite, (String)codigoDactilar, (String)telefono, (String)ciudad, (String)direccion, (String)callbackUrl, (String)identificacion, (String)tiempoVidaLink, (String)email);
        return this.solicitudService.saveSolicitud(noDeTramite, codigoDactilar, telefono, ciudad, direccion, callbackUrl, identificacion, Integer.valueOf(Integer.parseInt(tiempoVidaLink)), email);
    }

    @PostMapping(value={"/v2/solicitud/biometria_firma"})
    public ResponseEntity<?> callbiometriaFirmaFlujoUnico(@RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="codigoDactilar", required=false) String codigoDactilar, @RequestParam(value="tiempoValidoLink", required=false) String tiempoVidaLink, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="documentos", required=false) String documentos, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="motivo", required=false) String motivo, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal, @RequestParam(value="provider", required=false) String provider, @RequestParam(value="tiempoValidoLink", required=false) String tiempoValidoLink) throws JsonMappingException, JsonProcessingException {
        ValidationUtils.validarParamsFirmaFlujoUnico((String)codigoCliente, (String)identificacion, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)documentos, (String)callback, (String)motivo, (String)origen);
        return this.solicitudService.SolicitudGenericBiometriaFirma(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, motivo, origen, callback, tiempoValidoLink, canal);
    }

    @PostMapping(value={"/solicitud-multiples-firmantes"})
    public ResponseEntity<?> guardarMultiplesSolicitudes(@RequestParam(value="firmantes", required=true) String firmantes, @RequestParam(value="tiempoValidoLink", required=true) String tiempoVidaLink, @RequestParam(value="callbackUrl", required=true) String callbackUrl, @RequestParam(value="documentos", required=true) String documentos) throws JsonMappingException, JsonProcessingException, NumberFormatException {
        log.info("Inicia proceso para guardar solicitud de firma segura");
        return null;
    }

    @PostMapping(value={"/guardar"})
    public ResponseEntity<String> guardarCertificado(@RequestBody CertificadoRequest request) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(request.getBase64());
            Path path = Path.of(this.env.getProperty("ruta.temporal.firma"), request.getNombre() + ".p12");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                fos.write(decodedBytes);
            }
            return ResponseEntity.ok((Object)("Certificado guardado en: " + path.toAbsolutePath()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error al guardar el certificado: " + e.getMessage()));
        }
    }

    @Generated
    public FirmaSeguraController(SolicitudService solicitudService, Environment env) {
        this.solicitudService = solicitudService;
        this.env = env;
    }
}

