// Class with friendly descriptions for FaceTecSDK Status Enums
//
// DEVELOPER NOTE:  These properties are for demonstration purposes only to help developers in getting familiar with the FaceTec SDK Status enum values
// In the code in your own App, you should design your own methods and appropriate feedback to end users
// This class is not intended for production code.
//
var FaceTecStatusEnumFriendlyText = /** @class */ (function () {
    function FaceTecStatusEnumFriendlyText() {
    }
FaceTecStatusEnumFriendlyText.descriptionForSessionStatus = function (enumValue) {
    switch (enumValue) {
        case FaceTecSDK.FaceTecSessionStatus.DocumentNotReady:
            return "Sesión cancelada porque el documento no está en estado listo.";
        case FaceTecSDK.FaceTecSessionStatus.SessionInProgress:
            return "Sesión cancelada porque ya hay una sesión en curso.";
        case FaceTecSDK.FaceTecSessionStatus.CameraNotRunning:
            return "Sesión cancelada porque la cámara seleccionada no está activa.";
        case FaceTecSDK.FaceTecSessionStatus.Timeout:
            return "Sesión cancelada por tiempo de espera excedido.";
        case FaceTecSDK.FaceTecSessionStatus.ContextSwitch:
            return "Sesión cancelada por cambio de contexto.";
        case FaceTecSDK.FaceTecSessionStatus.ProgrammaticallyCancelled:
            return "Sesión cancelada programáticamente por el desarrollador.";
        case FaceTecSDK.FaceTecSessionStatus.OrientationChangeDuringSession:
            return "Sesión cancelada por cambio de orientación del dispositivo.";
        case FaceTecSDK.FaceTecSessionStatus.LandscapeModeNotAllowed:
            return "La sesión no se inició porque el dispositivo está en modo horizontal.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelled:
            return "El usuario canceló la sesión antes de completarla.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelledFromRetryGuidance:
            return "El usuario canceló desde la pantalla de reintento.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelledFromNewUserGuidance:
            return "El usuario canceló desde la guía para nuevos usuarios.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelledWhenAttemptingToGetCameraPermissions:
            return "El usuario canceló al intentar otorgar permisos de cámara.";
        case FaceTecSDK.FaceTecSessionStatus.LockedOut:
            return "El SDK de FaceTec en el navegador está bloqueado.";
        case FaceTecSDK.FaceTecSessionStatus.SessionCompletedSuccessfully:
            return "La sesión se completó correctamente y se generó un escaneo facial.";
        case FaceTecSDK.FaceTecSessionStatus.CameraNotEnabled:
            return "El usuario no activó la cámara o los permisos fueron denegados anteriormente.";
        case FaceTecSDK.FaceTecSessionStatus.NonProductionModeDeviceKeyIdentifierInvalid:
            return "La clave nunca fue validada.";
        case FaceTecSDK.FaceTecSessionStatus.InitializationNotCompleted:
            return "El SDK de FaceTec en el navegador no fue inicializado correctamente.";
        case FaceTecSDK.FaceTecSessionStatus.MissingGuidanceImages:
            return "La sesión fue cancelada porque faltan imágenes de guía.";
        case FaceTecSDK.FaceTecSessionStatus.UnknownInternalError:
            return "La sesión fue cancelada por un error interno inesperado.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelledViaClickableReadyScreenSubtext:
            return "La sesión fue cancelada porque el usuario presionó el texto en la pantalla de preparación.";
        case FaceTecSDK.FaceTecSessionStatus.NotAllowedUseIframeConstructor:
            return "La sesión fue cancelada porque se utilizó el constructor con iFrame en un contexto que no es un iFrame.";
        case FaceTecSDK.FaceTecSessionStatus.NotAllowedUseNonIframeConstructor:
            return "La sesión fue cancelada porque se usó el constructor sin iFrame dentro de un iFrame.";
        case FaceTecSDK.FaceTecSessionStatus.IFrameNotAllowedWithoutPermission:
            return "La sesión fue cancelada porque no tienes permiso para ejecutar FaceTec en un iFrame. Contacta a FaceTec para solicitar acceso.";
        case FaceTecSDK.FaceTecSessionStatus.StillLoadingResources:
            return "Los recursos necesarios del SDK de FaceTec aún se están cargando.";
        case FaceTecSDK.FaceTecSessionStatus.ResourcesCouldNotBeLoadedOnLastInit:
            return "Los recursos necesarios del SDK de FaceTec no se cargaron correctamente en la última inicialización.";
        case FaceTecSDK.FaceTecSessionStatus.UserCancelledFullScreenMode:
            return "La sesión fue cancelada por un cambio de modo de pantalla completa desde un iFrame.";
        default:
            return "Valor inesperado de FaceTecSessionStatus: " + enumValue;
    }
};

    /** Gets a friendly string for representing the status of the SDK */
FaceTecStatusEnumFriendlyText.descriptionForFaceTecSDKStatus = function (enumValue) {
    switch (enumValue) {
        case FaceTecSDK.FaceTecSDKStatus.NeverInitialized:
            return "La inicialización nunca fue intentada.";
        case FaceTecSDK.FaceTecSDKStatus.Initialized:
            return "Inicializado correctamente.";
        case FaceTecSDK.FaceTecSDKStatus.NetworkIssues:
            return "Verifique su conexión de red.";
        case FaceTecSDK.FaceTecSDKStatus.InvalidDeviceKeyIdentifier:
            return "La clave proporcionada no es válida.";
        case FaceTecSDK.FaceTecSDKStatus.VersionDeprecated:
            return "La versión actual del SDK está obsoleta. Esta respuesta está DEPRECADA y ya no se devuelve.";
        case FaceTecSDK.FaceTecSDKStatus.DeviceNotSupported:
            return "Dispositivo o navegador no compatible.";
        case FaceTecSDK.FaceTecSDKStatus.DeviceInLandscapeMode:
            return "El SDK TWS2 debe utilizarse en orientación vertical.";
        case FaceTecSDK.FaceTecSDKStatus.DeviceLockedOut:
            return "El dispositivo está bloqueado para el uso del SDK de FaceTec en el navegador.";
        case FaceTecSDK.FaceTecSDKStatus.KeyExpiredOrInvalid:
            return "La clave ha expirado, contiene texto inválido, o se está intentando inicializar en un dominio no autorizado.";
        case FaceTecSDK.FaceTecSDKStatus.IFrameNotAllowedWithoutPermission:
            return "El uso del SDK de FaceTec dentro de un iFrame requiere permiso. Por favor, contacte a FaceTec para más detalles.";
        case FaceTecSDK.FaceTecSDKStatus.StillLoadingResources:
            return "Los recursos necesarios del SDK de FaceTec aún se están cargando.";
        case FaceTecSDK.FaceTecSDKStatus.ResourcesCouldNotBeLoadedOnLastInit:
            return "Los recursos necesarios del SDK de FaceTec no se pudieron cargar en la última inicialización.";
        case FaceTecSDK.FaceTecSDKStatus.GetUserMediaRemoteHTTPNotSupported:
            return "Las APIs de cámara del navegador solo son compatibles en localhost o mediante HTTPS.";
        default:
            return "Valor inesperado de FaceTecSDKStatus: " + enumValue;
    }
};
    /**
     * Gets a friendly string to describe the result of FaceTec Browser SDK ID Scan.
     */
FaceTecStatusEnumFriendlyText.descriptionForFaceTecIDScanStatus = function (enumValue) {
    switch (enumValue) {
        case FaceTecSDK.FaceTecIDScanStatus.CameraError:
            return "El escaneo del documento fue cancelado debido a un error de cámara.";
        case FaceTecSDK.FaceTecIDScanStatus.CameraNotEnabled:
            return "El usuario no activó la cámara después de solicitar permisos, o los permisos ya habían sido denegados.";
        case FaceTecSDK.FaceTecIDScanStatus.ContextSwitch:
            return "El escaneo del documento fue cancelado por un cambio de contexto.";
        case FaceTecSDK.FaceTecIDScanStatus.Success:
            return "El escaneo del documento se realizó correctamente y se generaron los datos del documento de identidad.";
        case FaceTecSDK.FaceTecIDScanStatus.TimedOut:
            return "El escaneo del documento fue cancelado por exceder el tiempo de espera.";
        case FaceTecSDK.FaceTecIDScanStatus.Unsuccess:
            return "El escaneo del documento no se realizó correctamente y no se generaron datos del documento de identidad.";
        case FaceTecSDK.FaceTecIDScanStatus.UserCancelled:
            return "El usuario presionó el botón de cancelar y no completó el proceso de escaneo del documento.";
        case FaceTecSDK.FaceTecIDScanStatus.Skipped:
            return "El escaneo del documento fue omitido.";
        case FaceTecSDK.FaceTecIDScanStatus.LandscapeModeNotAllowed:
            return "El SDK de FaceTec debe utilizarse en orientación vertical.";
        case FaceTecSDK.FaceTecIDScanStatus.LockedOut:
            return "El SDK de FaceTec en el navegador está en estado de bloqueo.";
        case FaceTecSDK.FaceTecIDScanStatus.UnknownInternalError:
            return "El escaneo del documento fue cancelado por un error interno inesperado.";
        default:
            return "Valor inesperado de PreloadResult: " + enumValue;
    }
};

    return FaceTecStatusEnumFriendlyText;
}());
var FaceTecStatusEnumFriendlyText = FaceTecStatusEnumFriendlyText;
