// Helper class to log and or display SampleApp messages.
// This classes sole purpose is to help developers learn about the FaceTecSDK response statuses.
var DeveloperStatusMessages = /** @class */ (function () {
    function DeveloperStatusMessages() {
    }
    var _a;
    _a = DeveloperStatusMessages;
    DeveloperStatusMessages.LOG_PREFIX = "TWS2 SampleApp:";
    // Display the message on the screen for the user
    DeveloperStatusMessages.displayMessage = function (message) {
        const el = document.getElementById("status");
        if (el) {
            el.style.display = "none";
            el.innerHTML = ""; // opcional, limpia el contenido
        }
    };
    // Log the message to the console for the developer. Prefix with TWS2 SampleApp: so the messages can be filtered
    DeveloperStatusMessages.logMessage = function (message) {
        console.log("".concat(_a.LOG_PREFIX, " ").concat(message));
    };
    // Log the message and display on screen for the user
    DeveloperStatusMessages.logAndDisplayMessage = function (message) {
        _a.displayMessage(message);
        _a.logMessage(message);
    };
    // Process the FaceTecSDK.getStatus result
    DeveloperStatusMessages.logInitializeResult = function () {
        // User message to display
        var displayMessage = FaceTecStatusEnumFriendlyText.descriptionForFaceTecSDKStatus(FaceTecSDK.getStatus());
        // Message to log for developer
        var logMessage = "TWS2SDK.getStatus(): ".concat(FaceTecSDK.getStatus(), " \"").concat(displayMessage, "\"");
        _a.displayMessage(displayMessage);
        _a.logMessage(logMessage);
    };
    // Process onComplete results from FaceTecSessionResult or FaceTecIDScanResult
    DeveloperStatusMessages.logScanOncompleteResult = function (sessionResult, idScanResult) {
        // User message to display
        var displayMessage = "Consulte los registros para más detalles.";
        // Message to log for developer
        var logMessage = "No se pudo leer el mensaje de estado";
        // Check for an idScanResult
        if (idScanResult != null && idScanResult.status != null) {
            // Special case message for user when the device is locked out
            if (idScanResult.status === FaceTecSDK.FaceTecIDScanStatus.LockedOut) {
                displayMessage = "El dispositivo está bloqueado en el SDK de tws2.";
            }
            logMessage = "TWS2canResult.status: ".concat(idScanResult.status, " (").concat(FaceTecStatusEnumFriendlyText.descriptionForFaceTecIDScanStatus(idScanResult.status), ")");
            // Add additional logging for the case where the developer cancelled the session before the idScan was processed by the server
            // The developer should be handling this appropriately in the processor
            if (idScanResult.status === FaceTecSDK.FaceTecIDScanStatus.Success && idScanResult.isCompletelyDone === false) {
                logMessage += "\n".concat(_a.LOG_PREFIX, " La operación fue cancelada antes de completar el procesamiento del escaneo del documento.");
            }
        }
        // Else show the sessionResult
        else if (sessionResult != null && sessionResult.status != null) {
            // Special case message for user when the device is locked out
            if (sessionResult.status === FaceTecSDK.FaceTecSessionStatus.LockedOut) {
                displayMessage = "El dispositivo está bloqueado en el SDK de tws2.";
            }
            logMessage = "TWS2SessionResult.status: ".concat(sessionResult.status, " - \"").concat(FaceTecStatusEnumFriendlyText.descriptionForSessionStatus(sessionResult.status), "\"");
            // Add additional logging for the case where the developer cancelled the session before the faceScan was processed by the server
            // The developer should be handling this appropriately in the processor
            if (sessionResult.status === FaceTecSDK.FaceTecSessionStatus.SessionCompletedSuccessfully && sessionResult.isCompletelyDone === false) {
                logMessage += "\n".concat(_a.LOG_PREFIX, " La operación fue cancelada antes de completar el procesamiento del escaneo del rostro.");
            }
        }
        _a.displayMessage(displayMessage);
        _a.logMessage(logMessage);
    };
    return DeveloperStatusMessages;
}());
var DeveloperStatusMessages = DeveloperStatusMessages;
