/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.utils;

import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:seguridad.properties"})
public class Seguridad {
    @Value(value="${PASSPHRASE}")
    private String passphrase;
    @Value(value="${PSWDITERATIONS}")
    private int pswdIterations;
    @Value(value="${SALT}")
    private String salt;
    @Value(value="${ALGORITHMKEY}")
    private String ALGORITHMKEY;
    @Value(value="${ALGORITHM}")
    private String ALGORITHM;
    @Value(value="${MODE}")
    private String MODE;
    @Value(value="${PADDING}")
    private String PADDING;
    @Value(value="${ENCODING}")
    private Charset PLAIN_TEXT_ENCODING;
    @Value(value="${KEY_SIZE_BITS}")
    private int KEY_SIZE_BITS;
    private String CIPHER_TRANSFORMATION;

    public String decrypt(String encryptedText) throws Exception {
        if (encryptedText != null && !encryptedText.isEmpty()) {
            this.CIPHER_TRANSFORMATION = this.ALGORITHM + "/" + this.MODE + "/" + this.PADDING;
            byte[] saltBytes = new String(this.salt).getBytes(this.PLAIN_TEXT_ENCODING);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.ALGORITHMKEY);
            PBEKeySpec spec = new PBEKeySpec(this.passphrase.toCharArray(), saltBytes, this.pswdIterations, this.KEY_SIZE_BITS);
            SecretKey secretKey = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), this.ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new String(this.salt).getBytes(this.PLAIN_TEXT_ENCODING));
            Cipher cipher = Cipher.getInstance(this.CIPHER_TRANSFORMATION);
            cipher.init(2, (Key)secret, ivParameterSpec);
            byte[] encryptedTextBytes = Base64.decodeBase64((String)encryptedText);
            byte[] decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
            return new String(decryptedTextBytes, this.PLAIN_TEXT_ENCODING);
        }
        return new String();
    }

    public String encrypt(String dataText) throws Exception {
        if (dataText != null && !dataText.isEmpty()) {
            this.CIPHER_TRANSFORMATION = this.ALGORITHM + "/" + this.MODE + "/" + this.PADDING;
            byte[] saltBytes = new String(this.salt).getBytes(this.PLAIN_TEXT_ENCODING);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.ALGORITHMKEY);
            PBEKeySpec spec = new PBEKeySpec(this.passphrase.toCharArray(), saltBytes, this.pswdIterations, this.KEY_SIZE_BITS);
            SecretKey secretKey = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), this.ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new String(this.salt).getBytes(this.PLAIN_TEXT_ENCODING));
            Cipher cipher = Cipher.getInstance(this.CIPHER_TRANSFORMATION);
            cipher.init(1, (Key)secret, ivParameterSpec);
            byte[] encryptedTextBytes = cipher.doFinal(dataText.getBytes(this.PLAIN_TEXT_ENCODING));
            return Base64.encodeBase64String((byte[])encryptedTextBytes);
        }
        return new String();
    }
}

