/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.utils;

import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.Autorizacion;
import ec.tws2.back.contfiables.models.comprobantesSRI.factura1_1_0.Factura;
import ec.tws2.back.contfiables.utils.PropiedadesSRI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JaxbToXML {
    private PropiedadesSRI propsri;

    public JaxbToXML(PropiedadesSRI propsri) {
        this.propsri = propsri;
    }

    public byte[] facturaToXML(Factura factura) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Factura.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal((Object)factura, (Writer)sw);
            String xmlContent = sw.toString();
            System.out.println(xmlContent);
            return sw.toString().getBytes("UTF-8");
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String documentToString(Document doc, boolean formateado) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (formateado) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    public String documentToString(Document doc) {
        return this.documentToString(doc, false);
    }

    public Document objectToDocument(Object objeto) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objeto.getClass()});
        context.createMarshaller().marshal(objeto, (Result)res);
        Document doc = (Document)res.getNode();
        return doc;
    }

    public byte[] documentoToBase64Bytes(Document documento) {
        return this.documentToString(documento).getBytes();
    }

    public boolean documentToFile(Document doc, String path) throws Exception {
        DOMSource source = new DOMSource(doc);
        File archivo = new File(path);
        archivo.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(archivo);
        StreamResult result = new StreamResult(writer);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("cdata-section-elements", "{}comprobante");
        transformer.transform(source, result);
        return false;
    }

    public boolean validarXML(String xsdPath, Document documento) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new File(xsdPath));
            Validator validator = schema.newValidator();
            String strDoc = this.documentToString(documento);
            validator.validate(new StreamSource(new ByteArrayInputStream(strDoc.getBytes())));
        }
        catch (IOException | SAXException e) {
            System.out.println("Exception: \n\n" + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean guardarAutorizacion(Autorizacion autorizacion, String claveAcceso) {
        try {
            Document doc = this.objectToDocument((Object)autorizacion);
            String ruc = claveAcceso.substring(10, 23);
            String anio = claveAcceso.substring(4, 8);
            String mes = claveAcceso.substring(2, 4);
            String path = this.propsri.getPathbase() + "/" + ruc + "/" + this.propsri.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".xml";
            this.documentToFile(doc, path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

