/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.utils;

import ec.tws2.back.contfiables.utils.PassStoreKS;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.FirmaXML;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.javasign.EnumFormatoFirma;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.keystore.KSStore;
import es.mityc.javasign.xml.refs.AbstractObjectToSign;
import es.mityc.javasign.xml.refs.InternObjectToSign;
import es.mityc.javasign.xml.refs.ObjectToSign;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class FirmaXades {
    private String type = "";
    private String path_store_file = "";
    private String key_store_password = "";
    private String private_key = "";

    public FirmaXades(String type, String path_store_file, String key_store_password, String private_key) {
        this.type = type;
        this.path_store_file = path_store_file;
        this.key_store_password = key_store_password;
        this.private_key = private_key;
    }

    public Document loadDocumentFromFile(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }

    public Document commonInputFileProcessDoc(String pathInputFile) throws Exception {
        Document docSign = null;
        FirmaXML firma = new FirmaXML();
        DataToSign dataToSign = new DataToSign();
        dataToSign.setXadesFormat(EnumFormatoFirma.XAdES_BES);
        dataToSign.setEsquema(XAdESSchemas.XAdES_132);
        dataToSign.setXMLEncoding("UTF-8");
        dataToSign.setEnveloped(true);
        dataToSign.addObject(new ObjectToSign((AbstractObjectToSign)new InternObjectToSign("comprobante"), "contenido comprobante", null, "text/xml", null));
        dataToSign.setParentSignNode("comprobante");
        Document doc = this.loadDocumentFromFile(new File(pathInputFile));
        KeyStore ks = KeyStore.getInstance(this.type);
        ks.load(new FileInputStream(this.path_store_file), this.key_store_password.toCharArray());
        KSStore storeManager = new KSStore(ks, (IPassStoreKS)new PassStoreKS(this.private_key));
        X509Certificate cert = this.getFirstCertificate((IPKStoreManager)storeManager);
        PrivateKey privateKey = storeManager.getPrivateKey(cert);
        Provider provider = storeManager.getProvider(cert);
        try {
            dataToSign.setDocument(doc);
            Object[] objSign = firma.signFile(cert, dataToSign, privateKey, provider);
            docSign = (Document)objSign[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return docSign;
    }

    public Document commonInputFileProcess(Document doc) throws Exception {
        Document docSign = null;
        FirmaXML firma = new FirmaXML();
        DataToSign dataToSign = new DataToSign();
        dataToSign.setXadesFormat(EnumFormatoFirma.XAdES_BES);
        dataToSign.setEsquema(XAdESSchemas.XAdES_132);
        dataToSign.setXMLEncoding("UTF-8");
        dataToSign.setEnveloped(true);
        dataToSign.addObject(new ObjectToSign((AbstractObjectToSign)new InternObjectToSign("comprobante"), "Comprobante", null, "text/xml", null));
        dataToSign.setParentSignNode("comprobante");
        KeyStore ks = KeyStore.getInstance(this.type);
        ks.load(new FileInputStream(this.path_store_file), this.key_store_password.toCharArray());
        KSStore storeManager = new KSStore(ks, (IPassStoreKS)new PassStoreKS(this.private_key));
        X509Certificate cert = this.getFirstCertificate((IPKStoreManager)storeManager);
        PrivateKey privateKey = storeManager.getPrivateKey(cert);
        Provider provider = storeManager.getProvider(cert);
        try {
            dataToSign.setDocument(doc);
            Object[] objSign = firma.signFile(cert, dataToSign, privateKey, provider);
            docSign = (Document)objSign[0];
        }
        catch (Exception e) {
            System.err.println("Error en proceso de firma");
            e.printStackTrace();
        }
        return docSign;
    }

    private X509Certificate getFirstCertificate(IPKStoreManager storeManager) throws Exception {
        List certs = null;
        try {
            certs = storeManager.getSignCertificates();
        }
        catch (CertStoreException ex) {
            System.err.println("Fallo obteniendo listado de certificados");
            throw ex;
        }
        if (certs == null || certs.size() == 0) {
            System.err.println("Lista de certificados vacia");
            throw new Exception("Lista de certificados vacia");
        }
        X509Certificate certificate = null;
        for (X509Certificate certificado : certs) {
            try {
                certificado.checkValidity();
                certificate = certificado;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException err) {
                System.err.println("Certificado no valido");
                err.printStackTrace();
            }
        }
        return certificate;
    }

    public String processXMLString(String pathInputFile, String pathOutputFile) throws Exception {
        Document doc = this.commonInputFileProcessDoc(pathInputFile);
        File signatureFile = new File(pathOutputFile);
        this.outputDocToFile(doc, signatureFile);
        return this.docToXMLString(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String docToXMLString(Document doc) throws Exception {
        String xmlstring = "";
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            xmlstring = writer.toString();
        }
        finally {
            writer.close();
        }
        return xmlstring;
    }

    public void processFileOutput(String pathInputFile, String pathOutputFile) throws Exception {
        File signatureFile = new File(pathOutputFile);
        Document doc = this.commonInputFileProcessDoc(pathInputFile);
        this.outputDocToFile(doc, signatureFile);
    }

    private void outputDocToFile(Document doc, File file) throws Exception {
        FileOutputStream f = new FileOutputStream(file);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(doc), new StreamResult(f));
        f.close();
    }
}

