/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.service.impl;

import ec.tws2.back.contfiables.enums.CodigoRespuestasEnum;
import ec.tws2.back.contfiables.enums.EstadoFacturaEnum;
import ec.tws2.back.contfiables.exception.SriException;
import ec.tws2.back.contfiables.models.DTO.CertInformation;
import ec.tws2.back.contfiables.models.DTO.RequestBillDTO;
import ec.tws2.back.contfiables.models.api.ApiRespuestaDTO;
import ec.tws2.back.contfiables.models.api.ErrorComprobanteDTO;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.Autorizacion;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.AutorizacionComprobante;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.AutorizacionComprobanteResponse;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.Mensaje;
import ec.tws2.back.contfiables.models.comprobantesSRI.factura2_1_0.Factura;
import ec.tws2.back.contfiables.models.comprobantesSRI.recepcioncomprobantes.RespuestaSolicitud;
import ec.tws2.back.contfiables.models.comprobantesSRI.recepcioncomprobantes.ValidarComprobante;
import ec.tws2.back.contfiables.models.comprobantesSRI.recepcioncomprobantes.ValidarComprobanteResponse;
import ec.tws2.back.contfiables.models.entity.TPeticion;
import ec.tws2.back.contfiables.service.ComprobanteService;
import ec.tws2.back.contfiables.service.FacturacionService;
import ec.tws2.back.contfiables.service.PeticionService;
import ec.tws2.back.contfiables.soapclient.SRISoapConnector;
import ec.tws2.back.contfiables.utils.FechaUtils;
import ec.tws2.back.contfiables.utils.FirmaXades;
import ec.tws2.back.contfiables.utils.JaxbToXML;
import ec.tws2.back.contfiables.utils.MapearRespuestaSriUtils;
import ec.tws2.back.contfiables.utils.PropiedadesSRI;
import ec.tws2.back.contfiables.utils.Seguridad;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

@Service
public class FacturacionServiceImpl
implements FacturacionService {
    private static final Logger log = LoggerFactory.getLogger(FacturacionServiceImpl.class);
    private final PeticionService peticionService;
    private final PropiedadesSRI propSRI;
    private final SRISoapConnector soapConnector;
    private final Seguridad seguridad;
    private final ComprobanteService comprobanteService;

    public ApiRespuestaDTO enviarFacturaV2(RequestBillDTO requestBillDTO, HttpServletRequest requestHttp) throws Exception {
        String password;
        ApiRespuestaDTO respuestaVerificacion;
        Factura factura = requestBillDTO.getFactura();
        if (!factura.getInfoTributaria().getAmbiente().equals(this.propSRI.getAmbienteActual())) {
            String ambienteactual = this.propSRI.isAmbienteProduccion() ? "Producci\u00f3n" : "Pruebas";
            throw new SriException(EstadoFacturaEnum.ERROR.getEstado(), List.of(new ErrorComprobanteDTO(factura.getInfoTributaria().getClaveAcceso(), CodigoRespuestasEnum.SRI_AMBIENTE_NO_COINCIDE.getCodigo(), CodigoRespuestasEnum.SRI_AMBIENTE_NO_COINCIDE.getMensaje(), "El ambiente del comprobante no coincide con el ambiente actual: " + ambienteactual, EstadoFacturaEnum.ERROR.getEstado())));
        }
        CertInformation certInformation = requestBillDTO.getCertInformation();
        String claveAcceso = factura.getInfoTributaria().getClaveAcceso();
        String ruc = factura.getInfoTributaria().getRuc();
        this.validarFactura(factura);
        log.info("Clave de acceso: {}", (Object)claveAcceso);
        TPeticion peticiondb = this.peticionService.findbyClaveAcceso(claveAcceso);
        log.info("Petici\u00f3n encontrada en la base de datos: {}", (Object)peticiondb);
        if (peticiondb != null && (respuestaVerificacion = this.verificarEstadoComprobanteAlmacenadoEnBaseDeDatos(claveAcceso, peticiondb)) != null) {
            log.info("Comprobante ya existe en la base de datos, estado: {}", (Object)peticiondb.getEstado());
            return respuestaVerificacion;
        }
        if (peticiondb == null) {
            log.info("No se encontr\u00f3 la petici\u00f3n en la base de datos, creando una nueva.");
            peticiondb = TPeticion.instanciaNuevoRegistro((String)requestHttp.getRemoteAddr(), (String)factura.getInfoTributaria().getSecuencial(), (String)claveAcceso, (String)ruc, (String)this.propSRI.getAmbienteString());
        }
        factura.setId("comprobante");
        factura.setVersion("2.1.0");
        JaxbToXML utilXML = new JaxbToXML(this.propSRI);
        String pathFileJks = this.propSRI.getPathbase() + "/" + ruc + "/" + certInformation.getNombreArchivoFirma();
        String jksPasswordStore = password = this.seguridad.decrypt(certInformation.getClaveFirma());
        String jksPassPrivate = password;
        log.info("Ruta del archivo JKS: {}", (Object)pathFileJks);
        FirmaXades sgp = new FirmaXades("PKCS12", pathFileJks, jksPasswordStore, jksPassPrivate);
        Document documentoFactura = utilXML.objectToDocument((Object)factura);
        String pathFirmado = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getFirmados() + "/" + claveAcceso + ".xml";
        utilXML.documentToFile(documentoFactura, pathFirmado);
        sgp.processFileOutput(pathFirmado, pathFirmado);
        File firmado = new File(pathFirmado);
        byte[] bytesComprobante = utilXML.documentoToBase64Bytes(sgp.loadDocumentFromFile(firmado));
        ValidarComprobante request = new ValidarComprobante();
        request.setXml(bytesComprobante);
        this.peticionService.guardarPeticion(peticiondb);
        ValidarComprobanteResponse respuesta = this.propSRI.isAmbienteProduccion() ? this.soapConnector.enviaComprobanteProduccion(request) : this.soapConnector.enviaComprobantePruebas(request);
        ApiRespuestaDTO respuestaSriDTO = MapearRespuestaSriUtils.mapearRespuestaSRI((RespuestaSolicitud)respuesta.getRespuestaRecepcionComprobante());
        log.info("Respuesta del SRI: {}", (Object)respuestaSriDTO);
        if (respuestaSriDTO.getEstado().equals(EstadoFacturaEnum.RECIBIDA.getEstado())) {
            firmado.delete();
            peticiondb.setEstado(respuestaSriDTO.getEstado());
            this.peticionService.guardarPeticion(peticiondb);
            ApiRespuestaDTO respuestaAutorizacion = this.validarRespuestaAutorizacionSri(claveAcceso, utilXML);
            return respuestaAutorizacion;
        }
        ApiRespuestaDTO validacion = this.comprobanteService.validarComprobanteDevuelto(respuesta);
        if (validacion != null) {
            log.info("Comprobante devuelto con errores: {}", (Object)validacion);
            return validacion;
        }
        return respuestaSriDTO;
    }

    private ApiRespuestaDTO validarRespuestaAutorizacionSri(String claveAcceso, JaxbToXML utilXML) {
        AutorizacionComprobante requestComprobante = new AutorizacionComprobante();
        requestComprobante.setClaveAccesoComprobante(claveAcceso);
        AutorizacionComprobanteResponse respuestaConsultaComprobate = this.propSRI.isAmbienteProduccion() ? this.soapConnector.consultaAutorizacionProduccion(requestComprobante) : this.soapConnector.consultaAutorizacionPruebas(requestComprobante);
        List comprobantes = respuestaConsultaComprobate.getRespuestaAutorizacionComprobante().getAutorizaciones().getAutorizacion();
        if (comprobantes.isEmpty()) {
            log.error("No se encontr\u00f3 el comprobante en el sri con clave de acceso: {}", (Object)claveAcceso);
            throw new SriException(EstadoFacturaEnum.ERROR.getEstado(), List.of(new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.ERROR_COMPROBANTE_NO_ENCONTRADO.getCodigo(), CodigoRespuestasEnum.ERROR_COMPROBANTE_NO_ENCONTRADO.getMensaje(), CodigoRespuestasEnum.ERROR_COMPROBANTE_NO_ENCONTRADO.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
        }
        Autorizacion autorizacion = (Autorizacion)comprobantes.get(0);
        return this.respuestaConsultaComprobante(autorizacion, utilXML, claveAcceso, this.peticionService.findbyClaveAcceso(claveAcceso));
    }

    private ApiRespuestaDTO respuestaConsultaComprobante(Autorizacion autorizacion, JaxbToXML utilXML, String claveAcceso, TPeticion peticiondb) {
        if (autorizacion.getEstado().equals(EstadoFacturaEnum.AUTORIZADO.getEstado())) {
            try {
                utilXML.guardarAutorizacion(autorizacion, claveAcceso);
            }
            catch (Exception e) {
                log.error("Error al guardar la autorizaci\u00f3n del comprobante: {}", (Object)claveAcceso, (Object)e);
                throw new SriException(EstadoFacturaEnum.AUTORIZADO.getEstado(), List.of(new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getCodigo(), CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getMensaje(), CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
            }
            peticiondb.setEstado(autorizacion.getEstado());
            peticiondb.setNumeroAutorizacion(autorizacion.getNumeroAutorizacion());
            peticiondb.setFechaAutorizacion(FechaUtils.convertToLocalDateTime((XMLGregorianCalendar)autorizacion.getFechaAutorizacion()));
            peticiondb.setAmbiente(autorizacion.getAmbiente());
            this.peticionService.guardarPeticion(peticiondb);
            return ApiRespuestaDTO.comprobanteAutorizado((String)autorizacion.getEstado(), (String)autorizacion.getNumeroAutorizacion(), (LocalDateTime)FechaUtils.convertToLocalDateTime((XMLGregorianCalendar)autorizacion.getFechaAutorizacion()), (String)autorizacion.getAmbiente());
        }
        log.error("Comprobante no autorizado: {}", (Object)autorizacion.getEstado());
        ArrayList<ErrorComprobanteDTO> listErrores = new ArrayList<ErrorComprobanteDTO>();
        for (Mensaje men : autorizacion.getMensajes().getMensaje()) {
            ErrorComprobanteDTO error = new ErrorComprobanteDTO(claveAcceso, men.getIdentificador(), men.getMensaje(), men.getInformacionAdicional(), men.getTipo());
            log.error("Error en la autorizaci\u00f3n del comprobante: {}", (Object)error);
            listErrores.add(error);
        }
        peticiondb.setEstado(autorizacion.getEstado());
        this.peticionService.guardarPeticion(peticiondb);
        throw new SriException(autorizacion.getEstado(), listErrores);
    }

    private ApiRespuestaDTO verificarEstadoComprobanteAlmacenadoEnBaseDeDatos(String claveAcceso, TPeticion peticiondb) {
        if (peticiondb.getEstado().equals(EstadoFacturaEnum.AUTORIZADO.getEstado())) {
            log.info("Comprobante ya autorizado en el sistema, verificando archivo...");
            String ruc = claveAcceso.substring(10, 23);
            String anio = claveAcceso.substring(4, 8);
            String mes = claveAcceso.substring(2, 4);
            String pathFile = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".xml";
            File archivoAutorizado = new File(pathFile);
            if (archivoAutorizado.exists()) {
                log.info("Comprobante ya autorizado y archivo encontrado: {}", (Object)pathFile);
                return ApiRespuestaDTO.comprobanteAutorizado((String)peticiondb.getEstado(), (String)peticiondb.getNumeroAutorizacion(), (LocalDateTime)peticiondb.getFechaAutorizacion(), (String)peticiondb.getAmbiente());
            }
            log.info("Comprobante ya autorizado pero archivo no encontrado, consultando autorizaci\u00f3n...");
            return this.comprobanteService.consultaAutorizacion(claveAcceso);
        }
        return null;
    }

    private void validarFactura(Factura factura) {
        JaxbToXML xmlutil = new JaxbToXML(this.propSRI);
        try {
            xmlutil.validarXML(this.propSRI.getPathbase() + this.propSRI.getXsdFactura(), xmlutil.objectToDocument((Object)factura));
            log.info("Pasa validacion XSD");
        }
        catch (Exception e) {
            log.error("Error al validar XSD: {}", (Throwable)e);
            throw new SriException(EstadoFacturaEnum.DEVUELTA.getEstado(), List.of(new ErrorComprobanteDTO(factura.getInfoTributaria().getClaveAcceso(), CodigoRespuestasEnum.SRI_ERROR_NO_CUMPLE_ESTRUCTURA_XML.getCodigo(), CodigoRespuestasEnum.SRI_ERROR_NO_CUMPLE_ESTRUCTURA_XML.getMensaje(), CodigoRespuestasEnum.SRI_ERROR_NO_CUMPLE_ESTRUCTURA_XML.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
        }
    }

    public FacturacionServiceImpl(PeticionService peticionService, PropiedadesSRI propSRI, SRISoapConnector soapConnector, Seguridad seguridad, ComprobanteService comprobanteService) {
        this.peticionService = peticionService;
        this.propSRI = propSRI;
        this.soapConnector = soapConnector;
        this.seguridad = seguridad;
        this.comprobanteService = comprobanteService;
    }
}

