/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.service.impl;

import ec.tws2.back.contfiables.models.email.CorreoModel;
import ec.tws2.back.contfiables.service.CorreoService;
import ec.tws2.back.contfiables.utils.Seguridad;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CorreoServiceImpl
implements CorreoService {
    @Autowired
    private Environment env;
    @Autowired
    private Seguridad seguridad;
    @Autowired
    RestTemplate restTemplate;

    public Map<String, Object> getToken() {
        try {
            String url = this.env.getProperty("auth.correo.url") + "/token";
            String username = this.env.getProperty("auth.correo.username");
            String password = this.env.getProperty("auth.correo.password");
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"username", (Object)this.seguridad.decrypt(username));
            params.add((Object)"password", (Object)this.seguridad.decrypt(password));
            params.add((Object)"client_id", (Object)"logueoBack");
            params.add((Object)"grant_type", (Object)"password");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
            return (Map)response.getBody();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            return null;
        }
    }

    public void logOut(String refreshToken) {
        try {
            String url = this.env.getProperty("auth.correo.url") + "/logout";
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"refresh_token", (Object)refreshToken);
            params.add((Object)"client_id", (Object)"logueoBack");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
            System.out.println("sesion cerrada " + response.getBody());
        }
        catch (Exception e) {
            System.out.println("ERROR AL CERRAR LA SESION");
        }
    }

    public String sendEmail(CorreoModel correoModel) {
        ResponseEntity response;
        String refreshToken;
        block6: {
            String string;
            block7: {
                refreshToken = null;
                String url = this.env.getProperty("correo.service.url");
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                Map tokenModel = this.getToken();
                refreshToken = tokenModel.get("refresh_token").toString();
                headers.setBearerAuth(tokenModel.get("access_token").toString());
                HttpEntity request = new HttpEntity((Object)correoModel, (MultiValueMap)headers);
                response = this.restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
                if (response.getStatusCode() != HttpStatus.OK) break block6;
                string = (String)response.getBody();
                if (refreshToken == null) break block7;
                this.logOut(refreshToken);
            }
            return string;
        }
        try {
            try {
                throw new RuntimeException("Error en la solicitud: " + response.getStatusCode());
            }
            catch (Exception e) {
                throw new RuntimeException("Error en la solicitud: ", e);
            }
        }
        catch (Throwable throwable) {
            if (refreshToken != null) {
                this.logOut(refreshToken);
            }
            throw throwable;
        }
    }
}

