/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.service.impl;

import ec.tws2.back.contfiables.enums.CodigoRespuestasEnum;
import ec.tws2.back.contfiables.enums.EstadoFacturaEnum;
import ec.tws2.back.contfiables.exception.SriException;
import ec.tws2.back.contfiables.models.api.ApiRespuestaDTO;
import ec.tws2.back.contfiables.models.api.ErrorComprobanteDTO;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.Autorizacion;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.AutorizacionComprobante;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.AutorizacionComprobanteResponse;
import ec.tws2.back.contfiables.models.comprobantesSRI.autorizacioncomprobantes.Mensaje;
import ec.tws2.back.contfiables.models.comprobantesSRI.recepcioncomprobantes.RespuestaSolicitud;
import ec.tws2.back.contfiables.models.comprobantesSRI.recepcioncomprobantes.ValidarComprobanteResponse;
import ec.tws2.back.contfiables.models.entity.TPeticion;
import ec.tws2.back.contfiables.service.ComprobanteService;
import ec.tws2.back.contfiables.service.PeticionService;
import ec.tws2.back.contfiables.soapclient.SRISoapConnector;
import ec.tws2.back.contfiables.utils.FechaUtils;
import ec.tws2.back.contfiables.utils.JaxbToXML;
import ec.tws2.back.contfiables.utils.MapearRespuestaSriUtils;
import ec.tws2.back.contfiables.utils.PropiedadesSRI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ComprobanteServiceImpl
implements ComprobanteService {
    private static final Logger log = LoggerFactory.getLogger(ComprobanteServiceImpl.class);
    private final SRISoapConnector soapConnector;
    private final PeticionService peticionService;
    private final PropiedadesSRI propSRI;

    public ApiRespuestaDTO validarComprobanteDevuelto(ValidarComprobanteResponse response) {
        RespuestaSolicitud respuestaComprobante = response.getRespuestaRecepcionComprobante();
        ApiRespuestaDTO respuestaDTO = MapearRespuestaSriUtils.mapearRespuestaSRI((RespuestaSolicitud)respuestaComprobante);
        if (respuestaDTO.getEstado().equals(EstadoFacturaEnum.DEVUELTA.getEstado())) {
            log.info("Comprobante devuelto");
            return this.validarComprobantesDevuelto(respuestaDTO);
        }
        return null;
    }

    private ApiRespuestaDTO validarComprobantesDevuelto(ApiRespuestaDTO respuestaDTO) {
        List errores = respuestaDTO.getErrores();
        for (ErrorComprobanteDTO item : errores) {
            if (!item.getCodigo().equals(CodigoRespuestasEnum.SRI_CLAVE_ACCESO_REGISTRADA.getCodigo()) || !item.getMensaje().equals(CodigoRespuestasEnum.SRI_CLAVE_ACCESO_REGISTRADA.getMensaje())) continue;
            log.info("Clave de acceso ya registrada: {}", (Object)item.getClaveAcceso());
            return this.consultaAutorizacion(item.getClaveAcceso());
        }
        return null;
    }

    private TPeticion validarExistenciaComprobante(String claveAcceso) {
        log.info("Validando existencia del comprobante en la base de datos con clave de acceso: {}", (Object)claveAcceso);
        TPeticion peticion = this.peticionService.findbyClaveAcceso(claveAcceso);
        if (peticion == null) {
            log.warn("El comprobante: {} no existe en la base de datos", (Object)claveAcceso);
            throw new SriException(EstadoFacturaEnum.PENDIENTE.getEstado(), List.of(new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.SRI_COMPROBANTE_EN_ESPERA_AUTORIZACION.getCodigo(), CodigoRespuestasEnum.SRI_COMPROBANTE_EN_ESPERA_AUTORIZACION.getMensaje(), CodigoRespuestasEnum.SRI_COMPROBANTE_EN_ESPERA_AUTORIZACION.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
        }
        return peticion;
    }

    public ApiRespuestaDTO consultaAutorizacion(String claveAcceso) {
        log.info("Iniciando consulta de autorizaci\u00f3n para clave de acceso: {}", (Object)claveAcceso);
        TPeticion peticiondb = this.validarExistenciaComprobante(claveAcceso);
        log.info("Resultado de la peticion en la base de datos: existe {}", (Object)(peticiondb != null ? 1 : 0));
        AutorizacionComprobante request = new AutorizacionComprobante();
        request.setClaveAccesoComprobante(claveAcceso);
        AutorizacionComprobanteResponse respuesta = this.propSRI.isAmbienteProduccion() ? this.soapConnector.consultaAutorizacionProduccion(request) : this.soapConnector.consultaAutorizacionPruebas(request);
        Iterator iterator = respuesta.getRespuestaAutorizacionComprobante().getAutorizaciones().getAutorizacion().iterator();
        if (iterator.hasNext()) {
            Autorizacion autorizacion = (Autorizacion)iterator.next();
            if (autorizacion.getEstado().equals(EstadoFacturaEnum.AUTORIZADO.getEstado())) {
                JaxbToXML utilXML = new JaxbToXML(this.propSRI);
                peticiondb.setEstado(autorizacion.getEstado());
                peticiondb.setNumeroAutorizacion(autorizacion.getNumeroAutorizacion());
                peticiondb.setAmbiente(autorizacion.getAmbiente());
                peticiondb.setFechaAutorizacion(FechaUtils.convertToLocalDateTime((XMLGregorianCalendar)autorizacion.getFechaAutorizacion()));
                this.peticionService.guardarPeticion(peticiondb);
                log.info("Comprobante autorizado: {}", (Object)claveAcceso);
                try {
                    utilXML.guardarAutorizacion(autorizacion, claveAcceso);
                    return ApiRespuestaDTO.comprobanteAutorizado((String)autorizacion.getEstado(), (String)autorizacion.getNumeroAutorizacion(), (LocalDateTime)FechaUtils.convertToLocalDateTime((XMLGregorianCalendar)autorizacion.getFechaAutorizacion()), (String)autorizacion.getAmbiente());
                }
                catch (Exception e) {
                    log.error("Error al guardar la autorizaci\u00f3n del comprobante: {}", (Object)claveAcceso, (Object)e);
                    throw new SriException(EstadoFacturaEnum.AUTORIZADO.getEstado(), List.of(new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getCodigo(), CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getMensaje(), CodigoRespuestasEnum.ERROR_ALMACENAR_COMPROBANTE.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
                }
            }
            ArrayList<ErrorComprobanteDTO> listErrores = new ArrayList<ErrorComprobanteDTO>();
            for (Mensaje men : autorizacion.getMensajes().getMensaje()) {
                System.err.println(men.getIdentificador() + " : " + men.getMensaje() + "\n" + men.getInformacionAdicional());
                ErrorComprobanteDTO error = new ErrorComprobanteDTO(claveAcceso, men.getIdentificador(), men.getMensaje(), men.getInformacionAdicional(), autorizacion.getEstado());
                listErrores.add(error);
            }
            throw new SriException(autorizacion.getEstado(), listErrores);
        }
        log.warn("No se encontr\u00f3 autorizaci\u00f3n para la clave de acceso: {}", (Object)claveAcceso);
        throw new SriException(EstadoFacturaEnum.NO_ENCONTRADA.getEstado(), List.of(new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.ERROR_CONSULTA_COMPROBANTE_VACIA.getCodigo(), CodigoRespuestasEnum.ERROR_CONSULTA_COMPROBANTE_VACIA.getMensaje(), CodigoRespuestasEnum.ERROR_CONSULTA_COMPROBANTE_VACIA.getMensaje(), EstadoFacturaEnum.ERROR.getEstado())));
    }

    public ComprobanteServiceImpl(SRISoapConnector soapConnector, PeticionService peticionService, PropiedadesSRI propSRI) {
        this.soapConnector = soapConnector;
        this.peticionService = peticionService;
        this.propSRI = propSRI;
    }
}

