/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.models.entity;

import ec.tws2.back.contfiables.enums.EstadoFacturaEnum;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="t_peticion")
public class TPeticion {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_peticion", updatable=false)
    private Long idPeticion;
    @Column(name="fecha_hora")
    private LocalDateTime fechaHora;
    @Column(name="fecha_autorizacion")
    private LocalDateTime fechaAutorizacion;
    @Column(name="ambiente")
    private String ambiente;
    @Column(name="ip_origen")
    private String ipOrigen;
    private String estado;
    @Column(name="clave_acceso")
    private String claveAcceso;
    @Column(name="numero_autorizacion")
    private String numeroAutorizacion;
    @Column(name="num_comprobante")
    private String numComprobante;
    @Column(name="ruc")
    private String ruc;

    public static TPeticion instanciaNuevoRegistro(String ipOrigen, String numComprobante, String claveAcceso, String ruc, String ambiente) {
        TPeticion peticion = new TPeticion();
        peticion.setEstado(EstadoFacturaEnum.PENDIENTE.getEstado());
        peticion.setFechaHora(LocalDateTime.now());
        peticion.setIpOrigen(ipOrigen);
        peticion.setNumComprobante(numComprobante);
        peticion.setClaveAcceso(claveAcceso);
        peticion.setRuc(ruc);
        peticion.setAmbiente(ambiente);
        return peticion;
    }

    public Long getIdPeticion() {
        return this.idPeticion;
    }

    public LocalDateTime getFechaHora() {
        return this.fechaHora;
    }

    public LocalDateTime getFechaAutorizacion() {
        return this.fechaAutorizacion;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public String getIpOrigen() {
        return this.ipOrigen;
    }

    public String getEstado() {
        return this.estado;
    }

    public String getClaveAcceso() {
        return this.claveAcceso;
    }

    public String getNumeroAutorizacion() {
        return this.numeroAutorizacion;
    }

    public String getNumComprobante() {
        return this.numComprobante;
    }

    public String getRuc() {
        return this.ruc;
    }

    public void setIdPeticion(Long idPeticion) {
        this.idPeticion = idPeticion;
    }

    public void setFechaHora(LocalDateTime fechaHora) {
        this.fechaHora = fechaHora;
    }

    public void setFechaAutorizacion(LocalDateTime fechaAutorizacion) {
        this.fechaAutorizacion = fechaAutorizacion;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public void setIpOrigen(String ipOrigen) {
        this.ipOrigen = ipOrigen;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public void setClaveAcceso(String claveAcceso) {
        this.claveAcceso = claveAcceso;
    }

    public void setNumeroAutorizacion(String numeroAutorizacion) {
        this.numeroAutorizacion = numeroAutorizacion;
    }

    public void setNumComprobante(String numComprobante) {
        this.numComprobante = numComprobante;
    }

    public void setRuc(String ruc) {
        this.ruc = ruc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TPeticion)) {
            return false;
        }
        TPeticion other = (TPeticion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPeticion = this.getIdPeticion();
        Long other$idPeticion = other.getIdPeticion();
        if (this$idPeticion == null ? other$idPeticion != null : !((Object)this$idPeticion).equals(other$idPeticion)) {
            return false;
        }
        LocalDateTime this$fechaHora = this.getFechaHora();
        LocalDateTime other$fechaHora = other.getFechaHora();
        if (this$fechaHora == null ? other$fechaHora != null : !((Object)this$fechaHora).equals(other$fechaHora)) {
            return false;
        }
        LocalDateTime this$fechaAutorizacion = this.getFechaAutorizacion();
        LocalDateTime other$fechaAutorizacion = other.getFechaAutorizacion();
        if (this$fechaAutorizacion == null ? other$fechaAutorizacion != null : !((Object)this$fechaAutorizacion).equals(other$fechaAutorizacion)) {
            return false;
        }
        String this$ambiente = this.getAmbiente();
        String other$ambiente = other.getAmbiente();
        if (this$ambiente == null ? other$ambiente != null : !this$ambiente.equals(other$ambiente)) {
            return false;
        }
        String this$ipOrigen = this.getIpOrigen();
        String other$ipOrigen = other.getIpOrigen();
        if (this$ipOrigen == null ? other$ipOrigen != null : !this$ipOrigen.equals(other$ipOrigen)) {
            return false;
        }
        String this$estado = this.getEstado();
        String other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        String this$claveAcceso = this.getClaveAcceso();
        String other$claveAcceso = other.getClaveAcceso();
        if (this$claveAcceso == null ? other$claveAcceso != null : !this$claveAcceso.equals(other$claveAcceso)) {
            return false;
        }
        String this$numeroAutorizacion = this.getNumeroAutorizacion();
        String other$numeroAutorizacion = other.getNumeroAutorizacion();
        if (this$numeroAutorizacion == null ? other$numeroAutorizacion != null : !this$numeroAutorizacion.equals(other$numeroAutorizacion)) {
            return false;
        }
        String this$numComprobante = this.getNumComprobante();
        String other$numComprobante = other.getNumComprobante();
        if (this$numComprobante == null ? other$numComprobante != null : !this$numComprobante.equals(other$numComprobante)) {
            return false;
        }
        String this$ruc = this.getRuc();
        String other$ruc = other.getRuc();
        return !(this$ruc == null ? other$ruc != null : !this$ruc.equals(other$ruc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TPeticion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPeticion = this.getIdPeticion();
        result = result * 59 + ($idPeticion == null ? 43 : ((Object)$idPeticion).hashCode());
        LocalDateTime $fechaHora = this.getFechaHora();
        result = result * 59 + ($fechaHora == null ? 43 : ((Object)$fechaHora).hashCode());
        LocalDateTime $fechaAutorizacion = this.getFechaAutorizacion();
        result = result * 59 + ($fechaAutorizacion == null ? 43 : ((Object)$fechaAutorizacion).hashCode());
        String $ambiente = this.getAmbiente();
        result = result * 59 + ($ambiente == null ? 43 : $ambiente.hashCode());
        String $ipOrigen = this.getIpOrigen();
        result = result * 59 + ($ipOrigen == null ? 43 : $ipOrigen.hashCode());
        String $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        String $claveAcceso = this.getClaveAcceso();
        result = result * 59 + ($claveAcceso == null ? 43 : $claveAcceso.hashCode());
        String $numeroAutorizacion = this.getNumeroAutorizacion();
        result = result * 59 + ($numeroAutorizacion == null ? 43 : $numeroAutorizacion.hashCode());
        String $numComprobante = this.getNumComprobante();
        result = result * 59 + ($numComprobante == null ? 43 : $numComprobante.hashCode());
        String $ruc = this.getRuc();
        result = result * 59 + ($ruc == null ? 43 : $ruc.hashCode());
        return result;
    }

    public String toString() {
        return "TPeticion(idPeticion=" + this.getIdPeticion() + ", fechaHora=" + this.getFechaHora() + ", fechaAutorizacion=" + this.getFechaAutorizacion() + ", ambiente=" + this.getAmbiente() + ", ipOrigen=" + this.getIpOrigen() + ", estado=" + this.getEstado() + ", claveAcceso=" + this.getClaveAcceso() + ", numeroAutorizacion=" + this.getNumeroAutorizacion() + ", numComprobante=" + this.getNumComprobante() + ", ruc=" + this.getRuc() + ")";
    }
}

