/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.exception;

import ec.tws2.back.contfiables.enums.CodigoRespuestasEnum;
import ec.tws2.back.contfiables.enums.EstadoFacturaEnum;
import ec.tws2.back.contfiables.exception.SriException;
import ec.tws2.back.contfiables.models.api.ApiRespuestaDTO;
import ec.tws2.back.contfiables.models.api.ErrorComprobanteDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleGlobalException(Exception ex, WebRequest request) {
        log.error("Error en el sistema mensaje {}, Error: {}", (Object)ex.getMessage(), (Object)ex);
        ApiRespuestaDTO response = ApiRespuestaDTO.error((String)EstadoFacturaEnum.ERROR.getEstado(), (ErrorComprobanteDTO)new ErrorComprobanteDTO(EstadoFacturaEnum.SIN_CLAVE_ACCESO.getEstado(), CodigoRespuestasEnum.ERROR_GENERICO.getCodigo(), CodigoRespuestasEnum.ERROR_GENERICO.getMensaje(), ex.getCause().getMessage(), EstadoFacturaEnum.ERROR.getEstado()));
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<Object> handleGlobalException(RuntimeException ex, WebRequest request) {
        log.error("Error en el sistema mensaje {}, Error: {}", (Object)ex.getMessage(), (Object)ex);
        ApiRespuestaDTO response = ApiRespuestaDTO.error((String)EstadoFacturaEnum.ERROR.getEstado(), (ErrorComprobanteDTO)new ErrorComprobanteDTO(EstadoFacturaEnum.SIN_CLAVE_ACCESO.getEstado(), CodigoRespuestasEnum.ERROR_GENERICO.getCodigo(), CodigoRespuestasEnum.ERROR_GENERICO.getMensaje(), ex.getCause().getMessage(), EstadoFacturaEnum.ERROR.getEstado()));
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={SriException.class})
    public ResponseEntity<Object> handleSriException(SriException ex) {
        ApiRespuestaDTO body = ApiRespuestaDTO.error((String)ex.getEstado(), (List)ex.getErrores());
        return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
    }
}

