/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controller;

import ec.com.awa.GeneradorRideSRI.ParametrosReporte;
import ec.com.awa.GeneradorRideSRI.modelo.utils.VisualizacionRideUtil;
import ec.tws2.back.contfiables.enums.CodigoRespuestasEnum;
import ec.tws2.back.contfiables.enums.EstadoFacturaEnum;
import ec.tws2.back.contfiables.models.DTO.RequestBillDTO;
import ec.tws2.back.contfiables.models.api.ApiRespuestaDTO;
import ec.tws2.back.contfiables.models.api.ErrorComprobanteDTO;
import ec.tws2.back.contfiables.models.email.CorreoModel;
import ec.tws2.back.contfiables.models.email.FileModel;
import ec.tws2.back.contfiables.service.ComprobanteService;
import ec.tws2.back.contfiables.service.CorreoService;
import ec.tws2.back.contfiables.service.FacturacionService;
import ec.tws2.back.contfiables.service.FileService;
import ec.tws2.back.contfiables.utils.PropiedadesSRI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ComprobantesController {
    private static final Logger log = LoggerFactory.getLogger(ComprobantesController.class);
    private boolean ambienteProduccion;
    @Autowired
    private PropiedadesSRI propSRI;
    @Autowired
    private FacturacionService facturacionService;
    @Autowired
    private ComprobanteService comprobanteService;
    @Autowired
    private CorreoService correoService;
    @Autowired
    private FileService fileService;

    @PostConstruct
    private void init() {
        this.ambienteProduccion = this.propSRI.getAmbienteActual().equals(String.valueOf(this.propSRI.getAmbienteProduccion()));
        log.info("ambiente: {} props: {}", (Object)this.ambienteProduccion, (Object)this.propSRI.getAmbienteActual());
        log.info("Comprobantes electronicos se enviaran a ambiente de {} ", (Object)(this.ambienteProduccion ? "PRODUCCION" : "PRUEBAS"));
    }

    @PostMapping(value={"enviaFacturav2"}, consumes={"application/json"}, produces={"application/json"})
    public Object enviarFacturaV2(@RequestBody RequestBillDTO requestBillDTO, HttpServletRequest requestHttp) throws Exception {
        log.info("Recibiendo solicitud de envio de factura");
        return this.facturacionService.enviarFacturaV2(requestBillDTO, requestHttp);
    }

    @GetMapping(value={"/consultaAutorizacion/{claveAcceso}"}, produces={"application/json"})
    public ApiRespuestaDTO consultaAutorizacion2(@PathVariable String claveAcceso) {
        return this.comprobanteService.consultaAutorizacion(claveAcceso);
    }

    @GetMapping(value={"/getPDF/{claveAcceso}"}, produces={"application/pdf"})
    public byte[] getPdf(@PathVariable String claveAcceso) {
        byte[] inFileBytes = null;
        try {
            String ruc = claveAcceso.substring(10, 23);
            String anio = claveAcceso.substring(4, 8);
            String mes = claveAcceso.substring(2, 4);
            String pathFile = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".xml";
            String pathPDF = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".pdf";
            String DirectorioBase = this.propSRI.getPathbase() + "/";
            ParametrosReporte parametro = new ParametrosReporte();
            parametro.setDirectorioBase(DirectorioBase);
            parametro.setLogo(this.propSRI.getPathbase() + "/" + ruc + "/" + ruc + ".png");
            VisualizacionRideUtil.decodeArchivoBase64((String)pathFile, null, null, (String)pathPDF, (ParametrosReporte)parametro);
            inFileBytes = Files.readAllBytes(Paths.get(pathPDF, new String[0]));
        }
        catch (IOException e) {
            log.error("Error al genera el PDF", (Throwable)e);
        }
        return inFileBytes;
    }

    @PostMapping(value={"/sentPDF"})
    public ResponseEntity<?> sentEmailPDF(@RequestParam String claveAcceso, @RequestParam String correoAdquiriente, @RequestParam String cuerpo) {
        try {
            String ruc = claveAcceso.substring(10, 23);
            String anio = claveAcceso.substring(4, 8);
            String mes = claveAcceso.substring(2, 4);
            String numeroComprobante = claveAcceso.substring(24, 27) + "-" + claveAcceso.substring(27, 30) + "-" + claveAcceso.substring(30, 39);
            String pathFile = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".xml";
            String pathPDF = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".pdf";
            String DirectorioBase = this.propSRI.getPathbase() + "/";
            ParametrosReporte parametro = new ParametrosReporte();
            parametro.setDirectorioBase(DirectorioBase);
            parametro.setLogo(this.propSRI.getPathbase() + "/" + ruc + "/" + ruc + ".png");
            log.info("Generando PDF para la clave de acceso: {}", (Object)claveAcceso);
            VisualizacionRideUtil.decodeArchivoBase64((String)pathFile, null, null, (String)pathPDF, (ParametrosReporte)parametro);
            CorreoModel correoModel = new CorreoModel();
            correoModel.setAsunto("Ha recibido un(a) Factura nuevo(a) No. " + numeroComprobante);
            correoModel.setCodigoEmail("BNg1IcQz48cIvU3hvbohcsKUVHWho7i9RhoiYmQQ3D4=");
            correoModel.setContenido(cuerpo);
            correoModel.setContentisHtml(Boolean.valueOf(true));
            correoModel.setDestinatarios(Arrays.asList(correoAdquiriente));
            ArrayList<FileModel> files = new ArrayList<FileModel>();
            String pdfBase64 = this.fileService.convertirArchivoABase64(pathPDF);
            String xmlBase64 = this.fileService.convertirArchivoABase64(pathFile);
            if (pdfBase64 != null) {
                files.add(new FileModel(pdfBase64, claveAcceso + ".pdf"));
            }
            if (xmlBase64 != null) {
                files.add(new FileModel(xmlBase64, claveAcceso + ".xml"));
            }
            correoModel.setArchivos(files);
            this.correoService.sendEmail(correoModel);
            ApiRespuestaDTO apiResponse = ApiRespuestaDTO.correoEnviado((String)EstadoFacturaEnum.CORREO_ENVIADO.getEstado(), (String)claveAcceso);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            log.error("Error al enviar el correo: {}", (Object)e.getMessage(), (Object)e);
            ApiRespuestaDTO apiResponse = ApiRespuestaDTO.error((String)EstadoFacturaEnum.FALLO_ENVIO_CORREO.getEstado(), (ErrorComprobanteDTO)new ErrorComprobanteDTO(claveAcceso, CodigoRespuestasEnum.ERROR_ENVIO_CORREO.getCodigo(), CodigoRespuestasEnum.ERROR_ENVIO_CORREO.getMensaje(), e.getCause().getMessage(), "ENVIAR_CORREO"));
            return ResponseEntity.status((int)500).body((Object)apiResponse);
        }
    }

    @GetMapping(value={"/getXML/{claveAcceso}"}, produces={"application/xml"})
    public ResponseEntity<?> getXML(@PathVariable String claveAcceso) {
        byte[] inFileBytes = null;
        try {
            String ruc = claveAcceso.substring(10, 23);
            String anio = claveAcceso.substring(4, 8);
            String mes = claveAcceso.substring(2, 4);
            String pathFile = this.propSRI.getPathbase() + "/" + ruc + "/" + this.propSRI.getAutorizados() + "/" + anio + "/" + mes + "/" + claveAcceso + ".xml";
            inFileBytes = Files.readAllBytes(Paths.get(pathFile, new String[0]));
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_XML).body((Object)inFileBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((int)404).build();
        }
    }
}

