/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.validators;

import com.contfiables.api.validators.FechaValida;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class FechaValidaValidator
implements ConstraintValidator<FechaValida, String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        try {
            LocalDate.parse(value, FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

