/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.utils;

import com.contfiables.api.DTO.Facturacion.ItemFacturaDTO;
import com.contfiables.api.DTO.Facturacion.ItemRateDTO;
import com.contfiables.api.DTO.impuestos.ImpuestoInfo;
import com.contfiables.api.service.ImpuestoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class ValidadorFactura {
    public static List<String> validarItemsConServicio(List<ItemFacturaDTO> items, ImpuestoService impuestoService) {
        ArrayList<String> errores = new ArrayList<String>();
        for (int idx = 0; idx < items.size(); ++idx) {
            ItemFacturaDTO item = items.get(idx);
            BigDecimal cantidad = item.getCantidad() != null ? item.getCantidad() : BigDecimal.ZERO;
            BigDecimal precioUnitario = item.getPrecioUnitario() != null ? item.getPrecioUnitario() : BigDecimal.ZERO;
            BigDecimal descuento = item.getDescuento() != null ? item.getDescuento() : BigDecimal.ZERO;
            BigDecimal subtotalEsperado = cantidad.multiply(precioUnitario).subtract(descuento).max(BigDecimal.ZERO);
            subtotalEsperado = subtotalEsperado.setScale(2, RoundingMode.HALF_UP);
            for (ItemRateDTO tasa : item.getTasasImpuesto()) {
                BigDecimal valorEsperado;
                BigDecimal valor;
                BigDecimal tarifaDecimal;
                ImpuestoInfo info = impuestoService.buscarInfoImpuesto(tasa.getCodigoTipoImpuesto(), tasa.getCodigoTarifaImpuesto());
                if (info == null) {
                    errores.add("\u00cdtem " + (idx + 1) + ": No se encontr\u00f3 tarifa para c\u00f3digo " + tasa.getCodigoTarifaImpuesto());
                    continue;
                }
                BigDecimal bigDecimal = tarifaDecimal = info.getTarifa() != null ? info.getTarifa().divide(new BigDecimal("100")) : null;
                if (tarifaDecimal == null) {
                    errores.add("\u00cdtem " + (idx + 1) + ": Tarifa nula para c\u00f3digo " + tasa.getCodigoTarifaImpuesto());
                    continue;
                }
                BigDecimal baseImponible = tasa.getBaseImponible() != null ? tasa.getBaseImponible().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                BigDecimal bigDecimal2 = valor = tasa.getValor() != null ? tasa.getValor().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                if (baseImponible.compareTo(subtotalEsperado) != 0) {
                    errores.add(String.format("\u00cdtem %d: Base imponible incorrecta (esperado: %s, recibido: %s)", idx + 1, subtotalEsperado, baseImponible));
                }
                if (valor.compareTo(valorEsperado = baseImponible.multiply(tarifaDecimal).setScale(2, RoundingMode.HALF_UP)) == 0) continue;
                errores.add(String.format("\u00cdtem %d: Valor impuesto incorrecto (esperado: %s, recibido: %s)", idx + 1, valorEsperado, valor));
            }
        }
        return errores;
    }
}

