/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.utils;

import com.contfiables.api.config.ApiResponse;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class IdentificationValidator {
    private static final String RUC_CODE = "04";
    private static final String CEDULA_CODE = "05";
    private static final String PASAPORTE_CODE = "06";
    private static final String CONSUMIDOR_FINAL_CODE = "07";
    private static final String EXTERIOR_CODE = "08";

    public ApiResponse<String> validarIdentificacion(String codigoSRI, String identificacion) {
        if (identificacion == null || identificacion.isBlank()) {
            return ApiResponse.validateFields((int)HttpStatus.BAD_REQUEST.value(), (String)"La identificaci\u00f3n no puede estar vac\u00eda.", null);
        }
        switch (codigoSRI) {
            case "04": {
                return this.validarRUCCompleto(identificacion);
            }
            case "05": {
                if (this.validarCedulaEcuatoriana(identificacion)) {
                    return ApiResponse.ok((Object)"Identificaci\u00f3n v\u00e1lida como c\u00e9dula ecuatoriana.", (boolean)true);
                }
                return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"Identificaci\u00f3n no v\u00e1lida como c\u00e9dula ecuatoriana.");
            }
            case "06": {
                return ApiResponse.ok((Object)"Identificaci\u00f3n v\u00e1lida como pasaporte.", (boolean)true);
            }
            case "07": {
                if ("9999999999999".equals(identificacion)) {
                    return ApiResponse.ok((Object)"Identificaci\u00f3n v\u00e1lida para consumidor final.", (boolean)true);
                }
                return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"El n\u00famero ingresado no corresponde a consumidor final.");
            }
            case "08": {
                return ApiResponse.ok((Object)"Identificaci\u00f3n v\u00e1lida de exterior.", (boolean)true);
            }
        }
        return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"C\u00f3digo de tipo de identificaci\u00f3n SRI desconocido.");
    }

    private ApiResponse<String> validarRUCCompleto(String number) {
        if (!number.matches("\\d{13}")) {
            return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"El RUC debe contener 13 d\u00edgitos num\u00e9ricos.");
        }
        String cedula = number.substring(0, 10);
        String suffix = number.substring(10);
        if (!"001".equals(suffix)) {
            return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"Los tres \u00faltimos d\u00edgitos deben ser '001'.");
        }
        int province = Integer.parseInt(number.substring(0, 2));
        if (province < 1 || province > 24) {
            return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"Los dos primeros d\u00edgitos de RUC deben estar entre 01 y 24.");
        }
        int third = Character.getNumericValue(number.charAt(2));
        switch (third) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!this.validarCedulaEcuatoriana(cedula)) {
                    return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"RUC de persona natural inv\u00e1lido (d\u00edgito verificador incorrecto).");
                }
                return ApiResponse.ok((Object)"RUC v\u00e1lido de persona natural.", (boolean)true);
            }
            case 6: {
                if (!this.validarModulo11(number.substring(0, 9), new int[]{3, 2, 7, 6, 5, 4, 3, 2})) {
                    return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"RUC de entidad p\u00fablica inv\u00e1lido (d\u00edgito verificador incorrecto).");
                }
                return ApiResponse.ok((Object)"RUC v\u00e1lido de entidad p\u00fablica.", (boolean)true);
            }
            case 9: {
                if (!this.validarModulo11(number.substring(0, 10), new int[]{4, 3, 2, 7, 6, 5, 4, 3, 2})) {
                    return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"RUC de sociedad privada inv\u00e1lido (d\u00edgito verificador incorrecto).");
                }
                return ApiResponse.ok((Object)"RUC v\u00e1lido de sociedad privada.", (boolean)true);
            }
        }
        return ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"Formato de RUC no reconocido (tercer d\u00edgito debe ser 0-5, 6 o 9).");
    }

    public boolean validarCedulaEcuatoriana(String identificacion) {
        if (identificacion == null || !identificacion.matches("\\d{10}")) {
            return false;
        }
        int province = Integer.parseInt(identificacion.substring(0, 2));
        if (province < 1 || province > 24) {
            return false;
        }
        int[] coef = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};
        int sum = 0;
        for (int i = 0; i < coef.length; ++i) {
            int prod = Character.getNumericValue(identificacion.charAt(i)) * coef[i];
            sum += prod > 9 ? prod - 9 : prod;
        }
        int verifier = 10 - sum % 10;
        if (verifier == 10) {
            verifier = 0;
        }
        return verifier == Character.getNumericValue(identificacion.charAt(9));
    }

    private boolean validarModulo11(String digits, int[] coef) {
        int sum = 0;
        for (int i = 0; i < coef.length; ++i) {
            sum += Character.getNumericValue(digits.charAt(i)) * coef[i];
        }
        int mod = sum % 11;
        int verifier = mod == 0 ? 0 : 11 - mod;
        return verifier == Character.getNumericValue(digits.charAt(coef.length));
    }
}

