/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.utils;

import com.contfiables.api.exceptions.CustomException;
import com.contfiables.api.model.Factura;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class FacturaConverterUtil {
    private final ObjectMapper objectMapper;

    public FacturaConverterUtil(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonNode convertirFacturaAJsonNode(Factura factura) throws Exception {
        return this.objectMapper.valueToTree((Object)factura);
    }

    public JsonNode convertirFacturaAJsonNodeExcepcion(Factura factura) {
        try {
            return this.convertirFacturaAJsonNode(factura);
        }
        catch (Exception e) {
            throw new CustomException("No se pudo verificar la estructura de la factura", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public Factura convertirJsonNodeAFactura(JsonNode jsonNode) throws Exception {
        return (Factura)this.objectMapper.treeToValue((TreeNode)jsonNode, Factura.class);
    }
}

