/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.utils;

import com.contfiables.api.model.Detalle;
import com.contfiables.api.model.Detalles;
import com.contfiables.api.model.Impuesto;
import com.contfiables.api.model.TotalConImpuestos;
import com.contfiables.api.model.TotalImpuesto;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacturaCalculator {
    private static final int DECIMALES = 2;

    public static BigDecimal calcularTotalSinImpuestos(Detalles detalles) {
        BigDecimal total = BigDecimal.ZERO;
        if (detalles == null || detalles.getDetalle() == null) {
            return total;
        }
        for (Detalle d : detalles.getDetalle()) {
            if (d == null) continue;
            BigDecimal cantidad = d.getCantidad() != null ? d.getCantidad() : BigDecimal.ZERO;
            BigDecimal precioUnitario = d.getPrecioUnitario() != null ? d.getPrecioUnitario() : BigDecimal.ZERO;
            BigDecimal descuento = d.getDescuento() != null ? d.getDescuento() : BigDecimal.ZERO;
            BigDecimal subtotal = cantidad.multiply(precioUnitario).subtract(descuento);
            subtotal = subtotal.max(BigDecimal.ZERO);
            subtotal = subtotal.setScale(2, RoundingMode.HALF_UP);
            total = total.add(subtotal);
        }
        return total.setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal calcularTotalDescuento(Detalles detalles) {
        BigDecimal total = BigDecimal.ZERO;
        if (detalles == null || detalles.getDetalle() == null) {
            return total;
        }
        for (Detalle d : detalles.getDetalle()) {
            if (d == null) continue;
            BigDecimal descuento = d.getDescuento() != null ? d.getDescuento() : BigDecimal.ZERO;
            total = total.add(descuento);
        }
        return total.setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal calcularTotalImpuestos(Detalles detalles) {
        BigDecimal total = BigDecimal.ZERO;
        if (detalles == null || detalles.getDetalle() == null) {
            return total;
        }
        for (Detalle d : detalles.getDetalle()) {
            if (d == null || d.getImpuestos() == null || d.getImpuestos().getImpuesto() == null) continue;
            for (Impuesto i : d.getImpuestos().getImpuesto()) {
                if (i == null || i.getValor() == null) continue;
                total = total.add(i.getValor());
            }
        }
        return total.setScale(2, RoundingMode.HALF_UP);
    }

    public static TotalConImpuestos generarTotalesImpuestosSRI(Detalles detalles) {
        LinkedHashMap<CallSite, TotalImpuesto> agrupados = new LinkedHashMap<CallSite, TotalImpuesto>();
        if (detalles == null || detalles.getDetalle() == null) {
            return new TotalConImpuestos(Collections.emptyList());
        }
        for (Detalle detalle : detalles.getDetalle()) {
            if (detalle == null || detalle.getImpuestos() == null || detalle.getImpuestos().getImpuesto() == null) continue;
            for (Impuesto impuesto : detalle.getImpuestos().getImpuesto()) {
                if (impuesto == null) continue;
                String clave = impuesto.getCodigo() + "-" + impuesto.getCodigoPorcentaje();
                TotalImpuesto acumulado = agrupados.getOrDefault(clave, new TotalImpuesto(String.valueOf(impuesto.getCodigo()), String.valueOf(impuesto.getCodigoPorcentaje()), Integer.valueOf(impuesto.getTarifa()), BigDecimal.ZERO, BigDecimal.ZERO));
                BigDecimal baseImp = impuesto.getBaseImponible() != null ? impuesto.getBaseImponible() : BigDecimal.ZERO;
                BigDecimal valorImp = impuesto.getValor() != null ? impuesto.getValor() : BigDecimal.ZERO;
                acumulado.setBaseImponible(acumulado.getBaseImponible().add(baseImp));
                acumulado.setValor(acumulado.getValor().add(valorImp));
                agrupados.put((CallSite)((Object)clave), acumulado);
            }
        }
        agrupados.values().forEach(ti -> {
            ti.setBaseImponible(ti.getBaseImponible().setScale(2, RoundingMode.HALF_UP));
            ti.setValor(ti.getValor().setScale(2, RoundingMode.HALF_UP));
        });
        return new TotalConImpuestos(new ArrayList(agrupados.values()));
    }

    public static BigDecimal calcularTotalConImpuestos(Detalles detalles) {
        BigDecimal totalSinImp = FacturaCalculator.calcularTotalSinImpuestos((Detalles)detalles);
        BigDecimal totalImp = FacturaCalculator.calcularTotalImpuestos((Detalles)detalles);
        return totalSinImp.add(totalImp).setScale(2, RoundingMode.HALF_UP);
    }
}

