/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.dao.TSecuenciaComprobanteDAO;
import com.contfiables.api.exceptions.CustomException;
import com.contfiables.api.service.SecuenciaService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecuenciaServiceImpl
implements SecuenciaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecuenciaServiceImpl.class);
    private final TSecuenciaComprobanteDAO tSecuenciaComprobanteDAO;

    public String obtenerSecuenciaFactura(String codigoEmpresa, String codigoEstablecimiento, String codigoPuntoEmision, String tipoComprobante) {
        log.info("Obteniendo secuencia para empresa: {}, establecimiento: {}, punto de emisi\u00f3n: {}", new Object[]{codigoEmpresa, codigoEstablecimiento, codigoPuntoEmision});
        Optional secuenciaOptional = this.tSecuenciaComprobanteDAO.obtenerSecuencia(codigoEmpresa, codigoEstablecimiento, codigoPuntoEmision, tipoComprobante);
        if (secuenciaOptional.isEmpty()) {
            log.error("No se encontr\u00f3 la secuencia para los par\u00e1metros proporcionados");
            throw new CustomException("No se encontr\u00f3 la secuencia para los par\u00e1metros proporcionados", HttpStatus.NOT_FOUND);
        }
        Long secuencia = (Long)secuenciaOptional.get();
        String secuenciaString = String.format("%09d", secuencia);
        return secuenciaString;
    }

    @Transactional
    public String generarNuevaSecuenciaFactura(String codigoEmpresa, String codigoEstablecimiento, String codigoPuntoEmision, String tipoComprobante) {
        Long secuencia;
        log.info("Generando nueva secuencia para empresa: {}, establecimiento: {}, punto de emisi\u00f3n: {}", new Object[]{codigoEmpresa, codigoEstablecimiento, codigoPuntoEmision});
        Optional secuenciaOptional = this.tSecuenciaComprobanteDAO.obtenerSecuenciaYActualizar(codigoEmpresa, codigoEstablecimiento, codigoPuntoEmision, tipoComprobante);
        if (secuenciaOptional.isEmpty()) {
            log.error("No se encontr\u00f3 la secuencia para los par\u00e1metros proporcionados");
            throw new CustomException("No se encontr\u00f3 la secuencia para los par\u00e1metros proporcionados", HttpStatus.NOT_FOUND);
        }
        Long l = secuencia = (Long)secuenciaOptional.get();
        secuencia = secuencia + 1L;
        log.info("Nueva secuencia generada: {}", (Object)secuencia);
        String secuenciaString = String.format("%09d", secuencia);
        return secuenciaString;
    }

    @Generated
    public SecuenciaServiceImpl(TSecuenciaComprobanteDAO tSecuenciaComprobanteDAO) {
        this.tSecuenciaComprobanteDAO = tSecuenciaComprobanteDAO;
    }
}

