/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.empresa.EmpresaFacturacionDTO;
import com.contfiables.api.DTO.reenvios.InfoFacuraReenvioDTO;
import com.contfiables.api.DTO.sri.RequestSriDto;
import com.contfiables.api.enums.EstadoComprobanteEnum;
import com.contfiables.api.model.Factura;
import com.contfiables.api.restTemplate.models.ApiRespuestaDTO;
import com.contfiables.api.restTemplate.service.SriApiService;
import com.contfiables.api.service.EmpresaDycoteinService;
import com.contfiables.api.service.FacturaHistoricoService;
import com.contfiables.api.service.ReenvioFacturasService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReenvioFacturasServiceImpl
implements ReenvioFacturasService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReenvioFacturasServiceImpl.class);
    private final FacturaHistoricoService facturaHistoricoService;
    private final EmpresaDycoteinService empresaService;
    private final SriApiService sriApiService;

    public void reintentarAutorizaciones() {
        List result = this.facturaHistoricoService.consultarFacturasLotePorAutorizar(3, 10);
        for (InfoFacuraReenvioDTO dto : result) {
            try {
                this.ejecutarProceso(dto);
            }
            catch (Exception e) {
                log.error("Fallo el proceso de autorizacion automatico", (Throwable)e);
            }
        }
        log.info("FINALIZA PROCESO AUTORIZACIONES");
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    private void ejecutarProceso(InfoFacuraReenvioDTO dto) {
        EmpresaFacturacionDTO empresaDTO = this.empresaService.findInformacionFacturacionByCodigoEmpresa(dto.getCodigoEmpresa());
        Factura factura = this.facturaHistoricoService.obtenerFacturaPorClaveAccesoYEstadoNotEquals(dto.getClaveAcceso(), EstadoComprobanteEnum.AUTORIZADO.getEstado());
        RequestSriDto requestSri = RequestSriDto.buildModelToSri((String)empresaDTO.getArchivoFirma(), (String)empresaDTO.getClaveFirma(), (Factura)factura);
        ApiRespuestaDTO apiRespuesta = this.sriApiService.consumeApiPost(requestSri);
        log.info("RESPUESTA API SRI {}", (Object)apiRespuesta);
        log.info("RESPUESTA COMPROBANTE: {}, ESTADO: {}", (Object)dto.getClaveAcceso(), (Object)apiRespuesta.getEstado());
        this.facturaHistoricoService.procesarYActualizarEstadoFactura(apiRespuesta, dto.getCodigoEmpresa(), dto.getClaveAcceso());
        log.info("COMPLETADO TRANSACCION");
    }

    @Generated
    public ReenvioFacturasServiceImpl(FacturaHistoricoService facturaHistoricoService, EmpresaDycoteinService empresaService, SriApiService sriApiService) {
        this.facturaHistoricoService = facturaHistoricoService;
        this.empresaService = empresaService;
        this.sriApiService = sriApiService;
    }
}

