/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.enums.EstadoComprobanteEnum;
import com.contfiables.api.restTemplate.models.ApiRespuestaDTO;
import com.contfiables.api.restTemplate.service.SriApiService;
import com.contfiables.api.service.FacturaHistoricoService;
import com.contfiables.api.service.NotificacionCorreoService;
import com.contfiables.api.utils.ParsearErroresApiResponseSri;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificacionCorreoServiceImpl
implements NotificacionCorreoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificacionCorreoServiceImpl.class);
    private final FacturaHistoricoService facturaHistoricoService;
    private final SriApiService sriApiService;

    public void notificarAutomaticamenteCorreos() {
        List clavesNotificar = this.facturaHistoricoService.listaClaves4notificarAutorizadas(3, 20);
        for (String clave : clavesNotificar) {
            try {
                this.enviarNotificacionFactura(clave);
            }
            catch (Exception e) {
                log.error("No se pudo notificar la clave {}, error", (Object)clave, (Object)e);
            }
        }
    }

    @Async
    public void enviarNotificacionFactura(String claveAcceso) {
        log.info("Enviando notificaci\u00f3n a: {}", (Object)claveAcceso);
        String correoAdquiriente = this.facturaHistoricoService.obtenerCorreoAdquirienteByClaveAccesoYEstado(claveAcceso, EstadoComprobanteEnum.AUTORIZADO.getEstado());
        if (correoAdquiriente != null) {
            ApiRespuestaDTO responseEmail = this.sriApiService.sendFacturaCorreo(correoAdquiriente, claveAcceso, "mensaje de prueba");
            String error = ParsearErroresApiResponseSri.parsearErroresListComprobantes((List)responseEmail.getErrores());
            this.facturaHistoricoService.actualizarEstadoEnviadoFactura(responseEmail.getEstado(), claveAcceso, error);
            log.info("Notificaci\u00f3n enviada a: {}", (Object)responseEmail);
            return;
        }
        log.warn("Facrtura no lista para enviarse");
    }

    @Generated
    public NotificacionCorreoServiceImpl(FacturaHistoricoService facturaHistoricoService, SriApiService sriApiService) {
        this.facturaHistoricoService = facturaHistoricoService;
        this.sriApiService = sriApiService;
    }
}

