/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.EmpresaDTO;
import com.contfiables.api.config.ApiResponse;
import com.contfiables.api.service.LogoService;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LogoServiceImpl
implements LogoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogoServiceImpl.class);
    @Value(value="${path.pc}")
    private String path;
    private static final int WIDTH = 335;
    private static final int HEIGHT = 168;

    public ResponseEntity<?> crearLogo(EmpresaDTO empresaDTO) {
        return this.processLogo(empresaDTO.getLogo(), empresaDTO.getRuc());
    }

    public ResponseEntity<?> actualizarLogo(MultipartFile logoFile, String ruc) {
        return this.processLogo(logoFile, ruc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity<?> processLogo(MultipartFile logoFile, String ruc) {
        try {
            byte[] data = logoFile.getBytes();
            File outFile = new File(this.path + File.separator + ruc, ruc + ".png");
            File dir = outFile.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                log.error("No se pudo crear el directorio: {}", (Object)dir.getAbsolutePath());
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (String)"No se pudo crear el directorio para el logo."));
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                BufferedImage original = ImageIO.read(in);
                if (original == null) {
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)400, (String)("El archivo no es una imagen v\u00e1lida para el RUC " + ruc)));
                    return responseEntity;
                }
                BufferedImage resized = new BufferedImage(335, 168, 1);
                Graphics2D g = resized.createGraphics();
                g.drawImage(original, 0, 0, 335, 168, null);
                g.dispose();
                ImageIO.write((RenderedImage)resized, "png", outFile);
                log.info("Logo procesado correctamente en: {}", (Object)outFile.getAbsolutePath());
                return ResponseEntity.ok((Object)ApiResponse.ok((Object)"Logo actualizado correctamente", (boolean)false));
            }
        }
        catch (Exception e) {
            log.error("Error al procesar logo para RUC {}: {}", (Object)ruc, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (String)"Error interno al actualizar el logo."));
        }
    }
}

