/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.ClienteFacturaDTO;
import com.contfiables.api.DTO.Facturacion.FacturaDycoDTO;
import com.contfiables.api.DTO.Facturacion.ItemFacturaDTO;
import com.contfiables.api.DTO.Facturacion.ItemRateDTO;
import com.contfiables.api.DTO.empresa.EmpresaFacturacionDTO;
import com.contfiables.api.DTO.impuestos.ImpuestoInfo;
import com.contfiables.api.DTO.puntoEmision.PuntoEmisionFacturaDTO;
import com.contfiables.api.config.SriProperties;
import com.contfiables.api.enums.TipoComprobanteEnum;
import com.contfiables.api.exceptions.CustomException;
import com.contfiables.api.model.CampoAdicional;
import com.contfiables.api.model.Detalle;
import com.contfiables.api.model.Detalles;
import com.contfiables.api.model.Impuesto;
import com.contfiables.api.model.Impuestos;
import com.contfiables.api.model.InfoAdicional;
import com.contfiables.api.model.InfoFactura;
import com.contfiables.api.model.InfoTributaria;
import com.contfiables.api.model.Pago;
import com.contfiables.api.model.Pagos;
import com.contfiables.api.model.TotalConImpuestos;
import com.contfiables.api.service.ClaveAccesoService;
import com.contfiables.api.service.FormaPagoService;
import com.contfiables.api.service.ImpuestoService;
import com.contfiables.api.service.LlenarFacturacionModelService;
import com.contfiables.api.service.SecuenciaService;
import com.contfiables.api.service.TipoIdentificacionService;
import com.contfiables.api.utils.FacturaCalculator;
import com.contfiables.api.utils.ValidadorFactura;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class LlenarFacturacionModelServiceImpl
implements LlenarFacturacionModelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LlenarFacturacionModelServiceImpl.class);
    private final ImpuestoService impuestoService;
    private final SecuenciaService secuenciaService;
    private final SriProperties sriProperties;
    private final ClaveAccesoService claveAccesoService;
    private final FormaPagoService formaPagoService;
    private final TipoIdentificacionService tipoIdentificacionService;

    public List<String> validarFactura(List<ItemFacturaDTO> items) {
        List validationErrors = ValidadorFactura.validarItemsConServicio(items, (ImpuestoService)this.impuestoService);
        if (!validationErrors.isEmpty()) {
            log.error("Errores de validaci\u00f3n encontrados: {}", (Object)validationErrors);
            throw new CustomException("Errores de validaci\u00f3n en los items de la factura: " + validationErrors, HttpStatus.BAD_REQUEST);
        }
        return List.of();
    }

    @Transactional
    public InfoTributaria buildInfoTributaria(String codigoEmpresa, EmpresaFacturacionDTO empresaDTO, FacturaDycoDTO dto) {
        String codigoTipoComprobante = TipoComprobanteEnum.FACTURA.getCodigo();
        String secuenciaFactura = this.secuenciaService.generarNuevaSecuenciaFactura(codigoEmpresa, dto.getEstablecimiento(), dto.getPuntoEmision(), codigoTipoComprobante);
        String claveAcceso = this.claveAccesoService.generarClaveAcceso(dto.getFechaEmision(), codigoTipoComprobante, empresaDTO.getRuc(), this.sriProperties.getAmbiente(), dto.getEstablecimiento(), dto.getPuntoEmision(), secuenciaFactura, this.sriProperties.getTipoEmision());
        log.info("Clave de acceso generada: {}", (Object)claveAcceso);
        log.info("Secuencia de factura obtenida: {}", (Object)secuenciaFactura);
        String razonSocial = empresaDTO.getRazonSocial();
        String nombreComercial = empresaDTO.getNombreComercial();
        String ruc = empresaDTO.getRuc();
        String dirMatriz = empresaDTO.getDireccionMatriz();
        return InfoTributaria.fillInfoTributaria((String)this.sriProperties.getAmbiente(), (String)this.sriProperties.getTipoEmision(), (String)razonSocial, (String)nombreComercial, (String)ruc, (String)claveAcceso, (String)codigoTipoComprobante, (String)dto.getEstablecimiento(), (String)dto.getPuntoEmision(), (String)secuenciaFactura, (String)dirMatriz, (String)empresaDTO.getTipoEmprendedor());
    }

    public InfoFactura buildInfoFactura(PuntoEmisionFacturaDTO puntoEmisionDto, EmpresaFacturacionDTO cli, FacturaDycoDTO datosFacturas, Detalles detalles) {
        String obligadoContabilidad = cli.getObligadoContabilidad() != false ? "SI" : "NO";
        BigDecimal totalSinImpuestos = FacturaCalculator.calcularTotalSinImpuestos((Detalles)detalles);
        BigDecimal totalDescuento = FacturaCalculator.calcularTotalDescuento((Detalles)detalles);
        BigDecimal totalImpuestos = FacturaCalculator.calcularTotalImpuestos((Detalles)detalles);
        TotalConImpuestos totalesImpuestos = FacturaCalculator.generarTotalesImpuestosSRI((Detalles)detalles);
        BigDecimal importeTotal = totalSinImpuestos.add(totalImpuestos);
        log.info("Total sin impuestos: {}, Total impuestos: {}, Total final: {}", new Object[]{totalSinImpuestos, totalImpuestos, importeTotal});
        Pagos pagos = this.buildPagos(datosFacturas.getCodigoFormaPago(), importeTotal);
        boolean tipoIdentificacionValido = this.tipoIdentificacionService.validarTipoIdentificacion(datosFacturas.getCliente().getCodigoTipoIdentificacion());
        if (!tipoIdentificacionValido) {
            throw new CustomException("Tipo de identificaci\u00f3n no v\u00e1lido: " + datosFacturas.getCliente().getCodigoTipoIdentificacion(), HttpStatus.BAD_REQUEST);
        }
        ClienteFacturaDTO cliente = datosFacturas.getCliente();
        return InfoFactura.fillInfoFactura((String)datosFacturas.getFechaEmision(), (String)puntoEmisionDto.getDireccionEstablecimiento(), (String)obligadoContabilidad, (String)cliente.getCodigoTipoIdentificacion(), (String)cliente.getRazonSocial(), (String)cliente.getIdentificacion(), (String)cliente.getDireccion(), (BigDecimal)totalSinImpuestos, (BigDecimal)totalDescuento, (TotalConImpuestos)totalesImpuestos, (BigDecimal)importeTotal, (Pagos)pagos);
    }

    public Detalles buildDetalles(FacturaDycoDTO datosFacturas) {
        ArrayList<Detalle> listaDetalles = new ArrayList<Detalle>();
        HashMap<String, ImpuestoInfo> cacheImpuestos = new HashMap<String, ImpuestoInfo>();
        for (ItemFacturaDTO item : datosFacturas.getItems()) {
            ArrayList<Impuesto> listaImpuestos = new ArrayList<Impuesto>();
            for (ItemRateDTO tasa : item.getTasasImpuesto()) {
                String clave = tasa.getCodigoTipoImpuesto() + "-" + tasa.getCodigoTarifaImpuesto();
                ImpuestoInfo info = cacheImpuestos.computeIfAbsent(clave, k -> this.impuestoService.buscarInfoImpuesto(tasa.getCodigoTipoImpuesto(), tasa.getCodigoTarifaImpuesto()));
                Impuesto impuesto = Impuesto.fillImpuesto((String)tasa.getCodigoTipoImpuesto(), (String)tasa.getCodigoTarifaImpuesto(), (int)Integer.parseInt(info.getTarifa().setScale(0).toString()), (BigDecimal)tasa.getBaseImponible(), (BigDecimal)tasa.getValor());
                listaImpuestos.add(impuesto);
            }
            BigDecimal cantidad = item.getCantidad();
            BigDecimal precioUnitario = item.getPrecioUnitario();
            BigDecimal descuento = item.getDescuento();
            BigDecimal precioTotalSinImpuesto = cantidad.multiply(precioUnitario).subtract(descuento);
            if (precioTotalSinImpuesto.compareTo(BigDecimal.ZERO) < 0) {
                precioTotalSinImpuesto = BigDecimal.ZERO;
            }
            Detalle detalle = Detalle.fillDetalle((String)item.getCodigo(), (String)item.getCodigo(), (String)item.getDescripcion(), (BigDecimal)item.getCantidad(), (BigDecimal)item.getPrecioUnitario(), (BigDecimal)item.getDescuento(), (BigDecimal)precioTotalSinImpuesto, (Impuestos)new Impuestos(listaImpuestos));
            listaDetalles.add(detalle);
        }
        return new Detalles(listaDetalles);
    }

    public InfoAdicional buildInfoAdicional() {
        CampoAdicional campoAdicional = new CampoAdicional("Valor Adicional", "Nombre Adicional");
        return new InfoAdicional(List.of(campoAdicional));
    }

    public Pagos buildPagos(String codigoPago, BigDecimal valorPago) {
        if (!this.formaPagoService.validarCodigoFormaPago(codigoPago)) {
            throw new CustomException("C\u00f3digo de forma de pago no v\u00e1lido: " + codigoPago, HttpStatus.NOT_FOUND);
        }
        Pago pago = Pago.fillPago((String)codigoPago, (BigDecimal)valorPago);
        return new Pagos(List.of(pago));
    }

    @Generated
    public LlenarFacturacionModelServiceImpl(ImpuestoService impuestoService, SecuenciaService secuenciaService, SriProperties sriProperties, ClaveAccesoService claveAccesoService, FormaPagoService formaPagoService, TipoIdentificacionService tipoIdentificacionService) {
        this.impuestoService = impuestoService;
        this.secuenciaService = secuenciaService;
        this.sriProperties = sriProperties;
        this.claveAccesoService = claveAccesoService;
        this.formaPagoService = formaPagoService;
        this.tipoIdentificacionService = tipoIdentificacionService;
    }
}

