/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.TarifaIvaDTO;
import com.contfiables.api.DTO.Facturacion.TipoTarifaImpuestoDTO;
import com.contfiables.api.DTO.impuestos.ImpuestoInfo;
import com.contfiables.api.enums.TipoTarifaImpuestoEnum;
import com.contfiables.api.exceptions.CustomException;
import com.contfiables.api.service.ImpuestoService;
import com.contfiables.api.service.TarifaIvaService;
import com.contfiables.api.service.TipoTarifaImpuestoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ImpuestoServiceImpl
implements ImpuestoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImpuestoServiceImpl.class);
    private final TipoTarifaImpuestoService tipoTarifaImpuestoService;
    private final TarifaIvaService tarifaIvaService;

    public ImpuestoInfo buscarInfoImpuesto(String codigoTipoImpuesto, String codigoTarifaImpuesto) {
        TipoTarifaImpuestoDTO tipoTarifaImpuesto = this.tipoTarifaImpuestoService.obtenerTarifaImpuestoPorCodigo(codigoTipoImpuesto);
        if (tipoTarifaImpuesto.getImpuesto().equals(TipoTarifaImpuestoEnum.IVA.getCodigo())) {
            TarifaIvaDTO tarifaIva = this.tarifaIvaService.obtenerTarifaIvaPorCodigo(codigoTarifaImpuesto);
            return ImpuestoInfo.builder().codigoTipoImpuesto(tipoTarifaImpuesto.getImpuesto()).codigoTarifaImpuesto(codigoTarifaImpuesto).nombre(tarifaIva.getDescripcion()).tarifa(tarifaIva.getPorcentaje()).build();
        }
        throw new CustomException("Codigo de impuesto no identificado", HttpStatus.NOT_FOUND);
    }

    @Generated
    public ImpuestoServiceImpl(TipoTarifaImpuestoService tipoTarifaImpuestoService, TarifaIvaService tarifaIvaService) {
        this.tipoTarifaImpuestoService = tipoTarifaImpuestoService;
        this.tarifaIvaService = tarifaIvaService;
    }
}

