/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.EmpresaDTO;
import com.contfiables.api.config.ApiResponse;
import com.contfiables.api.enums.ContfiablesEnum;
import com.contfiables.api.service.FirmaElectronicaService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FirmaElectronicaServiceImpl
implements FirmaElectronicaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmaElectronicaServiceImpl.class);
    @Value(value="${path.pc}")
    private String path;

    public ResponseEntity<?> almacenarArchivo(EmpresaDTO empresaDTO) {
        try {
            boolean archivoCreado;
            File directorio = new File(this.path.concat(empresaDTO.getRuc()));
            if (!directorio.exists()) {
                log.info("Intentando crear directorio: ", (Object)directorio.getAbsolutePath());
                boolean creado = directorio.mkdirs();
                if (!creado) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)("No se pudo crear el directorio para la empresa." + empresaDTO.getRuc())));
                }
                this.crearSubdirectorio(empresaDTO);
            }
            if (!(archivoCreado = this.crearArchivo(empresaDTO))) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (String)"La firma digital o la clave asociada no son v\u00e1lidas."));
            }
            return ResponseEntity.ok((Object)ApiResponse.ok((Object)"Archivo almacenado correctamente.", (boolean)false));
        }
        catch (Exception e) {
            log.error("Error al almacenar el archivo: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Error interno al almacenar el archivo."));
        }
    }

    public void crearSubdirectorio(EmpresaDTO empresaDTO) {
        try {
            File directorioAutorizado = new File(this.path, empresaDTO.getRuc() + File.separator + ContfiablesEnum.NAME_DIR_AUTORIZADOS.getId());
            File directorioFirmados = new File(this.path, empresaDTO.getRuc() + File.separator + ContfiablesEnum.NAME_DIR_FIRMADOS.getId());
            boolean creadoAutorizado = directorioAutorizado.mkdirs();
            boolean creadoFirmados = directorioFirmados.mkdirs();
            if (!creadoAutorizado && !directorioAutorizado.exists()) {
                log.error("No se pudo crear el subdirectorio autorizado: {}", (Object)directorioAutorizado.getAbsolutePath());
            }
            if (!creadoFirmados && !directorioFirmados.exists()) {
                log.error("No se pudo crear el subdirectorio firmados: {}", (Object)directorioFirmados.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error("Error creando subdirectorios para empresa {}: ", (Object)empresaDTO.getRuc(), (Object)e);
        }
    }

    public boolean crearArchivo(EmpresaDTO empresaDTO) {
        Path filePath = Path.of(this.path, empresaDTO.getRuc(), empresaDTO.getRuc() + ".p12");
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            log.info("Directorio asegurado en {}", (Object)filePath.getParent());
            byte[] fileBytes = empresaDTO.getArchivoFirma().getBytes();
            Files.write(filePath, fileBytes, new OpenOption[0]);
            log.info("Archivo P12 creado: {}", (Object)filePath);
            boolean firmaValida = this.validarFirma(filePath.toString(), empresaDTO);
            if (!firmaValida) {
                log.warn("Validaci\u00f3n de firma fallida para {}. Eliminando archivo.", (Object)filePath);
                Files.deleteIfExists(filePath);
                return false;
            }
            log.info("Firma validada correctamente para empresa", (Object)empresaDTO.getRuc());
            return true;
        }
        catch (IOException e) {
            log.error("Error de E/S al procesar el archivo P12 para RUC", (Object)empresaDTO.getRuc(), (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            log.error("Error inesperado al crear el archivo P12 para RUC", (Object)empresaDTO.getRuc(), (Object)e.getMessage());
            return false;
        }
    }

    public boolean validarFirma(String file, EmpresaDTO empresaDTO) {
        boolean respuesta = false;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, empresaDTO.getClaveFirma().toCharArray());
            fileInputStream.close();
            Certificate certificate = keyStore.getCertificate(keyStore.aliases().nextElement());
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                x509Certificate.checkValidity();
                respuesta = true;
            } else {
                respuesta = false;
            }
        }
        catch (Exception e) {
            return respuesta;
        }
        return respuesta;
    }
}

