/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.FacturaDycoDTO;
import com.contfiables.api.DTO.empresa.EmpresaFacturacionDTO;
import com.contfiables.api.DTO.puntoEmision.PuntoEmisionFacturaDTO;
import com.contfiables.api.DTO.sri.RequestSriDto;
import com.contfiables.api.config.ApiResponse;
import com.contfiables.api.config.SriProperties;
import com.contfiables.api.dao.TEmpresaDAO;
import com.contfiables.api.dao.TPuntoEmisionDAO;
import com.contfiables.api.exceptions.CustomException;
import com.contfiables.api.model.Detalles;
import com.contfiables.api.model.Factura;
import com.contfiables.api.model.InfoAdicional;
import com.contfiables.api.model.InfoFactura;
import com.contfiables.api.model.InfoTributaria;
import com.contfiables.api.restTemplate.models.ApiRespuestaDTO;
import com.contfiables.api.restTemplate.service.SriApiService;
import com.contfiables.api.service.FacturaHistoricoService;
import com.contfiables.api.service.FacturacionDycoteinService;
import com.contfiables.api.service.LlenarFacturacionModelService;
import com.contfiables.api.service.NotificacionCorreoService;
import com.contfiables.api.service.ValidacionAtributosTokenService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FacturacionDycoteinServiceImpl
implements FacturacionDycoteinService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturacionDycoteinServiceImpl.class);
    private final TEmpresaDAO tEmpresaDAO;
    private final ValidacionAtributosTokenService validacionAtributosTokenService;
    private final TPuntoEmisionDAO tPuntoEmisionDAO;
    private final LlenarFacturacionModelService llenarFacturacionModelService;
    private final FacturaHistoricoService facturaHistoricoService;
    private final SriApiService sriApiService;
    private final SriProperties sriProperties;
    private final NotificacionCorreoService notificacionCorreoService;

    @Transactional
    public ResponseEntity<?> facturar(FacturaDycoDTO datosFacturas) {
        log.info("Facturaci\u00f3n Dycotein: {}", (Object)datosFacturas);
        String codigoEmpresa = this.validacionAtributosTokenService.getIdentificacionEmpresa();
        log.info("ID del cliente obtenido del token: {}", (Object)codigoEmpresa);
        this.llenarFacturacionModelService.validarFactura(datosFacturas.getItems());
        EmpresaFacturacionDTO empresaDTO = this.tEmpresaDAO.findInformacionFacturacionByCodigoEmpresa(codigoEmpresa);
        log.info("Informaci\u00f3n de facturaci\u00f3n obtenida: {}", (Object)empresaDTO);
        Factura factura = this.procesarFactura(empresaDTO, codigoEmpresa, datosFacturas);
        log.info("Factura procesada: {}", (Object)factura);
        RequestSriDto requestSri = RequestSriDto.buildModelToSri((String)empresaDTO.getArchivoFirma(), (String)empresaDTO.getClaveFirma(), (Factura)factura);
        return this.enviarFacturaSri(requestSri, codigoEmpresa, factura.getInfoTributaria().getClaveAcceso());
    }

    public ResponseEntity<?> enviarFacturaSri(RequestSriDto requestSri, String codigoEmpresa, String claveAcceso) {
        log.info("Enviando factura al SRI: {}", (Object)claveAcceso);
        ApiRespuestaDTO response = this.sriApiService.consumeApiPost(requestSri);
        ApiRespuestaDTO responseProcessed = this.facturaHistoricoService.procesarYActualizarEstadoFactura(response, codigoEmpresa, claveAcceso);
        this.notificacionCorreoService.enviarNotificacionFactura(claveAcceso);
        ApiResponse apiResponse = ApiResponse.ok((Object)responseProcessed, (boolean)true);
        return ResponseEntity.ok((Object)apiResponse);
    }

    @Transactional
    public Factura procesarFactura(EmpresaFacturacionDTO empresaDTO, String codigoEmpresa, FacturaDycoDTO datosFacturas) {
        if (empresaDTO == null) {
            throw new CustomException("La empresa no est\u00e1 registrada o no tiene informaci\u00f3n de facturaci\u00f3n.", HttpStatus.BAD_REQUEST);
        }
        PuntoEmisionFacturaDTO puntoEmisionDto = this.tPuntoEmisionDAO.validatePuntoEmision(datosFacturas.getPuntoEmision(), datosFacturas.getEstablecimiento(), codigoEmpresa);
        if (puntoEmisionDto == null) {
            throw new CustomException("El punto de emisi\u00f3n no es v\u00e1lido para el establecimiento y cliente proporcionados.", HttpStatus.BAD_REQUEST);
        }
        log.info("Validaci\u00f3n de punto de emisi\u00f3n exitosa: {}", (Object)puntoEmisionDto);
        InfoTributaria infoTributaria = this.llenarFacturacionModelService.buildInfoTributaria(codigoEmpresa, empresaDTO, datosFacturas);
        Detalles detalles = this.llenarFacturacionModelService.buildDetalles(datosFacturas);
        log.info("Detalles de la factura construidos: {}", (Object)detalles);
        InfoFactura infoFactura = this.llenarFacturacionModelService.buildInfoFactura(puntoEmisionDto, empresaDTO, datosFacturas, detalles);
        InfoAdicional infoAdd = this.llenarFacturacionModelService.buildInfoAdicional();
        Factura factura = new Factura();
        factura.setInfoTributaria(infoTributaria);
        factura.setInfoFactura(infoFactura);
        factura.setInfoAdicional(infoAdd);
        factura.setDetalles(detalles);
        factura.setId(this.sriProperties.getId());
        factura.setVersion(this.sriProperties.getVersion());
        this.facturaHistoricoService.guardarFacturaNueva(codigoEmpresa, factura, datosFacturas.getCliente().getEmail());
        log.info("Factura guardada en el hist\u00f3rico");
        return factura;
    }

    @Generated
    public FacturacionDycoteinServiceImpl(TEmpresaDAO tEmpresaDAO, ValidacionAtributosTokenService validacionAtributosTokenService, TPuntoEmisionDAO tPuntoEmisionDAO, LlenarFacturacionModelService llenarFacturacionModelService, FacturaHistoricoService facturaHistoricoService, SriApiService sriApiService, SriProperties sriProperties, NotificacionCorreoService notificacionCorreoService) {
        this.tEmpresaDAO = tEmpresaDAO;
        this.validacionAtributosTokenService = validacionAtributosTokenService;
        this.tPuntoEmisionDAO = tPuntoEmisionDAO;
        this.llenarFacturacionModelService = llenarFacturacionModelService;
        this.facturaHistoricoService = facturaHistoricoService;
        this.sriApiService = sriApiService;
        this.sriProperties = sriProperties;
        this.notificacionCorreoService = notificacionCorreoService;
    }
}

