/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.reenvios.InfoFacuraReenvioDTO;
import com.contfiables.api.dao.TFacturaHistoricoDAO;
import com.contfiables.api.entity.TFacturaHistorico;
import com.contfiables.api.enums.ContfiablesEnum;
import com.contfiables.api.enums.EstadoComprobanteEnum;
import com.contfiables.api.model.Factura;
import com.contfiables.api.restTemplate.models.ApiRespuestaDTO;
import com.contfiables.api.restTemplate.models.ErrorComprobanteDTO;
import com.contfiables.api.service.FacturaHistoricoService;
import com.contfiables.api.utils.FacturaConverterUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FacturaHistoricoServiceImpl
implements FacturaHistoricoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturaHistoricoServiceImpl.class);
    private final TFacturaHistoricoDAO tFacturaHistoricoDAO;
    private final FacturaConverterUtil facturaConverterUtil;

    public List<String> listaClaves4notificarAutorizadas(int maxIntentos, int limit) {
        return this.tFacturaHistoricoDAO.getLoteClavesAccesoParaNotificarByStadoYLimit(EstadoComprobanteEnum.AUTORIZADO.getEstado(), maxIntentos, limit);
    }

    public List<InfoFacuraReenvioDTO> consultarFacturasLotePorAutorizar(int maxIntentos, int limit) {
        log.info("consultando registros para intentar autorizar: max intentos {}, max registros {}", (Object)maxIntentos, (Object)limit);
        return this.tFacturaHistoricoDAO.getLoteClavesAccesoParaReintentarDiffByStadoYLimit(EstadoComprobanteEnum.AUTORIZADO.getEstado(), maxIntentos, limit);
    }

    public String obtenerCorreoAdquirienteByClaveAccesoYEstado(String claveAcceso, String estado) {
        return this.tFacturaHistoricoDAO.findEmailByClaveAccesoAndCodigoEstado(claveAcceso, estado);
    }

    public Factura obtenerFacturaPorClaveAccesoYEstadoNotEquals(String claveAcceso, String estado) {
        log.info("Obteniendo factura historico por clave de acceso y estado");
        JsonNode facturaJsonNode = this.tFacturaHistoricoDAO.findByClaveAccesoAndCodigoEstadoNotEquals(claveAcceso, estado);
        try {
            if (facturaJsonNode == null || facturaJsonNode.isNull()) {
                log.info("No se encontr\u00f3 factura historico para clave de acceso: {} y estado: {}", (Object)claveAcceso, (Object)estado);
                return null;
            }
            Factura factura = this.facturaConverterUtil.convertirJsonNodeAFactura(facturaJsonNode);
            return factura;
        }
        catch (Exception e) {
            log.error("Error al convertir JsonNode a Factura: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al convertir JsonNode a Factura", e);
        }
    }

    public void actualizarEstadoEnviadoFactura(String estado, String claveAcceso, String error) {
        if (estado.equals(EstadoComprobanteEnum.CORREO_ENVIADO.getEstado())) {
            Integer respuestaRegistrosActualizados = this.tFacturaHistoricoDAO.updateEstadoEnviadoFactura(LocalDateTime.now(), claveAcceso, estado);
            log.info("Actualizando estado de factura historico: claveAcceso={}, estado={}, registros actualizados={}", new Object[]{claveAcceso, estado, respuestaRegistrosActualizados});
        } else {
            log.info("Actualizando estado de factura historico: claveAcceso={}, estado={}", (Object)claveAcceso, (Object)estado);
            String nuevoMensaje = estado + " - " + error == null ? "" : error;
            Integer respuestaActualizacion = this.tFacturaHistoricoDAO.updateEstadoEnviadoFactura(null, claveAcceso, nuevoMensaje);
            log.info("Actualizaci\u00f3n de estado de factura historico: claveAcceso={}, estado={}, registros actualizados={}", new Object[]{claveAcceso, estado, respuestaActualizacion});
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void guardarFacturaNueva(String codigoEmpresa, Factura factura, String emailAdquiriente) {
        log.info("Guardando factura historico: codigoEmpresa={}", (Object)codigoEmpresa);
        String fechaEmision = factura.getInfoFactura().getFechaEmision();
        String claveAcceso = factura.getInfoTributaria().getClaveAcceso();
        String establecimiento = factura.getInfoTributaria().getEstab();
        String puntoEmision = factura.getInfoTributaria().getPtoEmi();
        String secuencia = factura.getInfoTributaria().getSecuencial();
        String fullSecuencial = establecimiento + "-" + puntoEmision + "-" + secuencia;
        JsonNode facturaJsonNode = this.facturaConverterUtil.convertirFacturaAJsonNodeExcepcion(factura);
        TFacturaHistorico tFacturaHistorico = TFacturaHistorico.inicarProceso((String)fechaEmision, (String)fullSecuencial, (String)codigoEmpresa, (String)claveAcceso, (JsonNode)facturaJsonNode, (String)emailAdquiriente);
        this.saveFacturaHistorico(tFacturaHistorico);
    }

    public ApiRespuestaDTO procesarYActualizarEstadoFactura(ApiRespuestaDTO apiRespuesta, String codigoEmpresa, String claveAcceso) {
        String estadoRespuestaSri = apiRespuesta.getEstado();
        if (estadoRespuestaSri == null) {
            estadoRespuestaSri = "ERROR";
        }
        log.info("Actualizando estado autorizado de factura historico: claveAcceso={}, codigoEmpresa={}", (Object)claveAcceso, (Object)codigoEmpresa);
        if (apiRespuesta.getEstado().equals(EstadoComprobanteEnum.AUTORIZADO.getEstado())) {
            this.actualizarEstadoAutorizado(apiRespuesta, codigoEmpresa);
            return apiRespuesta;
        }
        if (estadoRespuestaSri.equals(ContfiablesEnum.NETWORK_ERROR.getDescripcion())) {
            apiRespuesta.setEstado(EstadoComprobanteEnum.PENDIENTE.getEstado());
            this.actualizarEstadoError(apiRespuesta, claveAcceso, codigoEmpresa);
            return apiRespuesta;
        }
        apiRespuesta.setEstado(apiRespuesta.getEstado());
        this.actualizarEstadoError(apiRespuesta, claveAcceso, codigoEmpresa);
        return apiRespuesta;
    }

    private void actualizarEstadoAutorizado(ApiRespuestaDTO apiRespuesta, String codigoEmpresa) {
        log.info("Comprobante autorizado");
        Integer respuestaActualizacion = this.tFacturaHistoricoDAO.updateFacturaDetails(apiRespuesta.getEstado(), apiRespuesta.getAmbiente(), LocalDateTime.now(), apiRespuesta.getFechaAutorizacion(), apiRespuesta.getNumeroAutorizacion(), codigoEmpresa);
        this.tFacturaHistoricoDAO.flush();
        log.info("Actualizaci\u00f3n de estado de factura historico: {} registros actualizados", (Object)respuestaActualizacion);
    }

    private void actualizarEstadoError(ApiRespuestaDTO apiRespuesta, String claveAcceso, String codigoEmpresa) {
        List errorMessageList = apiRespuesta.getErrores();
        Object errorMessage = "";
        if (errorMessageList == null || errorMessageList.isEmpty()) {
            errorMessage = "Error desconocido";
        }
        if (errorMessageList != null && !errorMessageList.isEmpty()) {
            for (ErrorComprobanteDTO err : errorMessageList) {
                errorMessage = (String)errorMessage + err.getMensaje() + "; ";
            }
        }
        Integer respuestaActualizacion = this.tFacturaHistoricoDAO.updateFacturaDetailsError(EstadoComprobanteEnum.PENDIENTE.getEstado(), apiRespuesta.getAmbiente(), LocalDateTime.now(), (String)errorMessage, claveAcceso, codigoEmpresa);
        log.info("Actualizaci\u00f3n de estado de factura historico: {} registros actualizados", (Object)respuestaActualizacion);
    }

    public void saveFacturaHistorico(TFacturaHistorico tFacturaHistorico) {
        log.info("Guardando factura historico");
        try {
            this.tFacturaHistoricoDAO.save((Object)tFacturaHistorico);
            log.info("Factura historico guardada exitosamente: {}", (Object)tFacturaHistorico.getNumFactura());
        }
        catch (Exception e) {
            log.error("Error al guardar factura historico: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al guardar factura historico", e);
        }
    }

    @Generated
    public FacturaHistoricoServiceImpl(TFacturaHistoricoDAO tFacturaHistoricoDAO, FacturaConverterUtil facturaConverterUtil) {
        this.tFacturaHistoricoDAO = tFacturaHistoricoDAO;
        this.facturaConverterUtil = facturaConverterUtil;
    }
}

