/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.service.impl;

import com.contfiables.api.DTO.Facturacion.EmpresaDTO;
import com.contfiables.api.DTO.empresa.EmpresaFacturacionDTO;
import com.contfiables.api.DTO.empresa.EmpresaUpdateDTO;
import com.contfiables.api.config.ApiResponse;
import com.contfiables.api.dao.TEmpresaDAO;
import com.contfiables.api.dao.TEstablecimientoDAO;
import com.contfiables.api.dao.TPuntoEmisionDAO;
import com.contfiables.api.dao.TSecuenciaComprobanteDAO;
import com.contfiables.api.dao.TTipoIdentificacionDAO;
import com.contfiables.api.entity.TEmpresa;
import com.contfiables.api.entity.TEstablecimiento;
import com.contfiables.api.entity.TPuntoEmision;
import com.contfiables.api.entity.TTipoIdentificacion;
import com.contfiables.api.model.CredentialKeycloak;
import com.contfiables.api.model.UsuarioKeycloak;
import com.contfiables.api.service.EmpresaDycoteinService;
import com.contfiables.api.service.FirmaElectronicaService;
import com.contfiables.api.service.ValidacionAtributosTokenService;
import com.contfiables.api.service.impl.LogoServiceImpl;
import com.contfiables.api.utils.IdentificationValidator;
import com.contfiables.api.utils.Seguridad;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EmpresaDycoteinServiceImpl
implements EmpresaDycoteinService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmpresaDycoteinServiceImpl.class);
    private final ValidacionAtributosTokenService validacionAtributosTokenService;
    private final IdentificationValidator identificationValidator;
    private final FirmaElectronicaService firmaElectronicaService;
    private final LogoServiceImpl logoService;
    private final TEmpresaDAO tEmpresaDAO;
    private final TTipoIdentificacionDAO tTipoIdentificacionDAO;
    private final Seguridad seguridad;
    private final TEstablecimientoDAO establecimientoDAO;
    private final TPuntoEmisionDAO puntoEmisionDAO;
    private final TSecuenciaComprobanteDAO secuenciaComprobanteDAO;
    private final Environment env;
    private final ObjectMapper objectMapper;

    public EmpresaFacturacionDTO findInformacionFacturacionByCodigoEmpresa(String codigoEmpresa) {
        return this.tEmpresaDAO.findInformacionFacturacionByCodigoEmpresa(codigoEmpresa);
    }

    public ResponseEntity<?> empresa(EmpresaDTO empresa) {
        try {
            log.info("Guardando empresa: {}", (Object)empresa);
            String codigoEmpresa = this.validacionAtributosTokenService.getIdentificacionEmpresa();
            log.info("ID del cliente obtenido del token: {}", (Object)codigoEmpresa);
            ApiResponse valid = this.identificationValidator.validarIdentificacion(empresa.getIdTipoIdentificacion(), empresa.getRuc());
            if (!valid.isSuccess()) {
                return ResponseEntity.badRequest().body((Object)valid);
            }
            if (this.tEmpresaDAO.existsByRuc(empresa.getRuc())) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (String)"Ya existe una empresa con el RUC proporcionado"));
            }
            if (this.tEmpresaDAO.existsByEmail(empresa.getEmail())) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (String)"Ya existe una empresa con el email proporcionado"));
            }
            if (this.tEmpresaDAO.existsByUsername(empresa.getUsername())) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (String)"Ya existe una empresa con el username proporcionado"));
            }
            if (!this.tTipoIdentificacionDAO.existsByCodigo(empresa.getIdTipoIdentificacion())) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (String)"Tipo de identificaci\u00f3n no v\u00e1lido"));
            }
            ResponseEntity responseArchivo = this.firmaElectronicaService.almacenarArchivo(empresa);
            if (!responseArchivo.getStatusCode().is2xxSuccessful()) {
                log.error("Error almacenando archivo de firma: {}", responseArchivo.getBody());
                return responseArchivo;
            }
            ResponseEntity responseLogo = this.logoService.crearLogo(empresa);
            if (!responseLogo.getStatusCode().is2xxSuccessful()) {
                log.error("Error almacenando de logo: {}", responseArchivo.getBody());
                return responseLogo;
            }
            EmpresaDTO empresaGuardada = this.guardarEmpresa(empresa);
            log.info("Empresa guardada: {}", (Object)empresaGuardada);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ApiResponse.ok((Object)"Empresa registrada correctamente", (boolean)false));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (String)"Error al guardar la empresa"));
        }
    }

    public EmpresaDTO guardarEmpresa(EmpresaDTO empresa) {
        try {
            log.info("Guardando empresa: {}", (Object)empresa);
            TEmpresa tEmpresa = new TEmpresa();
            tEmpresa.setArchivoFirma(empresa.getRuc() + ".p12");
            tEmpresa.setClaveFirma(this.seguridad.encrypt(empresa.getClaveFirma()));
            tEmpresa.setContribuyenteEspecial(empresa.getContribuyenteEspecial());
            tEmpresa.setDireccionMatriz(empresa.getDireccionMatriz());
            tEmpresa.setEmail(empresa.getEmail());
            tEmpresa.setFechaCreacion(empresa.getFechaCreacion());
            tEmpresa.setFechaModificacion(empresa.getFechaModificacion());
            tEmpresa.setLogo(empresa.getRuc() + ".png");
            tEmpresa.setNombreComercial(empresa.getNombreComercial());
            tEmpresa.setObligadoContabilidad(empresa.getObligadoContabilidad());
            tEmpresa.setRazonSocial(empresa.getRazonSocial());
            tEmpresa.setRuc(empresa.getRuc());
            tEmpresa.setTelefono(empresa.getTelefono());
            tEmpresa.setTipoEmprendedor(empresa.getTipoEmprendedor());
            tEmpresa.setUsername(empresa.getUsername());
            TTipoIdentificacion tipoIdentificacion = this.tTipoIdentificacionDAO.findByCodigo(empresa.getIdTipoIdentificacion());
            tEmpresa.setTipoIdentificacion(tipoIdentificacion);
            this.tEmpresaDAO.save((Object)tEmpresa);
            TEstablecimiento nuevoEstablecimiento = new TEstablecimiento();
            nuevoEstablecimiento.setEstablecimiento(empresa.getEstablecimiento());
            nuevoEstablecimiento.setDescripcion(empresa.getDescripcionEstablecimiento());
            nuevoEstablecimiento.setDireccion(empresa.getDireccionEstablecimiento());
            nuevoEstablecimiento.setEmpresa(tEmpresa);
            nuevoEstablecimiento.setActivo(true);
            this.establecimientoDAO.save((Object)nuevoEstablecimiento);
            TPuntoEmision nuevoPunto = new TPuntoEmision();
            nuevoPunto.setPuntoEmision(empresa.getPuntoEmision());
            nuevoPunto.setNombre(empresa.getNombrePuntoEmision());
            nuevoPunto.setPrincipal(empresa.getPuntoEmisionPrincipal());
            nuevoPunto.setActivo(Boolean.valueOf(true));
            nuevoPunto.setEstablecimiento(nuevoEstablecimiento);
            this.puntoEmisionDAO.save((Object)nuevoPunto);
            if (empresa.getSecuencia() != null) {
                Optional actual = this.secuenciaComprobanteDAO.actualizarYDevolverSecuencia(tEmpresa.getCodigoEmpresa(), empresa.getEstablecimiento(), empresa.getPuntoEmision(), tEmpresa.getTipoIdentificacion().getCodigo(), empresa.getSecuencia());
                actual.ifPresent(arg_0 -> ((EmpresaDTO)empresa).setSecuencia(arg_0));
            }
            UsuarioKeycloak crearUsuario = new UsuarioKeycloak();
            crearUsuario.setFirstName(empresa.getNombreComercial());
            crearUsuario.setLastName(empresa.getNombreComercial());
            crearUsuario.setUsername(empresa.getUsername());
            crearUsuario.setEmail(empresa.getEmail());
            crearUsuario.setEnabled(true);
            crearUsuario.setEmailVerified(true);
            crearUsuario.setAttributes(Map.of("idCliente", List.of(tEmpresa.getCodigoEmpresa())));
            CredentialKeycloak credential = new CredentialKeycloak();
            credential.setType("password");
            credential.setValue(empresa.getPassword());
            credential.setTemporary(false);
            crearUsuario.setCredentials(List.of(credential));
            this.guardarUsuarioKeycloak(crearUsuario);
            return empresa;
        }
        catch (Exception e) {
            log.error("Error al guardar la empresa: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al guardar la empresa: " + e.getMessage());
        }
    }

    public ResponseEntity<?> actualizarEmpresa(EmpresaUpdateDTO dto) {
        String codigoEmpresa = this.validacionAtributosTokenService.getIdentificacionEmpresa();
        Optional opt = this.tEmpresaDAO.findByCodigoEmpresa(codigoEmpresa);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((int)404, (String)"Empresa no encontrada"));
        }
        TEmpresa ent = (TEmpresa)opt.get();
        if (dto.getLogo() != null && !dto.getLogo().isEmpty()) {
            String ruc = ent.getRuc();
            ResponseEntity res = this.logoService.actualizarLogo(dto.getLogo(), ruc);
            if (!res.getStatusCode().is2xxSuccessful()) {
                return res;
            }
            ent.setLogo(ruc + ".png");
        }
        if (dto.getNombreComercial() != null) {
            ent.setNombreComercial(dto.getNombreComercial());
        }
        if (dto.getRazonSocial() != null) {
            ent.setRazonSocial(dto.getRazonSocial());
        }
        if (dto.getDireccionMatriz() != null) {
            ent.setDireccionMatriz(dto.getDireccionMatriz());
        }
        ent.setFechaModificacion(LocalDateTime.now());
        this.tEmpresaDAO.save((Object)ent);
        return ResponseEntity.ok((Object)ApiResponse.ok((Object)"Empresa actualizada correctamente", (boolean)false));
    }

    public void guardarUsuarioKeycloak(UsuarioKeycloak crearuser) throws Exception {
        String serverSeguridad = this.env.getProperty("property.seguridad.server");
        RestTemplate restTemplate = new RestTemplate();
        String url = serverSeguridad + this.env.getProperty("users.keycloak");
        String requestJson = this.objectMapper.writeValueAsString((Object)crearuser);
        String token = this.getMyToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
    }

    public String getMyToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        log.info("auth: {}", (Object)authentication);
        log.info("instancia: " + (authentication instanceof JwtAuthenticationToken));
        if (authentication instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            log.info("jwt: {}", (Object)jwt);
            return jwt.getTokenValue();
        }
        return null;
    }

    @Generated
    public EmpresaDycoteinServiceImpl(ValidacionAtributosTokenService validacionAtributosTokenService, IdentificationValidator identificationValidator, FirmaElectronicaService firmaElectronicaService, LogoServiceImpl logoService, TEmpresaDAO tEmpresaDAO, TTipoIdentificacionDAO tTipoIdentificacionDAO, Seguridad seguridad, TEstablecimientoDAO establecimientoDAO, TPuntoEmisionDAO puntoEmisionDAO, TSecuenciaComprobanteDAO secuenciaComprobanteDAO, Environment env, ObjectMapper objectMapper) {
        this.validacionAtributosTokenService = validacionAtributosTokenService;
        this.identificationValidator = identificationValidator;
        this.firmaElectronicaService = firmaElectronicaService;
        this.logoService = logoService;
        this.tEmpresaDAO = tEmpresaDAO;
        this.tTipoIdentificacionDAO = tTipoIdentificacionDAO;
        this.seguridad = seguridad;
        this.establecimientoDAO = establecimientoDAO;
        this.puntoEmisionDAO = puntoEmisionDAO;
        this.secuenciaComprobanteDAO = secuenciaComprobanteDAO;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

