/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.restTemplate.service;

import com.contfiables.api.DTO.sri.RequestSriDto;
import com.contfiables.api.enums.ContfiablesEnum;
import com.contfiables.api.restTemplate.models.ApiRespuestaDTO;
import com.contfiables.api.restTemplate.models.ErrorComprobanteDTO;
import com.contfiables.api.restTemplate.service.SriApiService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.SocketTimeoutException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class SriApiServiceImpl
implements SriApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SriApiServiceImpl.class);
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final Environment env;

    public ApiRespuestaDTO consumeApiPost(RequestSriDto requestDTO) {
        log.info("Consuming SRI API request");
        String sriApiUrl = this.env.getProperty("api.sri.url.facturar");
        String claveAcceso = requestDTO.getFactura().getInfoTributaria().getClaveAcceso();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)requestDTO, (MultiValueMap)headers);
        return this.consumeApi(sriApiUrl, HttpMethod.POST, entity, ApiRespuestaDTO.class, claveAcceso);
    }

    public ApiRespuestaDTO sendFacturaCorreo(String correo, String claveAcceso, String cuerpo) {
        log.info("Sending factura via email to: {}", (Object)correo);
        String correoApi = this.env.getProperty("api.sri.url.enviarCorreo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"correoAdquiriente", (Object)correo);
        body.add((Object)"claveAcceso", (Object)claveAcceso);
        body.add((Object)"cuerpo", (Object)cuerpo);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        return this.consumeApi(correoApi, HttpMethod.POST, entity, ApiRespuestaDTO.class, claveAcceso);
    }

    private <T> ApiRespuestaDTO consumeApi(String url, HttpMethod httpMethod, HttpEntity<?> entity, Class<T> responseType, String claveAcceso) {
        log.info("Consuming API at URL: {}", (Object)url);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, httpMethod, entity, String.class, new Object[0]);
            String responseJson = (String)responseEntity.getBody();
            return (ApiRespuestaDTO)this.objectMapper.readValue(responseJson, ApiRespuestaDTO.class);
        }
        catch (ResourceAccessException e) {
            String errorMessage = e.getCause() instanceof SocketTimeoutException ? "Timeout reached while connecting to the server" : "Connection refused or network error";
            return new ApiRespuestaDTO(ContfiablesEnum.NETWORK_ERROR.getDescripcion(), null, null, null, List.of(new ErrorComprobanteDTO(claveAcceso, "503", errorMessage, "Server not available", ContfiablesEnum.NETWORK_ERROR.getDescripcion())));
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            return this.handleHttpError(e.getResponseBodyAsString(), claveAcceso);
        }
        catch (Exception e) {
            return new ApiRespuestaDTO("ERROR", null, null, null, List.of(new ErrorComprobanteDTO(claveAcceso, "500", e.getMessage(), "Unexpected error", "UNKNOWN_ERROR")));
        }
    }

    private ApiRespuestaDTO handleHttpError(String responseJson, String claveAcceso) {
        log.error("HTTP error response: {}", (Object)responseJson);
        try {
            ApiRespuestaDTO errorMessage = (ApiRespuestaDTO)this.objectMapper.readValue(responseJson, ApiRespuestaDTO.class);
            return errorMessage;
        }
        catch (Exception e) {
            return new ApiRespuestaDTO("ERROR", null, null, null, List.of(new ErrorComprobanteDTO(claveAcceso, "500", "Error parsing error message", "Unexpected error", "PARSE ERROR")));
        }
    }

    @Generated
    public SriApiServiceImpl(RestTemplate restTemplate, ObjectMapper objectMapper, Environment env) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.env = env;
    }
}

