/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.entity;

import com.contfiables.api.entity.TTipoTarifaImpuesto;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;

@Entity
@Table(name="t_tariva_iva")
public class TTarifaIva {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="codigo_sri", length=2, unique=true, nullable=false)
    private String codigoSri;
    @Column(name="descripcion", length=150, nullable=false)
    private String descripcion;
    @Column(name="porcentaje", precision=5, scale=2)
    private BigDecimal porcentaje;
    @Column(name="es_categoria_especial")
    private Boolean esCategoriaEspecial;
    @Column(name="activo")
    private boolean activo;
    @Column(name="fecha_creacion", nullable=false)
    private LocalDateTime fechaCreacion;
    @Column(name="fecha_modificacion", nullable=false)
    private LocalDateTime fechaModificacion;
    @ManyToOne
    @JoinColumn(name="id_tipo_tarifa_impuesto", nullable=false)
    private TTipoTarifaImpuesto tipoTarifaImpuesto;

    @PrePersist
    protected void onCreate() {
        LocalDateTime nowEcuador;
        this.fechaCreacion = nowEcuador = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
        this.fechaModificacion = nowEcuador;
    }

    @PreUpdate
    protected void onUpdate() {
        this.fechaModificacion = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCodigoSri() {
        return this.codigoSri;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public BigDecimal getPorcentaje() {
        return this.porcentaje;
    }

    @Generated
    public Boolean getEsCategoriaEspecial() {
        return this.esCategoriaEspecial;
    }

    @Generated
    public boolean isActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public LocalDateTime getFechaModificacion() {
        return this.fechaModificacion;
    }

    @Generated
    public TTipoTarifaImpuesto getTipoTarifaImpuesto() {
        return this.tipoTarifaImpuesto;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigoSri(String codigoSri) {
        this.codigoSri = codigoSri;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setPorcentaje(BigDecimal porcentaje) {
        this.porcentaje = porcentaje;
    }

    @Generated
    public void setEsCategoriaEspecial(Boolean esCategoriaEspecial) {
        this.esCategoriaEspecial = esCategoriaEspecial;
    }

    @Generated
    public void setActivo(boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @Generated
    public void setFechaModificacion(LocalDateTime fechaModificacion) {
        this.fechaModificacion = fechaModificacion;
    }

    @Generated
    public void setTipoTarifaImpuesto(TTipoTarifaImpuesto tipoTarifaImpuesto) {
        this.tipoTarifaImpuesto = tipoTarifaImpuesto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TTarifaIva)) {
            return false;
        }
        TTarifaIva other = (TTarifaIva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isActivo() != other.isActivo()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$esCategoriaEspecial = this.getEsCategoriaEspecial();
        Boolean other$esCategoriaEspecial = other.getEsCategoriaEspecial();
        if (this$esCategoriaEspecial == null ? other$esCategoriaEspecial != null : !((Object)this$esCategoriaEspecial).equals(other$esCategoriaEspecial)) {
            return false;
        }
        String this$codigoSri = this.getCodigoSri();
        String other$codigoSri = other.getCodigoSri();
        if (this$codigoSri == null ? other$codigoSri != null : !this$codigoSri.equals(other$codigoSri)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        BigDecimal this$porcentaje = this.getPorcentaje();
        BigDecimal other$porcentaje = other.getPorcentaje();
        if (this$porcentaje == null ? other$porcentaje != null : !((Object)this$porcentaje).equals(other$porcentaje)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        LocalDateTime this$fechaModificacion = this.getFechaModificacion();
        LocalDateTime other$fechaModificacion = other.getFechaModificacion();
        if (this$fechaModificacion == null ? other$fechaModificacion != null : !((Object)this$fechaModificacion).equals(other$fechaModificacion)) {
            return false;
        }
        TTipoTarifaImpuesto this$tipoTarifaImpuesto = this.getTipoTarifaImpuesto();
        TTipoTarifaImpuesto other$tipoTarifaImpuesto = other.getTipoTarifaImpuesto();
        return !(this$tipoTarifaImpuesto == null ? other$tipoTarifaImpuesto != null : !this$tipoTarifaImpuesto.equals(other$tipoTarifaImpuesto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TTarifaIva;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivo() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $esCategoriaEspecial = this.getEsCategoriaEspecial();
        result = result * 59 + ($esCategoriaEspecial == null ? 43 : ((Object)$esCategoriaEspecial).hashCode());
        String $codigoSri = this.getCodigoSri();
        result = result * 59 + ($codigoSri == null ? 43 : $codigoSri.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        BigDecimal $porcentaje = this.getPorcentaje();
        result = result * 59 + ($porcentaje == null ? 43 : ((Object)$porcentaje).hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        LocalDateTime $fechaModificacion = this.getFechaModificacion();
        result = result * 59 + ($fechaModificacion == null ? 43 : ((Object)$fechaModificacion).hashCode());
        TTipoTarifaImpuesto $tipoTarifaImpuesto = this.getTipoTarifaImpuesto();
        result = result * 59 + ($tipoTarifaImpuesto == null ? 43 : $tipoTarifaImpuesto.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TTarifaIva(id=" + this.getId() + ", codigoSri=" + this.getCodigoSri() + ", descripcion=" + this.getDescripcion() + ", porcentaje=" + this.getPorcentaje() + ", esCategoriaEspecial=" + this.getEsCategoriaEspecial() + ", activo=" + this.isActivo() + ", fechaCreacion=" + this.getFechaCreacion() + ", fechaModificacion=" + this.getFechaModificacion() + ", tipoTarifaImpuesto=" + this.getTipoTarifaImpuesto() + ")";
    }

    @Generated
    public TTarifaIva() {
    }

    @Generated
    public TTarifaIva(Long id, String codigoSri, String descripcion, BigDecimal porcentaje, Boolean esCategoriaEspecial, boolean activo, LocalDateTime fechaCreacion, LocalDateTime fechaModificacion, TTipoTarifaImpuesto tipoTarifaImpuesto) {
        this.id = id;
        this.codigoSri = codigoSri;
        this.descripcion = descripcion;
        this.porcentaje = porcentaje;
        this.esCategoriaEspecial = esCategoriaEspecial;
        this.activo = activo;
        this.fechaCreacion = fechaCreacion;
        this.fechaModificacion = fechaModificacion;
        this.tipoTarifaImpuesto = tipoTarifaImpuesto;
    }
}

