/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.entity;

import com.contfiables.api.converter.JsonNodeConverter;
import com.contfiables.api.enums.EstadoComprobanteEnum;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.ColumnTransformer;

@Entity
@Table(name="t_factura_historico")
public class TFacturaHistorico {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="fecha_emision", nullable=false)
    private String fechaEmision;
    @Column(name="clave_acceso", nullable=false)
    private String claveAcceso;
    @Column(name="codigo_empresa", nullable=false)
    private String codigoEmpresa;
    @Column(name="ambiente")
    private String ambiente;
    @Column(name="estado")
    private String estado;
    @Column(name="factura", nullable=false, columnDefinition="jsonb")
    @Convert(converter=JsonNodeConverter.class)
    @ColumnTransformer(write="?::jsonb")
    private JsonNode factura;
    @Column(name="fecha_creacion")
    private LocalDateTime fechaCreacion;
    @Column(name="fecha_ultimo_intento")
    private LocalDateTime fechaUltimoIntento;
    @Column(name="fecha_autorizacion")
    private LocalDateTime fechaAutorizacion;
    @Column(name="mensaje_error")
    private String mensajeError;
    @Column(nullable=false, columnDefinition="integer default 0")
    private int reintentos;
    @Column(name="fecha_envio_correo")
    private LocalDateTime fechaEnvioCorreo;
    @Column(name="intentos_envio_correo", columnDefinition="integer default 0")
    private int intentosEnvioCorreo;
    @Column(name="descripcion_envio_correo", length=300)
    private String descripcionEnvioCorreo;
    @Column(name="num_factura", length=60)
    private String numFactura;
    @Column(name="email_adquiriente", length=100)
    private String emailAdquiriente;

    public static TFacturaHistorico inicarProceso(String fechaEmision, String numFactura, String codigoEmpresa, String claveAcceso, JsonNode factura, String emailAdquiriente) {
        TFacturaHistorico tFacturaHistorico = new TFacturaHistorico();
        tFacturaHistorico.setFechaEmision(fechaEmision);
        tFacturaHistorico.setCodigoEmpresa(codigoEmpresa);
        tFacturaHistorico.setNumFactura(numFactura);
        tFacturaHistorico.setClaveAcceso(claveAcceso);
        tFacturaHistorico.setFactura(factura);
        tFacturaHistorico.setEmailAdquiriente(emailAdquiriente);
        tFacturaHistorico.setFechaCreacion(LocalDateTime.now());
        tFacturaHistorico.setReintentos(0);
        tFacturaHistorico.setEstado(EstadoComprobanteEnum.INICIADO.getEstado());
        return tFacturaHistorico;
    }

    public void actualizarEstado(String estado, String ambiente, LocalDateTime fechaAutorizacion, String mensajeError) {
        this.estado = estado;
        this.ambiente = ambiente;
        this.fechaAutorizacion = fechaAutorizacion;
        this.mensajeError = mensajeError;
        this.fechaUltimoIntento = LocalDateTime.now();
    }

    public void incrementarReintentos() {
        ++this.reintentos;
        this.fechaUltimoIntento = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getFechaEmision() {
        return this.fechaEmision;
    }

    @Generated
    public String getClaveAcceso() {
        return this.claveAcceso;
    }

    @Generated
    public String getCodigoEmpresa() {
        return this.codigoEmpresa;
    }

    @Generated
    public String getAmbiente() {
        return this.ambiente;
    }

    @Generated
    public String getEstado() {
        return this.estado;
    }

    @Generated
    public JsonNode getFactura() {
        return this.factura;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public LocalDateTime getFechaUltimoIntento() {
        return this.fechaUltimoIntento;
    }

    @Generated
    public LocalDateTime getFechaAutorizacion() {
        return this.fechaAutorizacion;
    }

    @Generated
    public String getMensajeError() {
        return this.mensajeError;
    }

    @Generated
    public int getReintentos() {
        return this.reintentos;
    }

    @Generated
    public LocalDateTime getFechaEnvioCorreo() {
        return this.fechaEnvioCorreo;
    }

    @Generated
    public int getIntentosEnvioCorreo() {
        return this.intentosEnvioCorreo;
    }

    @Generated
    public String getDescripcionEnvioCorreo() {
        return this.descripcionEnvioCorreo;
    }

    @Generated
    public String getNumFactura() {
        return this.numFactura;
    }

    @Generated
    public String getEmailAdquiriente() {
        return this.emailAdquiriente;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setFechaEmision(String fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    @Generated
    public void setClaveAcceso(String claveAcceso) {
        this.claveAcceso = claveAcceso;
    }

    @Generated
    public void setCodigoEmpresa(String codigoEmpresa) {
        this.codigoEmpresa = codigoEmpresa;
    }

    @Generated
    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    @Generated
    public void setEstado(String estado) {
        this.estado = estado;
    }

    @Generated
    public void setFactura(JsonNode factura) {
        this.factura = factura;
    }

    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @Generated
    public void setFechaUltimoIntento(LocalDateTime fechaUltimoIntento) {
        this.fechaUltimoIntento = fechaUltimoIntento;
    }

    @Generated
    public void setFechaAutorizacion(LocalDateTime fechaAutorizacion) {
        this.fechaAutorizacion = fechaAutorizacion;
    }

    @Generated
    public void setMensajeError(String mensajeError) {
        this.mensajeError = mensajeError;
    }

    @Generated
    public void setReintentos(int reintentos) {
        this.reintentos = reintentos;
    }

    @Generated
    public void setFechaEnvioCorreo(LocalDateTime fechaEnvioCorreo) {
        this.fechaEnvioCorreo = fechaEnvioCorreo;
    }

    @Generated
    public void setIntentosEnvioCorreo(int intentosEnvioCorreo) {
        this.intentosEnvioCorreo = intentosEnvioCorreo;
    }

    @Generated
    public void setDescripcionEnvioCorreo(String descripcionEnvioCorreo) {
        this.descripcionEnvioCorreo = descripcionEnvioCorreo;
    }

    @Generated
    public void setNumFactura(String numFactura) {
        this.numFactura = numFactura;
    }

    @Generated
    public void setEmailAdquiriente(String emailAdquiriente) {
        this.emailAdquiriente = emailAdquiriente;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TFacturaHistorico)) {
            return false;
        }
        TFacturaHistorico other = (TFacturaHistorico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getReintentos() != other.getReintentos()) {
            return false;
        }
        if (this.getIntentosEnvioCorreo() != other.getIntentosEnvioCorreo()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$fechaEmision = this.getFechaEmision();
        String other$fechaEmision = other.getFechaEmision();
        if (this$fechaEmision == null ? other$fechaEmision != null : !this$fechaEmision.equals(other$fechaEmision)) {
            return false;
        }
        String this$claveAcceso = this.getClaveAcceso();
        String other$claveAcceso = other.getClaveAcceso();
        if (this$claveAcceso == null ? other$claveAcceso != null : !this$claveAcceso.equals(other$claveAcceso)) {
            return false;
        }
        String this$codigoEmpresa = this.getCodigoEmpresa();
        String other$codigoEmpresa = other.getCodigoEmpresa();
        if (this$codigoEmpresa == null ? other$codigoEmpresa != null : !this$codigoEmpresa.equals(other$codigoEmpresa)) {
            return false;
        }
        String this$ambiente = this.getAmbiente();
        String other$ambiente = other.getAmbiente();
        if (this$ambiente == null ? other$ambiente != null : !this$ambiente.equals(other$ambiente)) {
            return false;
        }
        String this$estado = this.getEstado();
        String other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        JsonNode this$factura = this.getFactura();
        JsonNode other$factura = other.getFactura();
        if (this$factura == null ? other$factura != null : !this$factura.equals(other$factura)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        LocalDateTime this$fechaUltimoIntento = this.getFechaUltimoIntento();
        LocalDateTime other$fechaUltimoIntento = other.getFechaUltimoIntento();
        if (this$fechaUltimoIntento == null ? other$fechaUltimoIntento != null : !((Object)this$fechaUltimoIntento).equals(other$fechaUltimoIntento)) {
            return false;
        }
        LocalDateTime this$fechaAutorizacion = this.getFechaAutorizacion();
        LocalDateTime other$fechaAutorizacion = other.getFechaAutorizacion();
        if (this$fechaAutorizacion == null ? other$fechaAutorizacion != null : !((Object)this$fechaAutorizacion).equals(other$fechaAutorizacion)) {
            return false;
        }
        String this$mensajeError = this.getMensajeError();
        String other$mensajeError = other.getMensajeError();
        if (this$mensajeError == null ? other$mensajeError != null : !this$mensajeError.equals(other$mensajeError)) {
            return false;
        }
        LocalDateTime this$fechaEnvioCorreo = this.getFechaEnvioCorreo();
        LocalDateTime other$fechaEnvioCorreo = other.getFechaEnvioCorreo();
        if (this$fechaEnvioCorreo == null ? other$fechaEnvioCorreo != null : !((Object)this$fechaEnvioCorreo).equals(other$fechaEnvioCorreo)) {
            return false;
        }
        String this$descripcionEnvioCorreo = this.getDescripcionEnvioCorreo();
        String other$descripcionEnvioCorreo = other.getDescripcionEnvioCorreo();
        if (this$descripcionEnvioCorreo == null ? other$descripcionEnvioCorreo != null : !this$descripcionEnvioCorreo.equals(other$descripcionEnvioCorreo)) {
            return false;
        }
        String this$numFactura = this.getNumFactura();
        String other$numFactura = other.getNumFactura();
        if (this$numFactura == null ? other$numFactura != null : !this$numFactura.equals(other$numFactura)) {
            return false;
        }
        String this$emailAdquiriente = this.getEmailAdquiriente();
        String other$emailAdquiriente = other.getEmailAdquiriente();
        return !(this$emailAdquiriente == null ? other$emailAdquiriente != null : !this$emailAdquiriente.equals(other$emailAdquiriente));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TFacturaHistorico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReintentos();
        result = result * 59 + this.getIntentosEnvioCorreo();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $fechaEmision = this.getFechaEmision();
        result = result * 59 + ($fechaEmision == null ? 43 : $fechaEmision.hashCode());
        String $claveAcceso = this.getClaveAcceso();
        result = result * 59 + ($claveAcceso == null ? 43 : $claveAcceso.hashCode());
        String $codigoEmpresa = this.getCodigoEmpresa();
        result = result * 59 + ($codigoEmpresa == null ? 43 : $codigoEmpresa.hashCode());
        String $ambiente = this.getAmbiente();
        result = result * 59 + ($ambiente == null ? 43 : $ambiente.hashCode());
        String $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        JsonNode $factura = this.getFactura();
        result = result * 59 + ($factura == null ? 43 : $factura.hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        LocalDateTime $fechaUltimoIntento = this.getFechaUltimoIntento();
        result = result * 59 + ($fechaUltimoIntento == null ? 43 : ((Object)$fechaUltimoIntento).hashCode());
        LocalDateTime $fechaAutorizacion = this.getFechaAutorizacion();
        result = result * 59 + ($fechaAutorizacion == null ? 43 : ((Object)$fechaAutorizacion).hashCode());
        String $mensajeError = this.getMensajeError();
        result = result * 59 + ($mensajeError == null ? 43 : $mensajeError.hashCode());
        LocalDateTime $fechaEnvioCorreo = this.getFechaEnvioCorreo();
        result = result * 59 + ($fechaEnvioCorreo == null ? 43 : ((Object)$fechaEnvioCorreo).hashCode());
        String $descripcionEnvioCorreo = this.getDescripcionEnvioCorreo();
        result = result * 59 + ($descripcionEnvioCorreo == null ? 43 : $descripcionEnvioCorreo.hashCode());
        String $numFactura = this.getNumFactura();
        result = result * 59 + ($numFactura == null ? 43 : $numFactura.hashCode());
        String $emailAdquiriente = this.getEmailAdquiriente();
        result = result * 59 + ($emailAdquiriente == null ? 43 : $emailAdquiriente.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TFacturaHistorico(id=" + this.getId() + ", fechaEmision=" + this.getFechaEmision() + ", claveAcceso=" + this.getClaveAcceso() + ", codigoEmpresa=" + this.getCodigoEmpresa() + ", ambiente=" + this.getAmbiente() + ", estado=" + this.getEstado() + ", factura=" + this.getFactura() + ", fechaCreacion=" + this.getFechaCreacion() + ", fechaUltimoIntento=" + this.getFechaUltimoIntento() + ", fechaAutorizacion=" + this.getFechaAutorizacion() + ", mensajeError=" + this.getMensajeError() + ", reintentos=" + this.getReintentos() + ", fechaEnvioCorreo=" + this.getFechaEnvioCorreo() + ", intentosEnvioCorreo=" + this.getIntentosEnvioCorreo() + ", descripcionEnvioCorreo=" + this.getDescripcionEnvioCorreo() + ", numFactura=" + this.getNumFactura() + ", emailAdquiriente=" + this.getEmailAdquiriente() + ")";
    }

    @Generated
    public TFacturaHistorico() {
    }

    @Generated
    public TFacturaHistorico(Long id, String fechaEmision, String claveAcceso, String codigoEmpresa, String ambiente, String estado, JsonNode factura, LocalDateTime fechaCreacion, LocalDateTime fechaUltimoIntento, LocalDateTime fechaAutorizacion, String mensajeError, int reintentos, LocalDateTime fechaEnvioCorreo, int intentosEnvioCorreo, String descripcionEnvioCorreo, String numFactura, String emailAdquiriente) {
        this.id = id;
        this.fechaEmision = fechaEmision;
        this.claveAcceso = claveAcceso;
        this.codigoEmpresa = codigoEmpresa;
        this.ambiente = ambiente;
        this.estado = estado;
        this.factura = factura;
        this.fechaCreacion = fechaCreacion;
        this.fechaUltimoIntento = fechaUltimoIntento;
        this.fechaAutorizacion = fechaAutorizacion;
        this.mensajeError = mensajeError;
        this.reintentos = reintentos;
        this.fechaEnvioCorreo = fechaEnvioCorreo;
        this.intentosEnvioCorreo = intentosEnvioCorreo;
        this.descripcionEnvioCorreo = descripcionEnvioCorreo;
        this.numFactura = numFactura;
        this.emailAdquiriente = emailAdquiriente;
    }
}

