/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.entity;

import com.contfiables.api.entity.TEmpresa;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;

@Entity
@Table(name="t_establecimiento")
public class TEstablecimiento {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="establecimiento", length=3)
    private String establecimiento;
    @Column(name="descripcion", length=150)
    private String descripcion;
    @Column(name="direccion", length=255)
    private String direccion;
    @ManyToOne
    @JoinColumn(name="id_empresa")
    private TEmpresa empresa;
    @Column(name="activo")
    private boolean activo;
    @Column(name="fecha_creacion", nullable=false)
    private LocalDateTime fechaCreacion;
    @Column(name="fecha_modificacion", nullable=false)
    private LocalDateTime fechaModificacion;

    @PrePersist
    protected void onCreate() {
        LocalDateTime nowEcuador;
        this.fechaCreacion = nowEcuador = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
        this.fechaModificacion = nowEcuador;
    }

    @PreUpdate
    protected void onUpdate() {
        this.fechaModificacion = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEstablecimiento() {
        return this.establecimiento;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public String getDireccion() {
        return this.direccion;
    }

    @Generated
    public TEmpresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public boolean isActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public LocalDateTime getFechaModificacion() {
        return this.fechaModificacion;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEstablecimiento(String establecimiento) {
        this.establecimiento = establecimiento;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    @Generated
    public void setEmpresa(TEmpresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setActivo(boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @Generated
    public void setFechaModificacion(LocalDateTime fechaModificacion) {
        this.fechaModificacion = fechaModificacion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TEstablecimiento)) {
            return false;
        }
        TEstablecimiento other = (TEstablecimiento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isActivo() != other.isActivo()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$establecimiento = this.getEstablecimiento();
        String other$establecimiento = other.getEstablecimiento();
        if (this$establecimiento == null ? other$establecimiento != null : !this$establecimiento.equals(other$establecimiento)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        if (this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion)) {
            return false;
        }
        TEmpresa this$empresa = this.getEmpresa();
        TEmpresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        LocalDateTime this$fechaModificacion = this.getFechaModificacion();
        LocalDateTime other$fechaModificacion = other.getFechaModificacion();
        return !(this$fechaModificacion == null ? other$fechaModificacion != null : !((Object)this$fechaModificacion).equals(other$fechaModificacion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TEstablecimiento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivo() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $establecimiento = this.getEstablecimiento();
        result = result * 59 + ($establecimiento == null ? 43 : $establecimiento.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        TEmpresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        LocalDateTime $fechaModificacion = this.getFechaModificacion();
        result = result * 59 + ($fechaModificacion == null ? 43 : ((Object)$fechaModificacion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TEstablecimiento(id=" + this.getId() + ", establecimiento=" + this.getEstablecimiento() + ", descripcion=" + this.getDescripcion() + ", direccion=" + this.getDireccion() + ", empresa=" + this.getEmpresa() + ", activo=" + this.isActivo() + ", fechaCreacion=" + this.getFechaCreacion() + ", fechaModificacion=" + this.getFechaModificacion() + ")";
    }

    @Generated
    public TEstablecimiento() {
    }

    @Generated
    public TEstablecimiento(Long id, String establecimiento, String descripcion, String direccion, TEmpresa empresa, boolean activo, LocalDateTime fechaCreacion, LocalDateTime fechaModificacion) {
        this.id = id;
        this.establecimiento = establecimiento;
        this.descripcion = descripcion;
        this.direccion = direccion;
        this.empresa = empresa;
        this.activo = activo;
        this.fechaCreacion = fechaCreacion;
        this.fechaModificacion = fechaModificacion;
    }
}

