/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.entity;

import com.contfiables.api.entity.TTipoIdentificacion;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="t_empresa")
public class TEmpresa {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long idEmpresa;
    @Column(name="codigo_empresa", unique=true, nullable=false)
    private String codigoEmpresa;
    @Column(name="ruc", unique=true, nullable=false)
    private String ruc;
    @Column(name="razon_social", nullable=false)
    private String razonSocial;
    @Column(name="nombre_comercial")
    private String nombreComercial;
    @Column(name="direccion_matriz", nullable=false)
    private String direccionMatriz;
    @Column(name="contribuyente_especial")
    private String contribuyenteEspecial;
    @Column(name="tipo_emprendedor")
    private String tipoEmprendedor;
    @Column(name="obligado_contabilidad")
    private Boolean obligadoContabilidad;
    @Column(name="telefono", nullable=false)
    private String telefono;
    @ManyToOne
    @JoinColumn(name="id_tipo_identificacion")
    private TTipoIdentificacion tipoIdentificacion;
    @Column(name="email")
    private String email;
    @Column(name="username")
    private String username;
    @Column(name="archivo_firma")
    private String archivoFirma;
    @Column(name="clave_firma")
    private String claveFirma;
    @Column(name="logo")
    private String logo;
    @Column(name="fecha_creacion", nullable=false)
    private LocalDateTime fechaCreacion;
    @Column(name="fecha_modificacion", nullable=false)
    private LocalDateTime fechaModificacion;

    @PrePersist
    protected void onCreate() {
        LocalDateTime nowEcuador;
        this.fechaCreacion = nowEcuador = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
        this.fechaModificacion = nowEcuador;
        if (this.codigoEmpresa == null || this.codigoEmpresa.isBlank()) {
            this.codigoEmpresa = UUID.randomUUID().toString();
        }
    }

    @PreUpdate
    protected void onUpdate() {
        this.fechaModificacion = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
    }

    @Generated
    public Long getIdEmpresa() {
        return this.idEmpresa;
    }

    @Generated
    public String getCodigoEmpresa() {
        return this.codigoEmpresa;
    }

    @Generated
    public String getRuc() {
        return this.ruc;
    }

    @Generated
    public String getRazonSocial() {
        return this.razonSocial;
    }

    @Generated
    public String getNombreComercial() {
        return this.nombreComercial;
    }

    @Generated
    public String getDireccionMatriz() {
        return this.direccionMatriz;
    }

    @Generated
    public String getContribuyenteEspecial() {
        return this.contribuyenteEspecial;
    }

    @Generated
    public String getTipoEmprendedor() {
        return this.tipoEmprendedor;
    }

    @Generated
    public Boolean getObligadoContabilidad() {
        return this.obligadoContabilidad;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public TTipoIdentificacion getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getArchivoFirma() {
        return this.archivoFirma;
    }

    @Generated
    public String getClaveFirma() {
        return this.claveFirma;
    }

    @Generated
    public String getLogo() {
        return this.logo;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public LocalDateTime getFechaModificacion() {
        return this.fechaModificacion;
    }

    @Generated
    public void setIdEmpresa(Long idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    @Generated
    public void setCodigoEmpresa(String codigoEmpresa) {
        this.codigoEmpresa = codigoEmpresa;
    }

    @Generated
    public void setRuc(String ruc) {
        this.ruc = ruc;
    }

    @Generated
    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    @Generated
    public void setNombreComercial(String nombreComercial) {
        this.nombreComercial = nombreComercial;
    }

    @Generated
    public void setDireccionMatriz(String direccionMatriz) {
        this.direccionMatriz = direccionMatriz;
    }

    @Generated
    public void setContribuyenteEspecial(String contribuyenteEspecial) {
        this.contribuyenteEspecial = contribuyenteEspecial;
    }

    @Generated
    public void setTipoEmprendedor(String tipoEmprendedor) {
        this.tipoEmprendedor = tipoEmprendedor;
    }

    @Generated
    public void setObligadoContabilidad(Boolean obligadoContabilidad) {
        this.obligadoContabilidad = obligadoContabilidad;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setTipoIdentificacion(TTipoIdentificacion tipoIdentificacion) {
        this.tipoIdentificacion = tipoIdentificacion;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setArchivoFirma(String archivoFirma) {
        this.archivoFirma = archivoFirma;
    }

    @Generated
    public void setClaveFirma(String claveFirma) {
        this.claveFirma = claveFirma;
    }

    @Generated
    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @Generated
    public void setFechaModificacion(LocalDateTime fechaModificacion) {
        this.fechaModificacion = fechaModificacion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TEmpresa)) {
            return false;
        }
        TEmpresa other = (TEmpresa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idEmpresa = this.getIdEmpresa();
        Long other$idEmpresa = other.getIdEmpresa();
        if (this$idEmpresa == null ? other$idEmpresa != null : !((Object)this$idEmpresa).equals(other$idEmpresa)) {
            return false;
        }
        Boolean this$obligadoContabilidad = this.getObligadoContabilidad();
        Boolean other$obligadoContabilidad = other.getObligadoContabilidad();
        if (this$obligadoContabilidad == null ? other$obligadoContabilidad != null : !((Object)this$obligadoContabilidad).equals(other$obligadoContabilidad)) {
            return false;
        }
        String this$codigoEmpresa = this.getCodigoEmpresa();
        String other$codigoEmpresa = other.getCodigoEmpresa();
        if (this$codigoEmpresa == null ? other$codigoEmpresa != null : !this$codigoEmpresa.equals(other$codigoEmpresa)) {
            return false;
        }
        String this$ruc = this.getRuc();
        String other$ruc = other.getRuc();
        if (this$ruc == null ? other$ruc != null : !this$ruc.equals(other$ruc)) {
            return false;
        }
        String this$razonSocial = this.getRazonSocial();
        String other$razonSocial = other.getRazonSocial();
        if (this$razonSocial == null ? other$razonSocial != null : !this$razonSocial.equals(other$razonSocial)) {
            return false;
        }
        String this$nombreComercial = this.getNombreComercial();
        String other$nombreComercial = other.getNombreComercial();
        if (this$nombreComercial == null ? other$nombreComercial != null : !this$nombreComercial.equals(other$nombreComercial)) {
            return false;
        }
        String this$direccionMatriz = this.getDireccionMatriz();
        String other$direccionMatriz = other.getDireccionMatriz();
        if (this$direccionMatriz == null ? other$direccionMatriz != null : !this$direccionMatriz.equals(other$direccionMatriz)) {
            return false;
        }
        String this$contribuyenteEspecial = this.getContribuyenteEspecial();
        String other$contribuyenteEspecial = other.getContribuyenteEspecial();
        if (this$contribuyenteEspecial == null ? other$contribuyenteEspecial != null : !this$contribuyenteEspecial.equals(other$contribuyenteEspecial)) {
            return false;
        }
        String this$tipoEmprendedor = this.getTipoEmprendedor();
        String other$tipoEmprendedor = other.getTipoEmprendedor();
        if (this$tipoEmprendedor == null ? other$tipoEmprendedor != null : !this$tipoEmprendedor.equals(other$tipoEmprendedor)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        TTipoIdentificacion this$tipoIdentificacion = this.getTipoIdentificacion();
        TTipoIdentificacion other$tipoIdentificacion = other.getTipoIdentificacion();
        if (this$tipoIdentificacion == null ? other$tipoIdentificacion != null : !this$tipoIdentificacion.equals(other$tipoIdentificacion)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$archivoFirma = this.getArchivoFirma();
        String other$archivoFirma = other.getArchivoFirma();
        if (this$archivoFirma == null ? other$archivoFirma != null : !this$archivoFirma.equals(other$archivoFirma)) {
            return false;
        }
        String this$claveFirma = this.getClaveFirma();
        String other$claveFirma = other.getClaveFirma();
        if (this$claveFirma == null ? other$claveFirma != null : !this$claveFirma.equals(other$claveFirma)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        LocalDateTime this$fechaModificacion = this.getFechaModificacion();
        LocalDateTime other$fechaModificacion = other.getFechaModificacion();
        return !(this$fechaModificacion == null ? other$fechaModificacion != null : !((Object)this$fechaModificacion).equals(other$fechaModificacion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TEmpresa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEmpresa = this.getIdEmpresa();
        result = result * 59 + ($idEmpresa == null ? 43 : ((Object)$idEmpresa).hashCode());
        Boolean $obligadoContabilidad = this.getObligadoContabilidad();
        result = result * 59 + ($obligadoContabilidad == null ? 43 : ((Object)$obligadoContabilidad).hashCode());
        String $codigoEmpresa = this.getCodigoEmpresa();
        result = result * 59 + ($codigoEmpresa == null ? 43 : $codigoEmpresa.hashCode());
        String $ruc = this.getRuc();
        result = result * 59 + ($ruc == null ? 43 : $ruc.hashCode());
        String $razonSocial = this.getRazonSocial();
        result = result * 59 + ($razonSocial == null ? 43 : $razonSocial.hashCode());
        String $nombreComercial = this.getNombreComercial();
        result = result * 59 + ($nombreComercial == null ? 43 : $nombreComercial.hashCode());
        String $direccionMatriz = this.getDireccionMatriz();
        result = result * 59 + ($direccionMatriz == null ? 43 : $direccionMatriz.hashCode());
        String $contribuyenteEspecial = this.getContribuyenteEspecial();
        result = result * 59 + ($contribuyenteEspecial == null ? 43 : $contribuyenteEspecial.hashCode());
        String $tipoEmprendedor = this.getTipoEmprendedor();
        result = result * 59 + ($tipoEmprendedor == null ? 43 : $tipoEmprendedor.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        TTipoIdentificacion $tipoIdentificacion = this.getTipoIdentificacion();
        result = result * 59 + ($tipoIdentificacion == null ? 43 : $tipoIdentificacion.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $archivoFirma = this.getArchivoFirma();
        result = result * 59 + ($archivoFirma == null ? 43 : $archivoFirma.hashCode());
        String $claveFirma = this.getClaveFirma();
        result = result * 59 + ($claveFirma == null ? 43 : $claveFirma.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        LocalDateTime $fechaModificacion = this.getFechaModificacion();
        result = result * 59 + ($fechaModificacion == null ? 43 : ((Object)$fechaModificacion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TEmpresa(idEmpresa=" + this.getIdEmpresa() + ", codigoEmpresa=" + this.getCodigoEmpresa() + ", ruc=" + this.getRuc() + ", razonSocial=" + this.getRazonSocial() + ", nombreComercial=" + this.getNombreComercial() + ", direccionMatriz=" + this.getDireccionMatriz() + ", contribuyenteEspecial=" + this.getContribuyenteEspecial() + ", tipoEmprendedor=" + this.getTipoEmprendedor() + ", obligadoContabilidad=" + this.getObligadoContabilidad() + ", telefono=" + this.getTelefono() + ", tipoIdentificacion=" + this.getTipoIdentificacion() + ", email=" + this.getEmail() + ", username=" + this.getUsername() + ", archivoFirma=" + this.getArchivoFirma() + ", claveFirma=" + this.getClaveFirma() + ", logo=" + this.getLogo() + ", fechaCreacion=" + this.getFechaCreacion() + ", fechaModificacion=" + this.getFechaModificacion() + ")";
    }

    @Generated
    public TEmpresa() {
    }

    @Generated
    public TEmpresa(Long idEmpresa, String codigoEmpresa, String ruc, String razonSocial, String nombreComercial, String direccionMatriz, String contribuyenteEspecial, String tipoEmprendedor, Boolean obligadoContabilidad, String telefono, TTipoIdentificacion tipoIdentificacion, String email, String username, String archivoFirma, String claveFirma, String logo, LocalDateTime fechaCreacion, LocalDateTime fechaModificacion) {
        this.idEmpresa = idEmpresa;
        this.codigoEmpresa = codigoEmpresa;
        this.ruc = ruc;
        this.razonSocial = razonSocial;
        this.nombreComercial = nombreComercial;
        this.direccionMatriz = direccionMatriz;
        this.contribuyenteEspecial = contribuyenteEspecial;
        this.tipoEmprendedor = tipoEmprendedor;
        this.obligadoContabilidad = obligadoContabilidad;
        this.telefono = telefono;
        this.tipoIdentificacion = tipoIdentificacion;
        this.email = email;
        this.username = username;
        this.archivoFirma = archivoFirma;
        this.claveFirma = claveFirma;
        this.logo = logo;
        this.fechaCreacion = fechaCreacion;
        this.fechaModificacion = fechaModificacion;
    }
}

