/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.dao;

import com.contfiables.api.DTO.reenvios.InfoFacuraReenvioDTO;
import com.contfiables.api.entity.TFacturaHistorico;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface TFacturaHistoricoDAO
extends JpaRepository<TFacturaHistorico, Long> {
    @Modifying
    @Transactional
    @Query(value="UPDATE TFacturaHistorico t SET t.reintentos = t.reintentos + 1, t.estado = :estado, t.ambiente = :ambiente, t.fechaUltimoIntento  = :fechaUltimoIntento, t.fechaAutorizacion = :fechaAutorizacion WHERE t.claveAcceso = :claveAcceso AND t.codigoEmpresa = :codigoEmpresa")
    public Integer updateFacturaDetails(String var1, String var2, LocalDateTime var3, LocalDateTime var4, String var5, String var6);

    @Modifying
    @Transactional
    @Query(value="UPDATE TFacturaHistorico t SET t.reintentos = t.reintentos + 1, t.estado = :estado, t.ambiente = :ambiente, t.fechaUltimoIntento  = :fechaUltimoIntento, t.mensajeError = :mensajeError  WHERE t.claveAcceso = :claveAcceso AND t.codigoEmpresa = :codigoEmpresa")
    public Integer updateFacturaDetailsError(String var1, String var2, LocalDateTime var3, String var4, String var5, String var6);

    @Query(value="SELECT t.factura FROM TFacturaHistorico t WHERE t.claveAcceso = :claveAcceso AND t.estado <> :estado")
    public JsonNode findByClaveAccesoAndCodigoEstadoNotEquals(String var1, String var2);

    @Query(value="SELECT t.emailAdquiriente FROM TFacturaHistorico t WHERE t.claveAcceso = :claveAcceso AND t.estado = :estado")
    public String findEmailByClaveAccesoAndCodigoEstado(String var1, String var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE TFacturaHistorico t SET t.intentosEnvioCorreo = intentosEnvioCorreo + 1,  t.fechaEnvioCorreo = :fechaEnvioCorreo, t.descripcionEnvioCorreo = :descripcionEnvioCorreo WHERE t.claveAcceso = :claveAcceso")
    public Integer updateEstadoEnviadoFactura(LocalDateTime var1, String var2, String var3);

    @Query(value="select tf.clave_acceso, tf.codigo_empresa from t_factura_historico tf where tf.estado <> :estado and tf.reintentos <= :maxIntentos order by tf.fecha_creacion asc limit :limitList", nativeQuery=true)
    public List<InfoFacuraReenvioDTO> getLoteClavesAccesoParaReintentarDiffByStadoYLimit(String var1, int var2, int var3);

    @Query(value="select tf.clave_acceso from t_factura_historico tf where tf.fecha_envio_correo is null AND tf.estado = :estado AND tf.intentos_envio_correo <= :maxIntentos order by tf.fecha_autorizacion asc limit :limitList", nativeQuery=true)
    public List<String> getLoteClavesAccesoParaNotificarByStadoYLimit(String var1, int var2, int var3);
}

