/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

@Converter(autoApply=true)
public class JsonNodeConverter
implements AttributeConverter<JsonNode, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(JsonNode jsonNode) {
        try {
            return jsonNode != null ? objectMapper.writeValueAsString((Object)jsonNode) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error al convertir JsonNode a String", e);
        }
    }

    public JsonNode convertToEntityAttribute(String dbData) {
        try {
            return dbData != null ? objectMapper.readTree(dbData) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error al convertir String a JsonNode", e);
        }
    }
}

