/*
 * Decompiled with CFR 0.152.
 */
package com.contfiables.api.config;

import com.contfiables.api.exceptions.CustomException;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Generated;
import org.springframework.http.HttpStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiResponse<T> {
    private int statusCode;
    private boolean success;
    private String message;
    private T data;
    private T errors;

    public ApiResponse(int statusCode, boolean success, String message, T data, T errors) {
        this.statusCode = statusCode;
        this.success = success;
        this.message = message;
        this.data = data;
        this.errors = errors;
    }

    public static <T> ApiResponse<T> validateFields(int statusCode, String message, T errors) {
        return new ApiResponse(statusCode, false, message, null, errors);
    }

    public static <T> ApiResponse<T> ok(T data, boolean success) {
        return new ApiResponse(200, true, "Operaci\u00f3n exitosa", data, null);
    }

    public static <T> ApiResponse<T> error(int statusCode, String message) {
        return new ApiResponse(statusCode, false, message, null, null);
    }

    public static <T> ApiResponse<T> customException(String message, HttpStatus status) {
        throw new CustomException(message, status);
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public T getData() {
        return (T)this.data;
    }

    @Generated
    public T getErrors() {
        return (T)this.errors;
    }

    @Generated
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setErrors(T errors) {
        this.errors = errors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Object this$errors = this.getErrors();
        Object other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !this$errors.equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Object $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiResponse(statusCode=" + this.getStatusCode() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", errors=" + this.getErrors() + ")";
    }
}

