/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.proveedor;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.proveedor.TProveedor;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoIdentificacionDAO;
import ec.tws2.back.contfiables.repositories.proveedor.TProveedorDAO;
import ec.tws2.back.contfiables.services.ProveedorService;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ProveedorServiceImpl
implements ProveedorService {
    Logger log = Logger.getLogger(ProveedorServiceImpl.class.getName());
    @Autowired
    private TProveedorDAO proveedorDAO;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TTipoIdentificacionDAO tipoIdentDAO;

    public ResponseEntity<RespSimple> obtenerListaProveedoresActivos(Long idCliente) {
        return Transaccion.OK((String)"Lista proveedores obtenida", (Object)this.proveedorDAO.findByClienteAndActivoOrderByIdProveedorDesc(new TCliente(idCliente), true));
    }

    public ResponseEntity<RespSimple> obtenerListaProveedores(Long idCliente) {
        return Transaccion.OK((String)"Lista proveedores obtenida", (Object)this.proveedorDAO.findByClienteOrderByIdProveedorDesc(new TCliente(idCliente)));
    }

    public ResponseEntity<RespSimple> registrarProveedor(TProveedor proveedor) {
        try {
            TCliente cliente = this.clienteDAO.findById((Object)proveedor.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"Error al identificar el cliente.");
            }
            boolean existe = this.proveedorDAO.existsByClienteAndIdentificacionAndRazonSocial(cliente, proveedor.getIdentificacion(), proveedor.getRazonSocial());
            if (existe) {
                return Transaccion.EXISTS((String)"Ya existe un registro con esos datos.");
            }
            this.proveedorDAO.save((Object)proveedor);
            return Transaccion.CREATED((String)"Proveedor registrado");
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al registrar el proveedor");
        }
    }

    public ResponseEntity<RespSimple> actualizarProveedor(TProveedor proveedor) {
        try {
            this.log.info("ACTUALIZAR PROVEEDOR");
            TCliente cliente = this.clienteDAO.findById((Object)proveedor.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"Error al identificar el cliente.");
            }
            TProveedor existeProveedor = this.proveedorDAO.findByClienteAndIdentificacionAndRazonSocial(cliente, proveedor.getIdentificacion(), proveedor.getRazonSocial());
            if (existeProveedor != null && existeProveedor.getIdProveedor() != proveedor.getIdProveedor()) {
                return Transaccion.EXISTS((String)"Ya existe un registro con esos datos.");
            }
            TProveedor proveedorDB = this.proveedorDAO.findById((Object)proveedor.getIdProveedor()).orElse(null);
            if (proveedorDB == null) {
                return Transaccion.NOTFOUNT((String)"No existe un proveedor con esos datos.");
            }
            proveedorDB.setActivo(proveedor.getActivo());
            proveedorDB.setCategoriaProveedor(proveedor.getCategoriaProveedor());
            proveedorDB.setCiudad(proveedor.getCiudad());
            proveedorDB.setCodigo(proveedor.getCodigo());
            proveedorDB.setDireccion(proveedor.getDireccion());
            proveedorDB.setNombre(proveedor.getNombre());
            proveedorDB.setRazonSocial(proveedor.getRazonSocial());
            proveedorDB.setTelefono(proveedor.getTelefono());
            proveedorDB.setEmail(proveedor.getEmail());
            proveedorDB.setTipoIdentificacion(proveedor.getTipoIdentificacion());
            this.proveedorDAO.save((Object)proveedorDB);
            return Transaccion.CREATED((String)"Proveedor actualizado");
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al actualizar el proveedor");
        }
    }

    public ResponseEntity<RespSimple> obtenerProveedorById(Long idCliente, Long idProveedor) {
        try {
            TProveedor proveedor = this.proveedorDAO.findByClienteAndIdProveedor(new TCliente(idCliente), idProveedor);
            if (proveedor == null) {
                return Transaccion.NOTFOUNT((String)"No existe un proveedor con esos datos");
            }
            return Transaccion.OK((String)"Proveedor obtenido", (Object)proveedor);
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener el proveedor");
        }
    }

    public ResponseEntity<RespSimple> obtenerTiposIdentificacion() {
        return Transaccion.OK((String)"Lista de identificaciones obtenida", (Object)this.tipoIdentDAO.obtenerTiposIdentificacionForProveedor());
    }
}

