/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.proveedor;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.proveedor.TCategoriaProveedor;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.proveedor.TCategoriaProveedorDAO;
import ec.tws2.back.contfiables.services.CategoriaProveedorService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CategoriaProveedorServiceImpl
implements CategoriaProveedorService {
    private static final Logger log = Logger.getLogger(CategoriaProveedorServiceImpl.class.getName());
    @Autowired
    private TCategoriaProveedorDAO catProveedoresDAO;
    @Autowired
    private TClienteDAO clienteDAO;

    public ResponseEntity<RespSimple> obtenerListaCategoriaProveedoresActivos(Long idCliente) {
        TCliente cliente = new TCliente();
        RespSimple response = new RespSimple();
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)idCliente);
            if (!existeCliente) {
                response.setData(null);
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Cliente no identificado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            cliente.setIdCliente(idCliente);
            List lista = this.catProveedoresDAO.findByClienteAndActivoOrderByIdCategoriaProveedorDesc(cliente, true);
            response.setData((Object)lista);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Lista de categor\u00edias obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de categor\u00edas proveedores");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaCategoriaProveedores(Long idCliente) {
        TCliente cliente = new TCliente();
        RespSimple response = new RespSimple();
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)idCliente);
            if (!existeCliente) {
                response.setData(null);
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Cliente no identificado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            cliente.setIdCliente(idCliente);
            List lista = this.catProveedoresDAO.findByClienteOrderByIdCategoriaProveedorDesc(cliente);
            response.setData((Object)lista);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Lista de categor\u00edias obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de categor\u00edas proveedores");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> registrarCategoriaProveedor(TCategoriaProveedor categoriaProveedor) {
        RespSimple response = new RespSimple();
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)categoriaProveedor.getCliente().getIdCliente());
            if (!existeCliente) {
                response.setData(null);
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Cliente no identificado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            boolean yaExiste = this.catProveedoresDAO.existsByClienteAndAbreviatura(categoriaProveedor.getCliente(), categoriaProveedor.getAbreviatura());
            if (yaExiste) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Ya existe un registro con esa abreviatura.");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.catProveedoresDAO.save((Object)categoriaProveedor);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Categor\u00eda proveedor registrado");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar la categor\u00eda proveedor");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> actualizarCategoriaProveedor(TCategoriaProveedor categoriaProveedor) {
        RespSimple response = new RespSimple();
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)categoriaProveedor.getCliente().getIdCliente());
            if (!existeCliente) {
                response.setData(null);
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Cliente no identificado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TCategoriaProveedor categoriaDB = this.catProveedoresDAO.findById((Object)categoriaProveedor.getIdCategoriaProveedor()).orElse(null);
            if (categoriaDB == null) {
                response.setData(null);
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("No existe una categor\u00eda con ese registro.");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TCategoriaProveedor yaExiste = this.catProveedoresDAO.findByClienteAndAbreviatura(categoriaProveedor.getCliente(), categoriaProveedor.getAbreviatura());
            if (yaExiste != null && yaExiste.getIdCategoriaProveedor() != categoriaProveedor.getIdCategoriaProveedor()) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Ya existe un registro con esa abreviatura.");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            categoriaDB.setAbreviatura(categoriaProveedor.getAbreviatura());
            categoriaDB.setActivo(categoriaProveedor.isActivo());
            categoriaDB.setDescripcion(categoriaProveedor.getDescripcion());
            this.catProveedoresDAO.save((Object)categoriaDB);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Categor\u00eda proveedor actualizado");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al actualizar la categor\u00eda proveedor");
            log.log(Level.SEVERE, "error: ", e);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> obtenerCategoriaProveedorById(Long idCliente, Long idCategoria) {
        RespSimple response = new RespSimple();
        TCliente cliente = new TCliente();
        cliente.setIdCliente(idCliente);
        TCategoriaProveedor categoria = this.catProveedoresDAO.findByClienteAndIdCategoriaProveedor(cliente, idCategoria);
        if (categoria == null) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error, no se encontr\u00f3 la categor\u00eda proveedor solicitada");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        response.setData((Object)categoria);
        response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
        response.setMensaje("Categor\u00eda obtenida");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }
}

