/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.inventario.TUnidadMedida;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TUnidadMedidaDAO;
import ec.tws2.back.contfiables.services.UnidadMedidaService;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UnidadMedidaServiceImpl
implements UnidadMedidaService {
    private Logger log = Logger.getLogger(UnidadMedidaServiceImpl.class.getName());
    @Autowired
    TUnidadMedidaDAO unidadMedidaDao;
    @Autowired
    private TClienteDAO clienteDAO;

    public ResponseEntity<RespSimple> guardarUnidadMedida(TUnidadMedida unidadMedida) {
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)unidadMedida.getCliente().getIdCliente());
            if (!existeCliente) {
                RespSimple response = new RespSimple("Info", "Cliente no identificado", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            unidadMedida.setIdUnidadMedida(null);
            boolean existe = this.unidadMedidaDao.existsByClienteAndAbreviatura(unidadMedida.getCliente(), unidadMedida.getAbreviatura());
            if (existe) {
                RespSimple response = new RespSimple("No guardado", "Ya existe un registro con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.unidadMedidaDao.save((Object)unidadMedida);
            RespSimple response = new RespSimple("Guardado", "Unidad de medida registrado", ContfiablesEnum.TRANSACCION_OK.getId(), "", null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("No registrado", "Error al guardar la unidad de medida", ContfiablesEnum.TRANSACCION_ERROR.getId(), e.getMessage(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> actualizarUnidadMedida(TUnidadMedida unidadMedida) {
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)unidadMedida.getCliente().getIdCliente());
            if (!existeCliente) {
                RespSimple response = new RespSimple("Info", "Cliente no identificado", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TUnidadMedida unidadBD = this.unidadMedidaDao.findById((Object)unidadMedida.getIdUnidadMedida()).orElse(null);
            if (unidadBD == null) {
                RespSimple response = new RespSimple("No encontrado", "No existe el la unidad de medida solicitada", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TUnidadMedida existe = this.unidadMedidaDao.findByClienteAndAbreviatura(unidadBD.getCliente(), unidadMedida.getAbreviatura());
            if (existe != null && existe.getIdUnidadMedida() != unidadBD.getIdUnidadMedida()) {
                RespSimple response = new RespSimple("No guardado", "Ya existe un registro con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            unidadBD.setAbreviatura(unidadMedida.getAbreviatura());
            unidadBD.setActivo(unidadMedida.getActivo());
            unidadBD.setDescripcion(unidadMedida.getDescripcion());
            this.unidadMedidaDao.save((Object)unidadBD);
            RespSimple response = new RespSimple("Actualizado", "Unidad de medida actualizada", ContfiablesEnum.TRANSACCION_OK.getId(), "", null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("No actualizado", "Unidad de no medida actualizada", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
            this.log.log(Level.SEVERE, "error al actualizar: ", e);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaUnidadMedidaCLiente(Long idCliente, Boolean activo) {
        try {
            RespSimple response = new RespSimple("Info", "Lista obtenida", ContfiablesEnum.TRANSACCION_OK.getId(), "", (Object)this.unidadMedidaDao.getAllUnidadMedidaDescActive(idCliente, activo));
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al obtener la lisata de unidad de medida", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

