/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.domain.TipoProductoCuentaContableModel;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProductoCuentaContable;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoProductoCuentaContableDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoProductoDAO;
import ec.tws2.back.contfiables.services.TipoProductoService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class TipoProductoServiceImpl
implements TipoProductoService {
    @Autowired
    private TTipoProductoDAO tipoProdDAO;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TTipoProductoCuentaContableDAO tipoProdCuentaDAO;
    private Logger log = Logger.getLogger(TipoProductoServiceImpl.class.getName());

    @Transactional
    public ResponseEntity<RespSimple> guardarTipoProducto(TipoProductoCuentaContableModel tipoProductoCuentaContable) {
        try {
            TTipoProducto tipoProducto = tipoProductoCuentaContable.getTipoProducto();
            List listCuentasContTipoProd = tipoProductoCuentaContable.getListCuentasContablesTipoProd();
            tipoProducto.setCodigo(tipoProducto.getCodigo().replace(" ", ""));
            if (tipoProducto.getMovimiento() == null) {
                tipoProducto.setMovimiento(Boolean.valueOf(false));
                listCuentasContTipoProd = null;
            }
            if (tipoProducto.getMovimiento().booleanValue() && listCuentasContTipoProd == null) {
                throw new CustomException("El tipo de producto es de movimiento, seleccionar todos los tipos de cuentas contables requeridos");
            }
            TCliente cliente = this.clienteDAO.findById((Object)tipoProducto.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                RespSimple response = new RespSimple("Info", "Cliente no identificado", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            boolean existe = this.tipoProdDAO.existsByClienteAndCodigo(tipoProducto.getCliente(), tipoProducto.getCodigo());
            if (existe) {
                RespSimple response = new RespSimple("Info", "Ya existe un registro con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            TTipoProducto tipoProductoDB = (TTipoProducto)this.tipoProdDAO.save((Object)tipoProducto);
            RespSimple response = new RespSimple("Info", "Tipo de producto creado", ContfiablesEnum.TRANSACCION_OK.getId(), null);
            try {
                if (tipoProductoDB.getMovimiento().booleanValue() && listCuentasContTipoProd != null) {
                    for (TTipoProductoCuentaContable tc : listCuentasContTipoProd) {
                        tc.setTipoProducto(tipoProductoDB);
                        if (tc.getReferencia() == null || tc.getReferencia().isEmpty()) {
                            throw new CustomException("El tipo de referencia no fu\u00e9 asignado");
                        }
                        if (tc.getTipoProducto() != null && tc.getCuentaContable() != null) {
                            this.tipoProdCuentaDAO.save((Object)tc);
                            continue;
                        }
                        throw new CustomException("Error el no se pudo relacionar el tipo de producto con la cuenta contable");
                    }
                }
            }
            catch (Exception e) {
                this.log.severe("Error al registrar el tipo de producto con las cuentas contables");
                throw new CustomException("Error al registrar las cuentas contables con el tipo de producto.");
            }
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            this.log.log(Level.SEVERE, "error: " + e.getMessage());
            RespSimple response = new RespSimple("Error", e.getMessage(), ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error: " + e.getMessage());
            RespSimple response = new RespSimple("Info", "Error al registar el tipo de producto", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
    }

    public ResponseEntity<RespSimple> actualizarTipoProducto(TTipoProducto tipoProducto) {
        try {
            TCliente cliente = this.clienteDAO.findById((Object)tipoProducto.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                RespSimple response = new RespSimple("Info", "Cliente no identificado", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TTipoProducto tipoDB = this.tipoProdDAO.findById((Object)tipoProducto.getIdTipoProducto()).orElse(null);
            if (tipoDB == null) {
                RespSimple response = new RespSimple("Info", "No existe el registro solicitado para actualizar", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            tipoDB.setActivo(tipoProducto.getActivo());
            tipoDB.setCodigo(tipoProducto.getCodigo());
            tipoDB.setDescripcion(tipoProducto.getDescripcion());
            tipoDB.setMovimiento(tipoProducto.getMovimiento());
            this.tipoProdDAO.save((Object)tipoDB);
            RespSimple response = new RespSimple("Info", "Tipo de producto actualizado", ContfiablesEnum.TRANSACCION_OK.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error: " + e.getMessage());
            RespSimple response = new RespSimple("Info", "Error al actualizar", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaTipoProducto(Long idCliente) {
        try {
            TCliente cliente = new TCliente();
            cliente.setIdCliente(idCliente);
            List listaTipos = this.tipoProdDAO.findByClienteOrderByIdTipoProductoDesc(cliente);
            RespSimple response = new RespSimple("Info", "Lista obtenida", ContfiablesEnum.TRANSACCION_OK.getId(), (Object)listaTipos);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al obtener la lista de tipos de identificacion", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerTipoProductoById(Long idCliente, Long idTipo) {
        TCliente cliente = new TCliente();
        RespSimple response = new RespSimple();
        cliente.setIdCliente(idCliente);
        TTipoProducto tipo = this.tipoProdDAO.findByClienteAndIdTipoProducto(cliente, idTipo);
        if (tipo == null) {
            response = new RespSimple("Info", "El tipo de producto solicitado no existe.", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
        response.setMensaje("Tipo de identidad obtenido");
        response.setData((Object)tipo);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<RespSimple> getDetCtaCont4TipoProd(Long idTipo) {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.tipoProdCuentaDAO.findByTipoProducto(new TTipoProducto(idTipo)));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Detalle obtenido");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener el detalle");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getTipoProductoActive(Long idCliente, Boolean activo) {
        return Transaccion.OK((String)"Lista obtenida", (Object)this.tipoProdDAO.getAllTipoProductoListDesc(idCliente, activo));
    }
}

