/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.ProductModelDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoFacturaMovilDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoMovilDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TTarifaIva;
import ec.tws2.back.contfiables.models.entities.integracion.TCodigosIce;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TMarca;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TSecuenciaProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TUnidadMedida;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDetalleDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TarifaIvaDAO;
import ec.tws2.back.contfiables.repositories.integracion.TCodigosIceDAO;
import ec.tws2.back.contfiables.repositories.inventario.TBodegaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TMarcaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TSecuenciaProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TUnidadMedidaDAO;
import ec.tws2.back.contfiables.services.ProductoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ProductoServiceImpl
implements ProductoService {
    private Logger log = Logger.getLogger(ProductoServiceImpl.class.getName());
    @Autowired
    private TFacturaDetalleDAO facturaDetalleDAO;
    @Autowired
    private TProductoDAO productosDAO;
    @Autowired
    private TarifaIvaDAO tarifaIvaDAO;
    @Autowired
    private TCodigosIceDAO codigosIceDAO;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TSecuenciaProductoDAO secuenciaProductoDAO;
    @Autowired
    private TBodegaDAO bodegaDAO;
    @Autowired
    private TInventarioDAO inventarioDAO;
    @Autowired
    private TUnidadMedidaDAO unidadMedidaDAO;
    @Autowired
    private TMarcaDAO marcaDAO;
    @Autowired
    private TTipoProductoDAO tipoProductoDAO;

    public List<ProductoFacturaMovilDTO> obtenerProductosFacturacionMovil(Long idCliente, String idProducto) {
        List<String> idProductosList = Arrays.asList(idProducto.split(","));
        return this.productosDAO.obtenerProductosFacturacionMovil(idCliente, idProductosList);
    }

    public List<TProducto> obtenerProductosAPIMOVILV1(Long idCliente, String idProducto) {
        return this.productosDAO.obtenerProductosMOVILV1(idCliente, idProducto);
    }

    public List<ProductoMovilDTO> obtenerProductosAPIMOVILV2(Long idCliente, String idProductosString) {
        List<String> idProductosList = Arrays.asList(idProductosString.split(","));
        return this.productosDAO.obtenerProductosMOVILV2(idCliente, idProductosList);
    }

    public List<TProducto> obtenerProductos(Long idCliente, String idProducto) {
        return this.productosDAO.obtenerProductos(idCliente, idProducto);
    }

    @Transactional
    public ResponseEntity<RespSimple> hacerProductoInventariable(Long idCliente, String idsProducts) {
        try {
            return Transaccion.CREATED((String)"CAMBIADOS CORRECTAMENTE");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.ERROR((String)e.getMessage());
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> guardarProductoClienteNEW(ProductModelDTO productoDTO) {
        this.log.info("GUARDANDO PRODUCTO");
        try {
            if (productoDTO.getIdTarifaIva() == null || productoDTO.getIdTarifaIva() == 0) {
                throw new CustomException("La tar\u00edfa del iva es requer\u00edda");
            }
            TCliente cliente = this.clienteDAO.findById((Object)productoDTO.getIdCliente()).orElse(null);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"Cliente no identificado");
            }
            TProducto producto = new TProducto();
            productoDTO.setPrecioUnitario(productoDTO.getPrecioUnitario().setScale(4, RoundingMode.HALF_UP));
            productoDTO.setCodigo(productoDTO.getCodigo().replace(" ", ""));
            if (productoDTO.getPrecioUnitario() == null || productoDTO.getPrecioUnitario().compareTo(BigDecimal.ZERO) < 0) {
                return Transaccion.CUSTOM_EXCEPTION((String)"Ingresar un precio mayor a cero");
            }
            if (productoDTO.getIdUnidadMedida() == null || productoDTO.getIdUnidadMedida() == 0L) {
                List idsUnidadMedida = this.unidadMedidaDAO.getIdsunidadMedida(cliente.getIdCliente());
                if (idsUnidadMedida.isEmpty()) {
                    throw new CustomException("La unidad de medida es requerida");
                }
                producto.setUnidadMedida(new TUnidadMedida((Long)idsUnidadMedida.get(0)));
            } else {
                producto.setUnidadMedida(new TUnidadMedida(productoDTO.getIdUnidadMedida()));
            }
            if (productoDTO.getIdTipoProducto() == null || productoDTO.getIdTipoProducto() == 0L) {
                List idsTipoProducto = this.tipoProductoDAO.getIdsTipoProducto(cliente.getIdCliente());
                if (idsTipoProducto.isEmpty()) {
                    throw new CustomException("El tipo de producto es requerido");
                }
                producto.setTipoProducto(new TTipoProducto((Long)idsTipoProducto.get(0)));
            } else {
                producto.setTipoProducto(new TTipoProducto(productoDTO.getIdTipoProducto()));
            }
            if (productoDTO.getIdMarca() == null || productoDTO.getIdMarca() == 0L) {
                List idsMarca = this.marcaDAO.getIdsMarca(cliente.getIdCliente());
                if (idsMarca.isEmpty()) {
                    throw new CustomException("La marca es requerida");
                }
                producto.setMarca(new TMarca((Long)idsMarca.get(0)));
            } else {
                producto.setMarca(new TMarca(productoDTO.getIdMarca()));
            }
            BigDecimal codigoIce = this.codigosIceDAO.getIdByCodigoIce(new BigDecimal("3000"));
            producto.setIdCodigoIce(new TCodigosIce(codigoIce));
            if (productoDTO.getId() == null || productoDTO.getId() == BigDecimal.ZERO) {
                TSecuenciaProducto tSecuenciaProducto = this.secuenciaProductoDAO.findByCliente(cliente);
                tSecuenciaProducto.setSecuencial(Integer.valueOf(tSecuenciaProducto.getSecuencial() + 1));
                this.secuenciaProductoDAO.save((Object)tSecuenciaProducto);
                if (this.productosDAO.existsByCodigoAndCliente(productoDTO.getCodigo(), cliente)) {
                    throw new CustomException("Producto no registrado, ya existe un producto con el c\u00f3digo: " + productoDTO.getCodigo());
                }
                producto.setNombreProducto(productoDTO.getNombreProducto());
                producto.setPrecioUnitario(productoDTO.getPrecioUnitario());
                producto.setInformacionAdicional(productoDTO.getInformacionAdicional());
                producto.setCodigo(productoDTO.getCodigo());
                producto.setCratedAt(new Date());
                producto.setStock(new BigDecimal(0));
                producto.setCostoCompra(new BigDecimal(0));
                producto.setUpdatedAt(new Date());
                producto.setStockMinimo(productoDTO.getStockMinimo());
                producto.setStockMaximo(productoDTO.getStockMaximo());
                producto.setMarketplace(productoDTO.getMarketplace());
                producto.setActivo(productoDTO.getActivo());
                producto.setIdTarifaIva(new TTarifaIva(productoDTO.getIdTarifaIva()));
                producto.setCliente(cliente);
                producto.setInventariable(productoDTO.getInventariable());
                if (producto.getInventariable().booleanValue()) {
                    TProducto prodGuardado = (TProducto)this.productosDAO.save((Object)producto);
                    List listBodegas = this.bodegaDAO.findByCliente(cliente);
                    if (listBodegas.size() > 0) {
                        for (TBodega b : listBodegas) {
                            TInventario inventario = new TInventario(b, prodGuardado);
                            this.inventarioDAO.save((Object)inventario);
                        }
                    }
                    return Transaccion.CREATED((String)"Producto guardado correctamente");
                }
                producto = (TProducto)this.productosDAO.save((Object)producto);
                return Transaccion.CREATED((String)"Producto guardado correctamente");
            }
            TProducto existeProductoBD = this.productosDAO.findByCodigoAndCliente(productoDTO.getCodigo(), cliente);
            if (existeProductoBD != null && existeProductoBD.getId().compareTo(productoDTO.getId()) != 0) {
                throw new CustomException("Producto no registrado, ya existe un producto con el c\u00f3digo: " + productoDTO.getCodigo());
            }
            TProducto tProducto = this.productosDAO.findById((Object)productoDTO.getId()).orElse(null);
            if (tProducto == null) {
                throw new CustomException("Error al encontrar el producto solicitado.");
            }
            if (!productoDTO.getInventariable().booleanValue()) {
                tProducto.setIdTarifaIva(new TTarifaIva(productoDTO.getIdTarifaIva()));
            } else {
                tProducto.setIdTarifaIva(new TTarifaIva(productoDTO.getIdTarifaIva()));
            }
            tProducto.setUpdatedAt(new Date());
            tProducto.setStockMinimo(productoDTO.getStockMinimo());
            tProducto.setStockMaximo(productoDTO.getStockMaximo());
            tProducto.setCodigo(productoDTO.getCodigo());
            tProducto.setInformacionAdicional(productoDTO.getInformacionAdicional());
            tProducto.setNombreProducto(productoDTO.getNombreProducto());
            tProducto.setPrecioUnitario(productoDTO.getPrecioUnitario());
            tProducto.setMarketplace(productoDTO.getMarketplace());
            tProducto.setActivo(productoDTO.getActivo());
            tProducto.setMarca(producto.getMarca());
            tProducto.setTipoProducto(producto.getTipoProducto());
            tProducto.setUnidadMedida(producto.getUnidadMedida());
            this.productosDAO.save((Object)tProducto);
            return Transaccion.CREATED((String)"Producto actualizado correctamente");
        }
        catch (CustomException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al actualizar producto".concat(e.getMessage()));
            return Transaccion.CUSTOM_EXCEPTION((String)e.getMessage());
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al guardar producto".concat(e.getMessage()));
            return Transaccion.ERROR((String)"Error al guardar el producto.");
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> guardarProductoCliente(TProducto producto) {
        RespSimple resp = new RespSimple();
        try {
            if (producto.getIdTarifaIva() == null || producto.getIdTarifaIva().getIdTarifaIva() == 0) {
                throw new CustomException("La tar\u00edfa es requer\u00edda");
            }
            TCliente cliente = this.clienteDAO.findById((Object)producto.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                resp.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                resp.setMensaje("Cliente no identificado");
                return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TCodigosIce codigoIce = this.codigosIceDAO.findByCodigoIce(new BigDecimal("3000"));
            producto.setIdCodigoIce(codigoIce);
            producto.setPrecioUnitario(producto.getPrecioUnitario().setScale(4, RoundingMode.HALF_UP));
            producto.setCodigo(producto.getCodigo().replace(" ", ""));
            if (producto.getUnidadMedida() == null || producto.getUnidadMedida().getIdUnidadMedida() == 0L) {
                List idsUnidadMedida = this.unidadMedidaDAO.getIdsunidadMedida(cliente.getIdCliente());
                if (idsUnidadMedida.isEmpty()) {
                    throw new CustomException("La unidad de medida es requerida");
                }
                producto.setUnidadMedida(new TUnidadMedida((Long)idsUnidadMedida.get(0)));
            }
            if (producto.getTipoProducto() == null || producto.getTipoProducto().getIdTipoProducto() == 0L) {
                List idsTipoProducto = this.tipoProductoDAO.getIdsTipoProducto(cliente.getIdCliente());
                if (idsTipoProducto.isEmpty()) {
                    throw new CustomException("El tipo de producto es requerido");
                }
                producto.setTipoProducto(new TTipoProducto((Long)idsTipoProducto.get(0)));
            }
            if (producto.getMarca() == null || producto.getMarca().getIdMarca() == 0L) {
                List idsMarca = this.marcaDAO.getIdsMarca(cliente.getIdCliente());
                if (idsMarca.isEmpty()) {
                    throw new CustomException("La marca es requerida");
                }
                producto.setMarca(new TMarca((Long)idsMarca.get(0)));
            }
            if (producto.getId() == null || producto.getId() == BigDecimal.ZERO) {
                TSecuenciaProducto tSecuenciaProducto = this.secuenciaProductoDAO.findByCliente(cliente);
                tSecuenciaProducto.setSecuencial(Integer.valueOf(tSecuenciaProducto.getSecuencial() + 1));
                this.secuenciaProductoDAO.save((Object)tSecuenciaProducto);
                if (this.productosDAO.existsByCodigoAndCliente(producto.getCodigo(), cliente)) {
                    throw new CustomException("Producto no registrado, ya existe un producto con el c\u00f3digo: " + producto.getCodigo());
                }
                producto.setCratedAt(new Date());
                producto.setStock(new BigDecimal(0));
                producto.setCostoCompra(new BigDecimal(0));
                if (producto.getInventariable().booleanValue()) {
                    TProducto prodGuardado = (TProducto)this.productosDAO.save((Object)producto);
                    List listBodegas = this.bodegaDAO.findByCliente(cliente);
                    if (listBodegas.size() > 0) {
                        for (TBodega b : listBodegas) {
                            TInventario inventario = new TInventario(b, prodGuardado);
                            this.inventarioDAO.save((Object)inventario);
                        }
                    }
                    resp.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                    resp.setMensaje("Producto guardado correctamente");
                    return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.CREATED);
                }
                this.productosDAO.save((Object)producto);
                resp.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                resp.setMensaje("Producto guardado correctamente");
                return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.CREATED);
            }
            TProducto existeProductoBD = this.productosDAO.findByCodigoAndCliente(producto.getCodigo(), cliente);
            if (existeProductoBD != null && existeProductoBD.getId().compareTo(producto.getId()) != 0) {
                throw new CustomException("Producto no registrado, ya existe un producto con el c\u00f3digo: " + producto.getCodigo());
            }
            TProducto tProducto = this.productosDAO.findById((Object)producto.getId()).orElse(null);
            if (tProducto == null) {
                throw new CustomException("Error al encontrar el producto solicitado.");
            }
            if (!producto.getInventariable().booleanValue()) {
                tProducto.setIdTarifaIva(producto.getIdTarifaIva());
            }
            tProducto.setUpdatedAt(new Date());
            tProducto.setStockMinimo(producto.getStockMinimo());
            tProducto.setStockMaximo(producto.getStockMaximo());
            tProducto.setCodigo(producto.getCodigo());
            tProducto.setInformacionAdicional(producto.getInformacionAdicional());
            tProducto.setNombreProducto(producto.getNombreProducto());
            tProducto.setPrecioUnitario(producto.getPrecioUnitario().setScale(4, RoundingMode.HALF_UP));
            tProducto.setMarketplace(producto.getMarketplace());
            tProducto.setActivo(producto.getActivo());
            tProducto.setMarca(producto.getMarca());
            tProducto.setUnidadMedida(producto.getUnidadMedida());
            tProducto.setTipoProducto(producto.getTipoProducto());
            this.productosDAO.save((Object)tProducto);
            resp.setMensaje("Producto actualizado correctamente");
            resp.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al actualizar producto".concat(e.getMessage()));
            resp.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            resp.setMensaje(e.getMessage());
            return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al guardar producto".concat(e.getMessage()));
            resp.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            resp.setMensaje("Error al guardar el producto.");
            return new ResponseEntity((Object)resp, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public List<TTarifaIva> enlistarIva() {
        return this.tarifaIvaDAO.enlistarIva();
    }

    public TProducto obtenerProducto(BigDecimal idProducto) {
        return (TProducto)this.productosDAO.findById((Object)idProducto).get();
    }

    public String obtenerNombreProducto(BigDecimal idProducto) {
        return this.productosDAO.obtenerNombreProducto(idProducto);
    }

    public String obtenerCodigoProducto(BigDecimal idProducto) {
        return this.productosDAO.obtenerCodigoProducto(idProducto);
    }

    public BigDecimal obtenerPrecioProducto(BigDecimal idProducto) {
        return this.productosDAO.obtenerPrecioProducto(idProducto);
    }

    public int obtenerIvaProducto(BigDecimal idProducto) {
        return this.productosDAO.obtenerIvaProducto(idProducto);
    }

    public int obtenerIdTarifaIva(BigDecimal idProducto) {
        return this.productosDAO.obtenerIdTarifaIva(idProducto);
    }

    public List<TProducto> obtenerProductosFront(Long idCliente) {
        try {
            return this.productosDAO.obtenerProductosFront(idCliente);
        }
        catch (DataAccessException e) {
            return new ArrayList<TProducto>();
        }
    }

    public List<TInventario> filtrarProductosInventariablesByQuery(Long idBodega, Long idCliente, String query, Boolean activo) {
        return this.inventarioDAO.filtrarProductosQuery(idBodega, idCliente, query.toLowerCase());
    }

    public List<TInventario> filtrarProductosInventariablesByQueryFacturacion(Long idBodega, Long idCliente, String query) {
        PageRequest pageable = PageRequest.of((int)0, (int)5);
        return this.inventarioDAO.filtrarProductosQueryFacturacion(idBodega, idCliente, query.toLowerCase(), (Pageable)pageable);
    }

    public List<TProducto> filtrarProductosNoInventariablesByQuery(Long idCliente, String query) {
        PageRequest pageable = PageRequest.of((int)0, (int)8);
        return this.productosDAO.filtrarProductosNoInventariables(idCliente, query.toLowerCase(), (Pageable)pageable);
    }

    public ResponseEntity<RespSimple> getProductoInventarioByIdProducto(Long idProducto) {
        RespSimple response = new RespSimple();
        try {
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Producto obtenido");
            TInventario inventario = this.inventarioDAO.findById((Object)idProducto).orElse(null);
            response.setData((Object)inventario);
            if (inventario == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Producto no obtenido");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Producto no obtenido" + e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getProductoByCode(String codigo, Long idBodega, Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            TProducto producto = this.productosDAO.findByCodigoAndClienteAndActivo(codigo, new TCliente(idCliente), Boolean.valueOf(true));
            if (producto == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("No existe el producto solicitado");
                response.setDescripcion("");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            if (producto.getInventariable().booleanValue()) {
                TInventario proInventariable = this.inventarioDAO.filtrarByBodegaAndCodigoProducto(idBodega, producto.getCodigo());
                if (proInventariable == null) {
                    response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    response.setMensaje("No existe el producto solicitado, o no tiene stock");
                    response.setDescripcion("");
                    return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                response.setMensaje("producto obtenido");
                response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                response.setDescripcion("inv");
                response.setData((Object)proInventariable);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
            response.setMensaje("producto obtenido");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setDescripcion("noivn");
            response.setData((Object)producto);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.log.severe("error: " + e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener el producto solicitado");
            response.setDescripcion("");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getProductsWithMinStockCount(Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.inventarioDAO.countProductHasMinStock(idCliente));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("cantidad de productos con stock minimo obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("error al obtener la cantidad de productos con stock minimo");
            response.setDescripcion(e.getMessage());
            response.setData((Object)0);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getProductsWithMinStock(Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.inventarioDAO.findProductHasMinStock(idCliente));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Productos con stock minimo obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener los productos con stock m\u00ednimo");
            response.setDescripcion(e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public List<ProductoInvenFacturacionDTO> filtrarProductosFacturacion(Long idBodega, Long idCliente, String query) {
        PageRequest pageable = PageRequest.of((int)0, (int)5);
        ArrayList<ProductoInvenFacturacionDTO> productos = new ArrayList<ProductoInvenFacturacionDTO>();
        productos.addAll(this.inventarioDAO.filtrarProductosQueryFacturacionDTO(idBodega, idCliente, query, (Pageable)pageable));
        productos.addAll(this.productosDAO.filtrarProductosQueryFacturacionDTO(idCliente, query, (Pageable)pageable));
        return productos;
    }

    public ResponseEntity<RespSimple> obtenerProductosDTOFront(Long idCliente) {
        return Transaccion.OK((String)"Lista obtenida", (Object)this.productosDAO.obtenerProductosFrontCustom(idCliente));
    }

    public ResponseEntity<RespSimple> getProductDTO(Long idProducto) {
        try {
            return Transaccion.OK((String)"Producto obtenido", (Object)this.productosDAO.getProductoDTO(idProducto));
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener el producto");
        }
    }

    public ResponseEntity<RespSimple> restablecerInventarioFactura(BigDecimal idFactura) {
        this.facturaDetalleDAO.buscarDetalleByIdFactura(idFactura);
        return null;
    }

    public Long obtenerSiguienteSecuencia(Long idCliente) {
        try {
            TCliente cliente = new TCliente(idCliente);
            TSecuenciaProducto seq = this.secuenciaProductoDAO.findByCliente(cliente);
            if (seq == null) {
                return 1L;
            }
            return seq.getSecuencial() + 1;
        }
        catch (Exception e) {
            this.log.severe("Error getting sequence: " + e.getMessage());
            return 1L;
        }
    }
}

