/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.inventario.TComponente;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TProductoComponente;
import ec.tws2.back.contfiables.repositories.inventario.TComponenteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoComponenteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.services.ProductoComponenteService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ProductoComponenteServiceImpl
implements ProductoComponenteService {
    @Autowired
    private TProductoComponenteDAO productoComponenteDAO;
    @Autowired
    private TProductoDAO productoDAO;
    @Autowired
    private TComponenteDAO componenteDAO;

    public ResponseEntity<RespSimple> obtenerComponentesProducto(Long idProducto) {
        return Transaccion.OK((String)"Lista obtenida", (Object)this.productoComponenteDAO.listarComponentesAsignados(idProducto));
    }

    public ResponseEntity<RespSimple> vincularComponente(BigDecimal idProducto, BigDecimal idComponente) {
        TProducto producto = (TProducto)this.productoDAO.findById((Object)idProducto).orElseThrow(() -> new RuntimeException("Producto no encontrado"));
        TComponente componente = (TComponente)this.componenteDAO.findById((Object)idComponente).orElseThrow(() -> new RuntimeException("Componente no encontrado"));
        TProductoComponente pc = new TProductoComponente();
        pc.setIdProducto(producto);
        pc.setIdComponente(componente);
        pc.setActivo(Boolean.valueOf(true));
        TProductoComponente saved = (TProductoComponente)this.productoComponenteDAO.save((Object)pc);
        HashMap<String, Serializable> resumen = new HashMap<String, Serializable>();
        resumen.put("idProductoComponente", saved.getIdProductoComponente());
        resumen.put("idProducto", saved.getIdProducto().getId());
        resumen.put("idComponente", saved.getIdComponente().getIdComponente());
        resumen.put("activo", saved.getActivo());
        resumen.put("createdAt", saved.getCreatedAt());
        return Transaccion.OK((String)"Componente vinculado correctamente", resumen);
    }

    public ResponseEntity<RespSimple> eliminarVinculacion(Long idProductoComponente) {
        TProductoComponente vinculo = (TProductoComponente)this.productoComponenteDAO.findById((Object)idProductoComponente).orElseThrow(() -> new RuntimeException("Vinculaci\u00f3n no encontrada"));
        vinculo.setActivo(Boolean.valueOf(false));
        vinculo.setUpdatedAt(LocalDateTime.now());
        this.productoComponenteDAO.save((Object)vinculo);
        HashMap<String, Serializable> resumen = new HashMap<String, Serializable>();
        resumen.put("idProductoComponente", vinculo.getIdProductoComponente());
        resumen.put("idProducto", vinculo.getIdProducto().getId());
        resumen.put("idComponente", vinculo.getIdComponente().getIdComponente());
        resumen.put("activo", vinculo.getActivo());
        resumen.put("updatedAt", vinculo.getUpdatedAt());
        return Transaccion.OK((String)"Vinculaci\u00f3n eliminada correctamente", resumen);
    }
}

