/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.inventario.TMarca;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TMarcaDAO;
import ec.tws2.back.contfiables.services.MarcaService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarcaServiceImpl
implements MarcaService {
    @Autowired
    private TMarcaDAO marcaDAO;
    @Autowired
    TClienteDAO clienteDAO;

    @Transactional
    public ResponseEntity<RespSimple> guardarMarca(TMarca marca) {
        try {
            TCliente cliente = this.clienteDAO.findById((Object)marca.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"Error al identificar el cliente.");
            }
            boolean existe = this.marcaDAO.existsByClienteAndAbreviatura(marca.getCliente(), marca.getAbreviatura());
            if (existe) {
                return Transaccion.CUSTOM_EXCEPTION((String)"Ya existe un registro con esos datos");
            }
            this.marcaDAO.save((Object)marca);
            RespSimple response = new RespSimple("Info", "Marca creada", ContfiablesEnum.TRANSACCION_OK.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al registrar la marca", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> actualizarMarca(TMarca marca) {
        try {
            TCliente cliente = this.clienteDAO.findById((Object)marca.getCliente().getIdCliente()).orElse(null);
            if (cliente == null) {
                RespSimple response = new RespSimple("Info", "Error al identificar el cliente.", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TMarca marcaDB = this.marcaDAO.findById((Object)marca.getIdMarca()).orElse(null);
            if (marcaDB == null) {
                RespSimple response = new RespSimple("Info", "No existe un registro con ese id", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            marcaDB.setAbreviatura(marca.getAbreviatura());
            marcaDB.setDescripcion(marca.getDescripcion());
            marcaDB.setActivo(marca.getActivo());
            this.marcaDAO.save((Object)marcaDB);
            RespSimple response = new RespSimple("Info", "Marca actualizada", ContfiablesEnum.TRANSACCION_OK.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al actualizar los campos de marca", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaMarca(Long idCliente) {
        try {
            RespSimple response = new RespSimple("Info", "Lista obtenida", ContfiablesEnum.TRANSACCION_OK.getId(), (Object)this.marcaDAO.getAllMarcasDesc(idCliente));
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al listar las marcas", ContfiablesEnum.TRANSACCION_ERROR.getId(), new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

