/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.util.AsignarHoraDATE;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TFacturaDetalle;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TKardex;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoComprobanteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TKardexDAO;
import ec.tws2.back.contfiables.services.KardexService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KardexServiceImpl
implements KardexService {
    @Autowired
    private TKardexDAO kardexDAO;
    @Autowired
    private TTipoComprobanteDAO tipoComprobateDAO;
    @Autowired
    private TInventarioDAO inventarioDAO;

    @Transactional
    public ResponseEntity<RespSimple> registrarMovimientoKardex(TKardex kardex) {
        RespSimple response = new RespSimple();
        try {
            kardex.setFechaMovimiento(new Date());
            this.kardexDAO.save((Object)kardex);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al ingresar un nuevo movimiento de kardex");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return null;
    }

    public ResponseEntity<RespSimple> obtenerKardexPorFechas(Long idBodega, Long idCliente, Long idProducto, Date fechaInicial, Date fechaFinal) {
        RespSimple response = new RespSimple();
        if (idCliente != null && fechaInicial != null && fechaFinal != null) {
            fechaInicial = new AsignarHoraDATE().asiganarHora(fechaInicial, "inicio");
            fechaFinal = new AsignarHoraDATE().asiganarHora(fechaFinal, "fin");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Lista de kardex obtenida");
            List listaKardex = this.kardexDAO.findByBodegaAndClienteAndProductoAndFechaMovimientoBetween(new TBodega(idBodega), new TCliente(idCliente), new TProducto(idProducto), fechaInicial, fechaFinal);
            response.setData((Object)listaKardex);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
        response.setMensaje("Error al obtener los datos solicitados");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public void registrarEgresoVenta(TFacturaDetalle facturaDetalle, TFactura factura, String tipoComprobantePrefijo) {
        LocalDateTime fechaHoraEcuador = LocalDateTime.now(ZoneId.of("America/Guayaquil"));
        TProducto producto = facturaDetalle.getIdProducto();
        TInventario productoInventario = this.inventarioDAO.findByBodegaAndProducto(factura.getBodega(), producto);
        BigDecimal cantidadSaliente = facturaDetalle.getCantidad();
        BigDecimal costoUnitActual = productoInventario.getCostoUnitario();
        TKardex kardex = new TKardex();
        TTipoComprobante tipoComprobante = this.tipoComprobateDAO.findByPrefijo(tipoComprobantePrefijo);
        kardex.setTipoComprobante(tipoComprobante);
        kardex.setTipoMovimiento("EGR");
        kardex.setBodega(factura.getBodega());
        kardex.setCliente(factura.getCliente());
        kardex.setClienteProveedor(factura.getIdAdquiriente().getIdentificacion() + " - " + factura.getIdAdquiriente().getRazonSocial());
        kardex.setComprobante(fechaHoraEcuador.getYear() + "-" + kardex.getTipoComprobante().getPrefijo() + "-" + factura.getPuntoVenta().getEstablecimiento().getEstablecimiento() + "-" + factura.getPuntoVenta().getPuntoEmision() + "-" + factura.getNumComprobante());
        kardex.setDetalle("EGRESO POR VENTA FACTURA");
        kardex.setEntradaCantidad(BigDecimal.ZERO);
        kardex.setEntradaCostoTotal(BigDecimal.ZERO);
        kardex.setEntradaCostoUnitario(BigDecimal.ZERO);
        kardex.setFechaMovimiento(new Date());
        kardex.setSalidaCantidad(cantidadSaliente);
        kardex.setSalidaPvpUnitario(facturaDetalle.getValorTotal().setScale(4, RoundingMode.HALF_UP));
        kardex.setSalidaTotal(facturaDetalle.getValorTotal().multiply(facturaDetalle.getCantidad()).setScale(4, RoundingMode.HALF_UP));
        BigDecimal impuestos = BigDecimal.ZERO;
        BigDecimal subtDet = cantidadSaliente.multiply(facturaDetalle.getValorTotal());
        BigDecimal descDet = subtDet.multiply(facturaDetalle.getDescuento().divide(new BigDecimal(100))).setScale(4, RoundingMode.HALF_UP);
        subtDet = subtDet.subtract(descDet).setScale(4, RoundingMode.HALF_UP);
        BigDecimal impDet = subtDet.multiply(facturaDetalle.getTarifa().divide(new BigDecimal(100))).setScale(4, RoundingMode.HALF_UP);
        impuestos = impuestos.add(impDet);
        kardex.setImpuestos(impuestos);
        if (producto.getIdTarifaIva() != null && producto.getIdTarifaIva().getPorcentaje() != null) {
            try {
                kardex.setValorIva(Long.valueOf(producto.getIdTarifaIva().getPorcentaje().intValue()));
            }
            catch (NumberFormatException e) {
                kardex.setValorIva(Long.valueOf(0L));
            }
        } else {
            kardex.setValorIva(Long.valueOf(0L));
        }
        kardex.setExistenciaCantidad(productoInventario.getStock());
        kardex.setExistenciaCostoTotal(productoInventario.getCostoTotal());
        kardex.setExistenciaCostoUnitario(productoInventario.getCostoUnitario());
        kardex.setProducto(producto);
        this.kardexDAO.save((Object)kardex);
    }
}

